/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geomgraph;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geomgraph.Edge;
import org.locationtech.jts.geomgraph.EdgeIntersection;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.legacy.map.TreeMap;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0086\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u001a\u001a\u00020\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u001cJ\u0016\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0005\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/geomgraph/EdgeIntersectionList;", "", "edge", "Lorg/locationtech/jts/geomgraph/Edge;", "<init>", "(Lorg/locationtech/jts/geomgraph/Edge;)V", "nodeMap", "", "Lorg/locationtech/jts/geomgraph/EdgeIntersection;", "getEdge", "()Lorg/locationtech/jts/geomgraph/Edge;", "setEdge", "add", "intPt", "Lorg/locationtech/jts/geom/Coordinate;", "segmentIndex", "", "dist", "", "iterator", "", "isIntersection", "", "pt", "addEndpoints", "", "addSplitEdges", "edgeList", "", "createSplitEdge", "ei0", "ei1", "kts-core"})
public final class EdgeIntersectionList {
    @NotNull
    private final Map<EdgeIntersection, Object> nodeMap;
    @NotNull
    private Edge edge;

    public EdgeIntersectionList(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        this.nodeMap = new TreeMap(null, 1, null);
        this.edge = edge;
    }

    @NotNull
    public final Edge getEdge() {
        return this.edge;
    }

    public final void setEdge(@NotNull Edge edge) {
        Intrinsics.checkNotNullParameter((Object)edge, (String)"<set-?>");
        this.edge = edge;
    }

    @NotNull
    public final EdgeIntersection add(@Nullable Coordinate intPt, int segmentIndex, double dist) {
        EdgeIntersection eiNew = new EdgeIntersection(intPt, segmentIndex, dist);
        EdgeIntersection ei = (EdgeIntersection)this.nodeMap.get(eiNew);
        if (ei != null) {
            return ei;
        }
        this.nodeMap.put(eiNew, eiNew);
        return eiNew;
    }

    @NotNull
    public final Iterator<?> iterator() {
        return this.nodeMap.values().iterator();
    }

    public final boolean isIntersection(@Nullable Coordinate pt) {
        Iterator<?> it = this.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
            EdgeIntersection ei = (EdgeIntersection)obj;
            if (!Intrinsics.areEqual((Object)ei.getCoord(), (Object)pt)) continue;
            return true;
        }
        return false;
    }

    public final void addEndpoints() {
        int maxSegIndex = this.edge.getPts().length - 1;
        this.add(this.edge.getPts()[0], 0, 0.0);
        this.add(this.edge.getPts()[maxSegIndex], maxSegIndex, 0.0);
    }

    public final void addSplitEdges(@NotNull List<Edge> edgeList) {
        Intrinsics.checkNotNullParameter(edgeList, (String)"edgeList");
        this.addEndpoints();
        Iterator<?> it = this.iterator();
        Object obj = it.next();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
        EdgeIntersection eiPrev = (EdgeIntersection)obj;
        while (it.hasNext()) {
            Object obj2 = it.next();
            Intrinsics.checkNotNull(obj2, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.EdgeIntersection");
            EdgeIntersection ei = (EdgeIntersection)obj2;
            Edge newEdge = this.createSplitEdge(eiPrev, ei);
            edgeList.add(newEdge);
            eiPrev = ei;
        }
    }

    @NotNull
    public final Edge createSplitEdge(@NotNull EdgeIntersection ei0, @NotNull EdgeIntersection ei1) {
        int n;
        boolean useIntPt1;
        Intrinsics.checkNotNullParameter((Object)ei0, (String)"ei0");
        Intrinsics.checkNotNullParameter((Object)ei1, (String)"ei1");
        int npts = ei1.getSegmentIndex() - ei0.getSegmentIndex() + 2;
        Coordinate lastSegStartPt = this.edge.getPts()[ei1.getSegmentIndex()];
        boolean bl = useIntPt1 = ei1.getDist() > 0.0 || !ei1.getCoord().equals2D(lastSegStartPt);
        if (!useIntPt1) {
            --npts;
        }
        Object[] pts = new Coordinate[npts];
        int ipt = 0;
        pts[ipt++] = new Coordinate(ei0.getCoord());
        int i = ei0.getSegmentIndex() + 1;
        if (i <= (n = ei1.getSegmentIndex())) {
            while (true) {
                pts[ipt++] = this.edge.getPts()[i];
                if (i == n) break;
                ++i;
            }
        }
        if (useIntPt1) {
            pts[ipt] = ei1.getCoord();
        }
        Coordinate[] coordinateArray = (Coordinate[])ArraysKt.requireNoNulls((Object[])pts);
        Label label = this.edge.getLabel();
        Intrinsics.checkNotNull((Object)label);
        return new Edge(coordinateArray, new Label(label));
    }
}

