/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0000J\n\u0010\u0017\u001a\u00020\u0018H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\r\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/index/quadtree/DoubleBits;", "", "x", "", "<init>", "(D)V", "xBits", "", "double", "getDouble", "()D", "biasedExponent", "", "exponent", "getExponent", "()I", "zeroLowerBits", "", "nBits", "getBit", "i", "numCommonMantissaBits", "db", "toString", "", "Companion", "kts-core"})
public final class DoubleBits {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private long xBits;
    public static final int EXPONENT_BIAS = 1023;

    public DoubleBits(double x) {
        this.x = x;
        this.xBits = Math.INSTANCE.doubleToLongBits(this.x);
    }

    public final double getDouble() {
        return Math.INSTANCE.longBitsToDouble(this.xBits);
    }

    public final int biasedExponent() {
        int signExp = (int)(this.xBits >> 52);
        return signExp & 0x7FF;
    }

    public final int getExponent() {
        return this.biasedExponent() - 1023;
    }

    public final void zeroLowerBits(int nBits) {
        long invMask = (1L << nBits) - 1L;
        long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
        this.xBits &= mask;
    }

    public final int getBit(int i) {
        long mask = 1L << i;
        return (this.xBits & mask) != 0L ? 1 : 0;
    }

    public final int numCommonMantissaBits(@NotNull DoubleBits db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        for (int i = 0; i < 52; ++i) {
            if (this.getBit(i) == db.getBit(i)) continue;
            return i;
        }
        return 52;
    }

    @NotNull
    public String toString() {
        String numStr = Math.INSTANCE.toBinaryString(this.xBits);
        String zero64 = "0000000000000000000000000000000000000000000000000000000000000000";
        String padStr = zero64 + numStr;
        String string = padStr.substring(padStr.length() - 64);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String bitStr = string;
        String string2 = bitStr.substring(0, 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String string3 = bitStr.substring(1, 12);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        int n = this.getExponent();
        String string4 = bitStr.substring(12);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        return string2 + "  " + string3 + "(" + n + ") " + string4 + " [ " + this.x + " ]";
    }

    @JvmStatic
    public static final double powerOf2(int exp) {
        return Companion.powerOf2(exp);
    }

    @JvmStatic
    public static final int exponent(double d) {
        return Companion.exponent(d);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0007J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/index/quadtree/DoubleBits$Companion;", "", "<init>", "()V", "EXPONENT_BIAS", "", "powerOf2", "", "exp", "exponent", "d", "truncateToPowerOfTwo", "toBinaryString", "", "maximumCommonMantissa", "d1", "d2", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double powerOf2(int exp) {
            if (exp > 1023 || exp < -1022) {
                throw new IllegalArgumentException("Exponent out of bounds");
            }
            long expBias = exp + 1023;
            long bits = expBias << 52;
            return Math.INSTANCE.longBitsToDouble(bits);
        }

        @JvmStatic
        public final int exponent(double d) {
            DoubleBits db = new DoubleBits(d);
            return db.getExponent();
        }

        public final double truncateToPowerOfTwo(double d) {
            DoubleBits db = new DoubleBits(d);
            db.zeroLowerBits(52);
            return db.getDouble();
        }

        @NotNull
        public final String toBinaryString(double d) {
            DoubleBits db = new DoubleBits(d);
            return db.toString();
        }

        public final double maximumCommonMantissa(double d1, double d2) {
            if (d1 == 0.0 || d2 == 0.0) {
                return 0.0;
            }
            DoubleBits db1 = new DoubleBits(d1);
            DoubleBits db2 = new DoubleBits(d2);
            if (db1.getExponent() != db2.getExponent()) {
                return 0.0;
            }
            int maxCommon = db1.numCommonMantissaBits(db2);
            db1.zeroLowerBits(64 - (12 + maxCommon));
            return db1.getDouble();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

