/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.quadtree.Node;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000 /2\u00060\u0001j\u0002`\u0002:\u0001/B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0007J\u001a\u0010\u0019\u001a\u00020\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0006\u0010\u001e\u001a\u00020\u0015J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0012\u0010\"\u001a\u00020\u00152\b\u0010#\u001a\u0004\u0018\u00010\u001bH$J\u001e\u0010$\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0018\u0010%\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'J\u001a\u0010(\u001a\u00020\u00172\b\u0010#\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020*R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0084\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u001c\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001f\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010,\u001a\u00020*8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u00060"}, d2={"Lorg/locationtech/jts/index/quadtree/NodeBase;", "Ljava/io/Serializable;", "Lorg/locationtech/jts/legacy/Serializable;", "<init>", "()V", "items", "", "", "getItems", "()Ljava/util/List;", "setItems", "(Ljava/util/List;)V", "subnode", "", "Lorg/locationtech/jts/index/quadtree/Node;", "getSubnode", "()[Lorg/locationtech/jts/index/quadtree/Node;", "setSubnode", "([Lorg/locationtech/jts/index/quadtree/Node;)V", "[Lorg/locationtech/jts/index/quadtree/Node;", "hasItems", "", "add", "", "item", "remove", "itemEnv", "Lorg/locationtech/jts/geom/Envelope;", "isPrunable", "()Z", "hasChildren", "isEmpty", "addAllItems", "resultItems", "isSearchMatch", "searchEnv", "addAllItemsFromOverlapping", "visit", "visitor", "Lorg/locationtech/jts/index/ItemVisitor;", "visitItems", "depth", "", "size", "nodeCount", "getNodeCount", "()I", "Companion", "kts-core"})
public abstract class NodeBase
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<Object> items = new ArrayList();
    @NotNull
    private Node[] subnode = new Node[4];

    @NotNull
    public final List<Object> getItems() {
        return this.items;
    }

    public final void setItems(@NotNull List<Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.items = list;
    }

    @NotNull
    protected final Node[] getSubnode() {
        return this.subnode;
    }

    protected final void setSubnode(@NotNull Node[] nodeArray) {
        Intrinsics.checkNotNullParameter((Object)nodeArray, (String)"<set-?>");
        this.subnode = nodeArray;
    }

    public final boolean hasItems() {
        return !((Collection)this.items).isEmpty();
    }

    public final void add(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.items.add(item);
    }

    public final boolean remove(@Nullable Envelope itemEnv, @Nullable Object item) {
        if (!this.isSearchMatch(itemEnv)) {
            return false;
        }
        boolean found = false;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            found = node.remove(itemEnv, item);
            if (!found) continue;
            Node node2 = this.subnode[i];
            Intrinsics.checkNotNull((Object)node2);
            if (!node2.isPrunable()) break;
            this.subnode[i] = null;
            break;
        }
        if (found) {
            return found;
        }
        found = TypeIntrinsics.asMutableCollection((Object)this.items).remove(item);
        return found;
    }

    public final boolean isPrunable() {
        return !this.hasChildren() && !this.hasItems();
    }

    public final boolean hasChildren() {
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            return true;
        }
        return false;
    }

    public final boolean isEmpty() {
        boolean isEmpty = true;
        if (!((Collection)this.items).isEmpty()) {
            isEmpty = false;
        } else {
            for (int i = 0; i < 4; ++i) {
                if (this.subnode[i] == null) continue;
                Node node = this.subnode[i];
                Intrinsics.checkNotNull((Object)node);
                if (node.isEmpty()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    @NotNull
    public final List<Object> addAllItems(@NotNull List<Object> resultItems) {
        Intrinsics.checkNotNullParameter(resultItems, (String)"resultItems");
        resultItems.addAll((Collection<Object>)this.items);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            node.addAllItems(resultItems);
        }
        return resultItems;
    }

    protected abstract boolean isSearchMatch(@Nullable Envelope var1);

    public final void addAllItemsFromOverlapping(@Nullable Envelope searchEnv, @NotNull List<Object> resultItems) {
        Intrinsics.checkNotNullParameter(resultItems, (String)"resultItems");
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        resultItems.addAll((Collection<Object>)this.items);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            node.addAllItemsFromOverlapping(searchEnv, resultItems);
        }
    }

    public final void visit(@Nullable Envelope searchEnv, @NotNull ItemVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        if (!this.isSearchMatch(searchEnv)) {
            return;
        }
        this.visitItems(searchEnv, visitor);
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            node.visit(searchEnv, visitor);
        }
    }

    private final void visitItems(Envelope searchEnv, ItemVisitor visitor) {
        int n = ((Collection)this.items).size();
        for (int i = 0; i < n; ++i) {
            visitor.visitItem(this.items.get(i));
        }
    }

    public final int depth() {
        int maxSubDepth = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            int sqd = node.depth();
            if (sqd <= maxSubDepth) continue;
            maxSubDepth = sqd;
        }
        return maxSubDepth + 1;
    }

    public final int size() {
        int subSize = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            subSize += node.size();
        }
        return subSize + this.items.size();
    }

    public final int getNodeCount() {
        int subSize = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.subnode[i] == null) continue;
            Node node = this.subnode[i];
            Intrinsics.checkNotNull((Object)node);
            subSize += node.size();
        }
        return subSize + 1;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/index/quadtree/NodeBase$Companion;", "", "<init>", "()V", "getSubnodeIndex", "", "env", "Lorg/locationtech/jts/geom/Envelope;", "centrex", "", "centrey", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getSubnodeIndex(@Nullable Envelope env, double centrex, double centrey) {
            int subnodeIndex = -1;
            Envelope envelope = env;
            Intrinsics.checkNotNull((Object)envelope);
            if (envelope.getMinX() >= centrex) {
                if (env.getMinY() >= centrey) {
                    subnodeIndex = 3;
                }
                if (env.getMaxY() <= centrey) {
                    subnodeIndex = 1;
                }
            }
            if (env.getMaxX() <= centrex) {
                if (env.getMinY() >= centrey) {
                    subnodeIndex = 2;
                }
                if (env.getMaxY() <= centrey) {
                    subnodeIndex = 0;
                }
            }
            return subnodeIndex;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

