/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.quadtree.IntervalSize;
import org.locationtech.jts.index.quadtree.Node;
import org.locationtech.jts.index.quadtree.NodeBase;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/index/quadtree/Root;", "Lorg/locationtech/jts/index/quadtree/NodeBase;", "<init>", "()V", "insert", "", "itemEnv", "Lorg/locationtech/jts/geom/Envelope;", "item", "", "insertContained", "tree", "Lorg/locationtech/jts/index/quadtree/Node;", "isSearchMatch", "", "searchEnv", "Companion", "kts-core"})
public final class Root
extends NodeBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Coordinate origin = new Coordinate(0.0, 0.0);

    public final void insert(@NotNull Envelope itemEnv, @NotNull Object item) {
        int index;
        block5: {
            Node largerNode;
            Node node;
            block4: {
                Intrinsics.checkNotNullParameter((Object)itemEnv, (String)"itemEnv");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                index = NodeBase.Companion.getSubnodeIndex(itemEnv, Root.origin.x, Root.origin.y);
                if (index == -1) {
                    this.add(item);
                    return;
                }
                node = this.getSubnode()[index];
                if (node == null) break block4;
                Envelope envelope = node.getEnvelope();
                Intrinsics.checkNotNull((Object)envelope);
                if (envelope.contains(itemEnv)) break block5;
            }
            this.getSubnode()[index] = largerNode = Node.Companion.createExpanded(node, itemEnv);
        }
        Node node = this.getSubnode()[index];
        Intrinsics.checkNotNull((Object)node);
        this.insertContained(node, itemEnv, item);
    }

    private final void insertContained(Node tree, Envelope itemEnv, Object item) {
        Envelope envelope = tree.getEnvelope();
        Intrinsics.checkNotNull((Object)envelope);
        Assert.isTrue(envelope.contains(itemEnv));
        boolean isZeroX = IntervalSize.INSTANCE.isZeroWidth(itemEnv.getMinX(), itemEnv.getMaxX());
        boolean isZeroY = IntervalSize.INSTANCE.isZeroWidth(itemEnv.getMinY(), itemEnv.getMaxY());
        NodeBase node = isZeroX || isZeroY ? tree.find(itemEnv) : (NodeBase)tree.getNode(itemEnv);
        node.add(item);
    }

    @Override
    protected boolean isSearchMatch(@Nullable Envelope searchEnv) {
        return true;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/locationtech/jts/index/quadtree/Root$Companion;", "", "<init>", "()V", "origin", "Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

