/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io.kml;

import java.io.Closeable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0002-.B#\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0017\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006J\u001d\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002J)\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00062\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0011\"\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010%J8\u0010&\u001a\b\u0012\u0004\u0012\u0002H'0\u0011\"\u0006\b\u0000\u0010'\u0018\u00012\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H'0+H\u0082\b\u00a2\u0006\u0002\u0010,R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/locationtech/jts/io/kml/KMLReader;", "", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "attributeNames", "", "", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;Ljava/util/Collection;)V", "(Ljava/util/Collection;)V", "inputFactory", "Ljavax/xml/stream/XMLInputFactory;", "", "read", "Lorg/locationtech/jts/geom/Geometry;", "kmlGeometryString", "parseKMLCoordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "xmlStreamReader", "Ljavax/xml/stream/XMLStreamReader;", "(Ljavax/xml/stream/XMLStreamReader;)[Lorg/locationtech/jts/geom/Coordinate;", "parseKMLCoordinatesAndAttributes", "Lorg/locationtech/jts/io/kml/KMLReader$KMLCoordinatesAndAttributes;", "objectNodeName", "parseKMLPoint", "parseKMLLineString", "parseKMLPolygon", "parseKMLMultiGeometry", "parseKML", "moveToElement", "", "elementName", "endElementName", "raiseParseError", "template", "parameters", "(Ljava/lang/String;[Ljava/lang/Object;)V", "prepareTypedArray", "T", "geometryList", "", "geomClass", "Ljava/lang/Class;", "(Ljava/util/List;Ljava/lang/Class;)[Ljava/lang/Object;", "KMLCoordinatesAndAttributes", "Companion", "kts-core"})
@SourceDebugExtension(value={"SMAP\nKMLReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KMLReader.kt\norg/locationtech/jts/io/kml/KMLReader\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,324:1\n306#1:327\n306#1:334\n306#1:341\n37#2,2:325\n37#2,2:332\n37#2,2:339\n37#2,2:346\n37#2,2:348\n37#2,2:350\n37#2,2:356\n1586#3:328\n1661#3,3:329\n1586#3:335\n1661#3,3:336\n1586#3:342\n1661#3,3:343\n1586#3:352\n1661#3,3:353\n*S KotlinDebug\n*F\n+ 1 KMLReader.kt\norg/locationtech/jts/io/kml/KMLReader\n*L\n224#1:327\n231#1:334\n238#1:341\n110#1:325,2\n224#1:332,2\n231#1:339,2\n238#1:346,2\n245#1:348,2\n249#1:350,2\n306#1:356,2\n224#1:328\n224#1:329,3\n231#1:335\n231#1:336,3\n238#1:342\n238#1:343,3\n306#1:352\n306#1:353,3\n*E\n"})
public final class KMLReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final XMLInputFactory inputFactory;
    @NotNull
    private final Set<String> attributeNames;
    @NotNull
    private static final String POINT = "Point";
    @NotNull
    private static final String LINESTRING = "LineString";
    @NotNull
    private static final String POLYGON = "Polygon";
    @NotNull
    private static final String MULTIGEOMETRY = "MultiGeometry";
    @NotNull
    private static final String COORDINATES = "coordinates";
    @NotNull
    private static final String OUTER_BOUNDARY_IS = "outerBoundaryIs";
    @NotNull
    private static final String INNER_BOUNDARY_IS = "innerBoundaryIs";
    @NotNull
    private static final String NO_ELEMENT_ERROR = "No element %s found in %s";

    @JvmOverloads
    public KMLReader(@NotNull GeometryFactory geometryFactory, @NotNull Collection<String> attributeNames) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        Intrinsics.checkNotNullParameter(attributeNames, (String)"attributeNames");
        this.geometryFactory = geometryFactory;
        XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)xMLInputFactory, (String)"newInstance(...)");
        this.inputFactory = xMLInputFactory;
        this.attributeNames = new HashSet<String>(attributeNames);
    }

    public /* synthetic */ KMLReader(GeometryFactory geometryFactory, Collection collection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            geometryFactory = new GeometryFactory();
        }
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(geometryFactory, collection);
    }

    public KMLReader(@NotNull Collection<String> attributeNames) {
        Intrinsics.checkNotNullParameter(attributeNames, (String)"attributeNames");
        this(new GeometryFactory(), attributeNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Geometry read(@Nullable String kmlGeometryString) throws ParseException {
        try {
            Closeable closeable = new StringReader(kmlGeometryString);
            Throwable throwable = null;
            try {
                StringReader sr = (StringReader)closeable;
                boolean bl = false;
                XMLStreamReader xMLStreamReader = this.inputFactory.createXMLStreamReader(sr);
                Intrinsics.checkNotNullExpressionValue((Object)xMLStreamReader, (String)"createXMLStreamReader(...)");
                XMLStreamReader xmlSr = xMLStreamReader;
                Geometry geometry = this.parseKML(xmlSr);
                return geometry;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (XMLStreamException e) {
            throw new ParseException(e);
        }
    }

    private final Coordinate[] parseKMLCoordinates(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        String string = xmlStreamReader.getElementText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getElementText(...)");
        String coordinates = string;
        if (((CharSequence)coordinates).length() == 0) {
            this.raiseParseError("Empty coordinates", new Object[0]);
        }
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        double[] parsedOrdinates = dArray;
        List coordinateList = new ArrayList();
        int spaceIdx = StringsKt.indexOf$default((CharSequence)coordinates, (char)' ', (int)0, (boolean)false, (int)6, null);
        int currentIdx = 0;
        while (currentIdx < coordinates.length()) {
            String coordinate;
            if (spaceIdx == -1) {
                spaceIdx = coordinates.length();
            }
            Intrinsics.checkNotNullExpressionValue((Object)coordinates.substring(currentIdx, spaceIdx), (String)"substring(...)");
            int yOrdinateComma = StringsKt.indexOf$default((CharSequence)coordinate, (char)',', (int)0, (boolean)false, (int)6, null);
            if (yOrdinateComma == -1 || yOrdinateComma == coordinate.length() - 1 || yOrdinateComma == 0) {
                this.raiseParseError("Invalid coordinate format", new Object[0]);
            }
            String string2 = coordinate.substring(0, yOrdinateComma);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            parsedOrdinates[0] = Double.parseDouble(string2);
            int zOrdinateComma = StringsKt.indexOf$default((CharSequence)coordinate, (char)',', (int)(yOrdinateComma + 1), (boolean)false, (int)4, null);
            if (zOrdinateComma == -1) {
                String string3 = coordinate.substring(yOrdinateComma + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                parsedOrdinates[1] = Double.parseDouble(string3);
            } else {
                String string4 = coordinate.substring(yOrdinateComma + 1, zOrdinateComma);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                parsedOrdinates[1] = Double.parseDouble(string4);
                String string5 = coordinate.substring(zOrdinateComma + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                parsedOrdinates[2] = Double.parseDouble(string5);
            }
            Coordinate crd = new Coordinate(parsedOrdinates[0], parsedOrdinates[1], parsedOrdinates[2]);
            this.geometryFactory.getPrecisionModel().makePrecise(crd);
            coordinateList.add(crd);
            currentIdx = spaceIdx + 1;
            spaceIdx = StringsKt.indexOf$default((CharSequence)coordinates, (char)' ', (int)currentIdx, (boolean)false, (int)4, null);
            parsedOrdinates[2] = Double.NaN;
            parsedOrdinates[1] = parsedOrdinates[2];
            parsedOrdinates[0] = parsedOrdinates[1];
        }
        Collection $this$toTypedArray$iv = coordinateList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Coordinate[0]);
    }

    private final KMLCoordinatesAndAttributes parseKMLCoordinatesAndAttributes(XMLStreamReader xmlStreamReader, String objectNodeName) throws XMLStreamException, ParseException {
        Coordinate[] coordinates = null;
        Map attributes = null;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)objectNodeName))) {
            if (xmlStreamReader.isStartElement()) {
                String elementName;
                Intrinsics.checkNotNullExpressionValue((Object)xmlStreamReader.getLocalName(), (String)"getLocalName(...)");
                if (Intrinsics.areEqual((Object)elementName, (Object)COORDINATES)) {
                    coordinates = this.parseKMLCoordinates(xmlStreamReader);
                } else if (this.attributeNames.contains(elementName)) {
                    if (attributes == null) {
                        attributes = new HashMap();
                    }
                    attributes.put(elementName, xmlStreamReader.getElementText());
                }
            }
            xmlStreamReader.next();
        }
        if (coordinates == null) {
            Object[] objectArray = new Object[]{COORDINATES, objectNodeName};
            this.raiseParseError(NO_ELEMENT_ERROR, objectArray);
        }
        return new KMLCoordinatesAndAttributes(coordinates, attributes);
    }

    private final Geometry parseKMLPoint(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        KMLCoordinatesAndAttributes kmlCoordinatesAndAttributes = this.parseKMLCoordinatesAndAttributes(xmlStreamReader, POINT);
        Coordinate[] coordinateArray = kmlCoordinatesAndAttributes.getCoordinates();
        Intrinsics.checkNotNull((Object)coordinateArray);
        Point point = this.geometryFactory.createPoint(coordinateArray[0]);
        point.setUserData(kmlCoordinatesAndAttributes.getAttributes());
        return point;
    }

    private final Geometry parseKMLLineString(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        KMLCoordinatesAndAttributes kmlCoordinatesAndAttributes = this.parseKMLCoordinatesAndAttributes(xmlStreamReader, LINESTRING);
        Object[] objectArray = kmlCoordinatesAndAttributes.getCoordinates();
        Intrinsics.checkNotNull((Object)objectArray);
        LineString lineString = this.geometryFactory.createLineString((Coordinate[])ArraysKt.requireNoNulls((Object[])objectArray));
        lineString.setUserData(kmlCoordinatesAndAttributes.getAttributes());
        return lineString;
    }

    private final Geometry parseKMLPolygon(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        LinearRing shell = null;
        ArrayList<LinearRing> holes = null;
        Map attributes = null;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)POLYGON))) {
            if (xmlStreamReader.isStartElement()) {
                String elementName;
                Intrinsics.checkNotNullExpressionValue((Object)xmlStreamReader.getLocalName(), (String)"getLocalName(...)");
                if (Intrinsics.areEqual((Object)elementName, (Object)OUTER_BOUNDARY_IS)) {
                    this.moveToElement(xmlStreamReader, COORDINATES, OUTER_BOUNDARY_IS);
                    shell = this.geometryFactory.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])this.parseKMLCoordinates(xmlStreamReader)));
                } else if (Intrinsics.areEqual((Object)elementName, (Object)INNER_BOUNDARY_IS)) {
                    this.moveToElement(xmlStreamReader, COORDINATES, INNER_BOUNDARY_IS);
                    if (holes == null) {
                        holes = new ArrayList<LinearRing>();
                    }
                    holes.add(this.geometryFactory.createLinearRing((Coordinate[])ArraysKt.requireNoNulls((Object[])this.parseKMLCoordinates(xmlStreamReader))));
                } else if (this.attributeNames.contains(elementName)) {
                    if (attributes == null) {
                        attributes = new HashMap();
                    }
                    attributes.put(elementName, xmlStreamReader.getElementText());
                }
            }
            xmlStreamReader.next();
        }
        if (shell == null) {
            this.raiseParseError("No outer boundary for Polygon", new Object[0]);
        }
        ArrayList<LinearRing> arrayList = holes;
        Polygon polygon = this.geometryFactory.createPolygon(shell, arrayList == null ? null : arrayList.toArray(new LinearRing[0]));
        polygon.setUserData(attributes);
        return polygon;
    }

    /*
     * Unable to fully structure code
     */
    private final Geometry parseKMLMultiGeometry(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        block37: {
            block35: {
                geometries = new ArrayList<E>();
                firstParsedType = null;
                allTypesAreSame = true;
                while (xmlStreamReader.hasNext()) {
                    block34: {
                        if (!xmlStreamReader.isStartElement()) break block34;
                        Intrinsics.checkNotNullExpressionValue((Object)xmlStreamReader.getLocalName(), (String)"getLocalName(...)");
                        var6_6 = elementName;
                        switch (var6_6.hashCode()) {
                            case 1806700869: {
                                if (!var6_6.equals("LineString")) {
                                    break;
                                }
                                ** GOTO lbl23
                            }
                            case 77292912: {
                                if (!var6_6.equals("Point")) {
                                    break;
                                }
                                ** GOTO lbl23
                            }
                            case 89139371: {
                                if (!var6_6.equals("MultiGeometry")) {
                                    break;
                                }
                                ** GOTO lbl23
                            }
                            case 1267133722: {
                                if (!var6_6.equals("Polygon")) break;
lbl23:
                                // 4 sources

                                geometry = this.parseKML(xmlStreamReader);
                                if (firstParsedType == null) {
                                    v0 = geometry;
                                    Intrinsics.checkNotNull((Object)v0);
                                    firstParsedType = v0.getGeometryType();
                                } else {
                                    v1 = geometry;
                                    Intrinsics.checkNotNull((Object)v1);
                                    if (!Intrinsics.areEqual((Object)firstParsedType, (Object)v1.getGeometryType())) {
                                        allTypesAreSame = false;
                                    }
                                }
                                geometries.add(geometry);
                            }
                        }
                    }
                    xmlStreamReader.next();
                }
                if (geometries.isEmpty()) {
                    return null;
                }
                if (geometries.size() == 1) {
                    return (Geometry)geometries.get(0);
                }
                if (!allTypesAreSame) break block35;
                elementName = firstParsedType;
                if (elementName == null) ** GOTO lbl-1000
                tmp = -1;
                switch (elementName.hashCode()) {
                    case 1806700869: {
                        if (elementName.equals("LineString")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 77292912: {
                        if (elementName.equals("Point")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 1267133722: {
                        if (elementName.equals("Polygon")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 2: {
                        var6_6 = this;
                        geometry = geometries;
                        var8_10 = Point.class;
                        var20_14 = this.geometryFactory;
                        $i$f$prepareTypedArray = false;
                        $this$map$iv$iv = geometryList$iv;
                        $i$f$map = false;
                        var12_26 = $this$map$iv$iv;
                        destination$iv$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                            var17_41 = (Geometry)item$iv$iv$iv;
                            var18_44 = destination$iv$iv$iv;
                            $i$a$-map-KMLReader$prepareTypedArray$1$iv = false;
                            v2 = it$iv;
                            if (v2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.locationtech.jts.geom.Point");
                            }
                            var18_44.add((Point)v2);
                        }
                        $this$map$iv$iv = (List)destination$iv$iv$iv;
                        $i$f$toTypedArray = false;
                        thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                        v3 = var20_14.createMultiPoint(thisCollection$iv$iv.toArray(new Point[0]));
                        break;
                    }
                    case 1: {
                        this_$iv = this;
                        geometryList$iv = geometries;
                        geomClass$iv = LineString.class;
                        var20_15 = this.geometryFactory;
                        $i$f$prepareTypedArray = false;
                        $this$map$iv$iv = geometryList$iv;
                        $i$f$map = false;
                        thisCollection$iv$iv = $this$map$iv$iv;
                        destination$iv$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                            it$iv = (Geometry)item$iv$iv$iv;
                            var18_45 = destination$iv$iv$iv;
                            $i$a$-map-KMLReader$prepareTypedArray$1$iv = false;
                            v4 = it$iv;
                            if (v4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
                            }
                            var18_45.add((LineString)v4);
                        }
                        $this$map$iv$iv = (List)destination$iv$iv$iv;
                        $i$f$toTypedArray = false;
                        thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                        v3 = var20_15.createMultiLineString(thisCollection$iv$iv.toArray(new LineString[0]));
                        break;
                    }
                    case 3: {
                        this_$iv = this;
                        geometryList$iv = geometries;
                        geomClass$iv = Polygon.class;
                        var20_16 = this.geometryFactory;
                        $i$f$prepareTypedArray = false;
                        $this$map$iv$iv = geometryList$iv;
                        $i$f$map = false;
                        thisCollection$iv$iv = $this$map$iv$iv;
                        destination$iv$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                            it$iv = (Geometry)item$iv$iv$iv;
                            var18_46 = destination$iv$iv$iv;
                            $i$a$-map-KMLReader$prepareTypedArray$1$iv = false;
                            v5 = it$iv;
                            if (v5 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                            }
                            var18_46.add((Polygon)v5);
                        }
                        $this$map$iv$iv = (List)destination$iv$iv$iv;
                        $i$f$toTypedArray = false;
                        thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                        v3 = var20_16.createMultiPolygon(thisCollection$iv$iv.toArray(new Polygon[0]));
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        $this$toTypedArray$iv = geometries;
                        $i$f$toTypedArray = false;
                        thisCollection$iv = $this$toTypedArray$iv;
                        v3 = this.geometryFactory.createGeometryCollection(thisCollection$iv.toArray(new Geometry[0]));
                    }
                }
                v6 = v3;
                break block37;
            }
            $this$toTypedArray$iv = geometries;
            $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            v6 = this.geometryFactory.createGeometryCollection(thisCollection$iv.toArray(new Geometry[0]));
        }
        return v6;
    }

    private final Geometry parseKML(XMLStreamReader xmlStreamReader) throws XMLStreamException, ParseException {
        Object[] elementName;
        boolean hasElement = false;
        while (xmlStreamReader.hasNext()) {
            if (xmlStreamReader.isStartElement()) {
                hasElement = true;
                break;
            }
            xmlStreamReader.next();
        }
        if (!hasElement) {
            this.raiseParseError("Invalid KML format", new Object[0]);
        }
        Object[] objectArray = xmlStreamReader.getLocalName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getLocalName(...)");
        switch (elementName = objectArray) {
            case "Point": {
                return this.parseKMLPoint(xmlStreamReader);
            }
            case "LineString": {
                return this.parseKMLLineString(xmlStreamReader);
            }
            case "Polygon": {
                return this.parseKMLPolygon(xmlStreamReader);
            }
            case "MultiGeometry": {
                xmlStreamReader.next();
                return this.parseKMLMultiGeometry(xmlStreamReader);
            }
        }
        Object[] objectArray2 = new Object[]{elementName};
        this.raiseParseError("Unknown KML geometry type %s", objectArray2);
        return null;
    }

    private final void moveToElement(XMLStreamReader xmlStreamReader, String elementName, String endElementName) throws XMLStreamException, ParseException {
        boolean elementFound = false;
        while (!(!xmlStreamReader.hasNext() || xmlStreamReader.isEndElement() && Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)endElementName))) {
            if (xmlStreamReader.isStartElement() && Intrinsics.areEqual((Object)xmlStreamReader.getLocalName(), (Object)elementName)) {
                elementFound = true;
                break;
            }
            xmlStreamReader.next();
        }
        if (!elementFound) {
            Object[] objectArray = new Object[]{elementName, endElementName};
            this.raiseParseError(NO_ELEMENT_ERROR, objectArray);
        }
    }

    private final void raiseParseError(String template, Object ... parameters) throws ParseException {
        Object[] objectArray = Arrays.copyOf(parameters, parameters.length);
        String string = String.format(template, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        throw new ParseException(string);
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T> T[] prepareTypedArray(List<? extends Geometry> geometryList, Class<T> geomClass) {
        void $this$toTypedArray$iv;
        void $this$mapTo$iv$iv;
        boolean $i$f$prepareTypedArray = false;
        Iterable $this$map$iv = geometryList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Geometry geometry = (Geometry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            collection.add(it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = (Collection)$this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"T?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    @JvmOverloads
    public KMLReader(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this(geometryFactory, null, 2, null);
    }

    @JvmOverloads
    public KMLReader() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/io/kml/KMLReader$Companion;", "", "<init>", "()V", "POINT", "", "LINESTRING", "POLYGON", "MULTIGEOMETRY", "COORDINATES", "OUTER_BOUNDARY_IS", "INNER_BOUNDARY_IS", "NO_ELEMENT_ERROR", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B3\u0012\u0010\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u001d\u0010\u0002\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR#\u0010\u0005\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/locationtech/jts/io/kml/KMLReader$KMLCoordinatesAndAttributes;", "", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "attributes", "", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;Ljava/util/Map;)V", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "getAttributes", "()Ljava/util/Map;", "kts-core"})
    private static final class KMLCoordinatesAndAttributes {
        @Nullable
        private final Coordinate[] coordinates;
        @Nullable
        private final Map<String, String> attributes;

        public KMLCoordinatesAndAttributes(@Nullable Coordinate[] coordinates, @Nullable Map<String, String> attributes) {
            this.coordinates = coordinates;
            this.attributes = attributes;
        }

        @Nullable
        public final Coordinate[] getCoordinates() {
            return this.coordinates;
        }

        @Nullable
        public final Map<String, String> getAttributes() {
            return this.attributes;
        }
    }
}

