/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.legacy.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.legacy.queue.AbstractQueue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010)\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 0*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00010B-\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0018\b\u0002\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0007j\b\u0012\u0004\u0012\u00028\u0000`\b\u00a2\u0006\u0004\b\t\u0010\nB\u0017\b\u0016\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0018\u0010\u0011\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0096\u0080\bJ\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004J\u001a\u0010\u0015\u001a\u0016\u0012\u0006\b\u0000\u0012\u00028\u00000\u0007j\n\u0012\u0006\b\u0000\u0012\u00028\u0000`\bJ\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0082\u0004J\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u000f\u0010\u001d\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010\u001f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0017\u0010 \u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010!\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0096\u0080\bJ\u0018\u0010\"\u001a\u00020\u00122\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0096\u0080\bJ\u0010\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0018\u0010)\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u0005H\u0002J\u0012\u0010+\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010,H\u0002J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0005H\u0002J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010/\u001a\u00020\u0005H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0007j\b\u0012\u0004\u0012\u00028\u0000`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000fj\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001`\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u0010#\u001a\u00020\u00058VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u00061"}, d2={"Lorg/locationtech/jts/legacy/queue/PriorityQueue;", "E", "", "Lorg/locationtech/jts/legacy/queue/AbstractQueue;", "initialCapacity", "", "cmp", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "<init>", "(ILjava/util/Comparator;)V", "c", "", "(Ljava/util/Collection;)V", "heap", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addAll", "", "clear", "", "comparator", "contains", "o", "(Ljava/lang/Comparable;)Z", "iterator", "", "offer", "e", "peek", "()Ljava/lang/Comparable;", "poll", "remove", "removeAll", "retainAll", "size", "getSize", "()I", "makeHeap", "node", "mergeHeaps", "getSmallestChild", "heapSize", "indexOf", "", "isLeaf", "removeAtIndex", "index", "Companion", "kts-core"})
public final class PriorityQueue<E extends Comparable<? super E>>
extends AbstractQueue<E> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Comparator<E> cmp;
    @Nullable
    private ArrayList<E> heap;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;

    @JvmOverloads
    public PriorityQueue(int initialCapacity, @NotNull Comparator<E> cmp) {
        Intrinsics.checkNotNullParameter(cmp, (String)"cmp");
        this.cmp = cmp;
        this.heap = new ArrayList(initialCapacity);
    }

    public /* synthetic */ PriorityQueue(int n, Comparator comparator, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 11;
        }
        if ((n2 & 2) != 0) {
            comparator = ComparisonsKt.naturalOrder();
        }
        this(n, comparator);
    }

    public PriorityQueue(@NotNull Collection<? extends E> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this(c.size(), null, 2, null);
        this.addAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this.checkArgument(c != this);
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        int oldSize = arrayList.size();
        for (Comparable e : c) {
            ArrayList<Comparable> arrayList2 = this.heap;
            Intrinsics.checkNotNull(arrayList2);
            arrayList2.add(e);
        }
        ArrayList<E> arrayList3 = this.heap;
        Intrinsics.checkNotNull(arrayList3);
        if (oldSize != arrayList3.size()) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        arrayList.clear();
    }

    @NotNull
    public final Comparator<? super E> comparator() {
        return ComparisonsKt.nullsLast(this.cmp);
    }

    @Override
    public boolean contains(@NotNull E o) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        return this.indexOf(o) != -1;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new Iterator<E>(this){
            private int i;
            private int last;
            final /* synthetic */ PriorityQueue<E> this$0;
            {
                this.this$0 = $receiver;
                this.last = -1;
            }

            public final int getI() {
                return this.i;
            }

            public final void setI(int n) {
                this.i = n;
            }

            public final int getLast() {
                return this.last;
            }

            public final void setLast(int n) {
                this.last = n;
            }

            public boolean hasNext() {
                ArrayList arrayList = PriorityQueue.access$getHeap$p(this.this$0);
                Intrinsics.checkNotNull((Object)arrayList);
                return this.i < arrayList.size();
            }

            public E next() {
                this.this$0.checkElement(this.hasNext());
                int n = this.i;
                this.i = n + 1;
                this.last = n;
                ArrayList arrayList = PriorityQueue.access$getHeap$p(this.this$0);
                Intrinsics.checkNotNull((Object)arrayList);
                E e = arrayList.get(this.last);
                Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                return (E)((Comparable)e);
            }

            /*
             * WARNING - void declaration
             */
            public void remove() {
                void it;
                int n;
                this.this$0.checkState(this.last != -1);
                int n2 = n = this.last;
                PriorityQueue<E> priorityQueue = this.this$0;
                boolean bl = false;
                this.i = it;
                PriorityQueue.access$removeAtIndex(priorityQueue, n);
                this.last = -1;
            }
        };
    }

    @Override
    public boolean offer(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        this.checkCriticalNotNull(e);
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        int node = arrayList.size();
        ArrayList<E> arrayList2 = this.heap;
        Intrinsics.checkNotNull(arrayList2);
        arrayList2.add(e);
        while (node > 0) {
            int childNode = node;
            node = PriorityQueue.Companion.getParent(node);
            ArrayList<E> arrayList3 = this.heap;
            Intrinsics.checkNotNull(arrayList3);
            if (this.cmp.compare(arrayList3.get(node), e) <= 0) {
                ArrayList<E> arrayList4 = this.heap;
                Intrinsics.checkNotNull(arrayList4);
                arrayList4.set(childNode, e);
                return true;
            }
            ArrayList<E> arrayList5 = this.heap;
            Intrinsics.checkNotNull(arrayList5);
            ArrayList<E> arrayList6 = this.heap;
            Intrinsics.checkNotNull(arrayList6);
            arrayList5.set(childNode, arrayList6.get(node));
        }
        ArrayList<E> arrayList7 = this.heap;
        Intrinsics.checkNotNull(arrayList7);
        arrayList7.set(node, e);
        return true;
    }

    @Override
    @Nullable
    public E peek() {
        Comparable comparable;
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        if (arrayList.isEmpty()) {
            comparable = null;
        } else {
            ArrayList<E> arrayList2 = this.heap;
            Intrinsics.checkNotNull(arrayList2);
            comparable = (Comparable)arrayList2.get(0);
        }
        return (E)comparable;
    }

    @Override
    @Nullable
    public E poll() {
        Object value = this.peek();
        if (value != null) {
            this.removeAtIndex(0);
        }
        return (E)value;
    }

    @Override
    public boolean remove(@NotNull E o) {
        Intrinsics.checkNotNullParameter(o, (String)"o");
        int index = this.indexOf(o);
        if (index < 0) {
            return false;
        }
        this.removeAtIndex(index);
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        if (arrayList.removeAll(c)) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        if (arrayList.retainAll(c)) {
            this.makeHeap(0);
            return true;
        }
        return false;
    }

    public int getSize() {
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        return arrayList.size();
    }

    private final void makeHeap(int node) {
        if (this.isLeaf(node)) {
            return;
        }
        this.makeHeap(PriorityQueue.Companion.getLeftChild(node));
        int rightChild = PriorityQueue.Companion.getRightChild(node);
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        if (rightChild < arrayList.size()) {
            this.makeHeap(rightChild);
        }
        this.mergeHeaps(node);
    }

    private final void mergeHeaps(int node) {
        int node2 = node;
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        int heapSize = arrayList.size();
        ArrayList<E> arrayList2 = this.heap;
        Intrinsics.checkNotNull(arrayList2);
        E e = arrayList2.get(node2);
        Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
        Comparable value = (Comparable)e;
        while (!PriorityQueue.Companion.isLeaf(node2, heapSize)) {
            int smallestChild = this.getSmallestChild(node2, heapSize);
            ArrayList<E> arrayList3 = this.heap;
            Intrinsics.checkNotNull(arrayList3);
            if (this.cmp.compare(value, arrayList3.get(smallestChild)) < 0) break;
            ArrayList<E> arrayList4 = this.heap;
            Intrinsics.checkNotNull(arrayList4);
            ArrayList<E> arrayList5 = this.heap;
            Intrinsics.checkNotNull(arrayList5);
            arrayList4.set(node2, arrayList5.get(smallestChild));
            node2 = smallestChild;
        }
        ArrayList<Comparable> arrayList6 = this.heap;
        Intrinsics.checkNotNull(arrayList6);
        arrayList6.set(node2, value);
    }

    private final int getSmallestChild(int node, int heapSize) {
        int smallestChild = 0;
        int leftChild = PriorityQueue.Companion.getLeftChild(node);
        int rightChild = leftChild + 1;
        smallestChild = leftChild;
        if (rightChild < heapSize) {
            ArrayList<E> arrayList = this.heap;
            Intrinsics.checkNotNull(arrayList);
            E e = arrayList.get(rightChild);
            ArrayList<E> arrayList2 = this.heap;
            Intrinsics.checkNotNull(arrayList2);
            if (this.cmp.compare(e, arrayList2.get(leftChild)) < 0) {
                smallestChild = rightChild;
            }
        }
        return smallestChild;
    }

    private final int indexOf(Object o) {
        int n;
        if (o == null) {
            n = -1;
        } else {
            ArrayList<E> arrayList = this.heap;
            Intrinsics.checkNotNull(arrayList);
            n = CollectionsKt.indexOf((List)arrayList, (Object)o);
        }
        return n;
    }

    private final boolean isLeaf(int node) {
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        return PriorityQueue.Companion.isLeaf(node, arrayList.size());
    }

    private final void removeAtIndex(int index) {
        ArrayList<E> arrayList = this.heap;
        Intrinsics.checkNotNull(arrayList);
        ArrayList<E> arrayList2 = this.heap;
        Intrinsics.checkNotNull(arrayList2);
        E e = arrayList.remove(arrayList2.size() - 1);
        Intrinsics.checkNotNullExpressionValue(e, (String)"removeAt(...)");
        Comparable lastValue = (Comparable)e;
        ArrayList<E> arrayList3 = this.heap;
        Intrinsics.checkNotNull(arrayList3);
        if (index < arrayList3.size()) {
            ArrayList<Comparable> arrayList4 = this.heap;
            Intrinsics.checkNotNull(arrayList4);
            arrayList4.set(index, lastValue);
            this.mergeHeaps(index);
        }
    }

    @JvmOverloads
    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null, 2, null);
    }

    @JvmOverloads
    public PriorityQueue() {
        this(0, null, 3, null);
    }

    public static final /* synthetic */ ArrayList access$getHeap$p(PriorityQueue $this) {
        return $this.heap;
    }

    public static final /* synthetic */ void access$removeAtIndex(PriorityQueue $this, int index) {
        $this.removeAtIndex(index);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/locationtech/jts/legacy/queue/PriorityQueue$Companion;", "", "<init>", "()V", "DEFAULT_INITIAL_CAPACITY", "", "getLeftChild", "node", "getParent", "getRightChild", "isLeaf", "", "size", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int getLeftChild(int node) {
            return 2 * node + 1;
        }

        private final int getParent(int node) {
            return (node - 1) / 2;
        }

        private final int getRightChild(int node) {
            return 2 * node + 2;
        }

        private final boolean isLeaf(int node, int size) {
            return node * 2 + 1 >= size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

