/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.linearref.ExtractLineByLocation;
import org.locationtech.jts.linearref.LengthIndexOfPoint;
import org.locationtech.jts.linearref.LengthLocationMap;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexOfLine;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u0018\u0010\u0014\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\tJ\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003J\u0010\u0010\u0019\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001b\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/linearref/LengthIndexedLine;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "extractPoint", "Lorg/locationtech/jts/geom/Coordinate;", "index", "", "offsetDistance", "extractLine", "startIndex", "endIndex", "locationOf", "Lorg/locationtech/jts/linearref/LinearLocation;", "resolveLower", "", "indexOf", "pt", "indexOfAfter", "minIndex", "indicesOf", "", "subLine", "project", "getStartIndex", "()D", "getEndIndex", "isValidIndex", "clampIndex", "positiveIndex", "kts-core"})
public final class LengthIndexedLine {
    @NotNull
    private final Geometry linearGeom;

    public LengthIndexedLine(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        this.linearGeom = linearGeom;
    }

    @NotNull
    public final Coordinate extractPoint(double index) {
        LinearLocation loc = LengthLocationMap.Companion.getLocation(this.linearGeom, index);
        return loc.getCoordinate(this.linearGeom);
    }

    @NotNull
    public final Coordinate extractPoint(double index, double offsetDistance) {
        LinearLocation loc = LengthLocationMap.Companion.getLocation(this.linearGeom, index);
        LinearLocation locLow = loc.toLowest(this.linearGeom);
        return locLow.getSegment(this.linearGeom).pointAlongOffset(locLow.getSegmentFraction(), offsetDistance);
    }

    @Nullable
    public final Geometry extractLine(double startIndex, double endIndex) {
        double endIndex2;
        double startIndex2 = this.clampIndex(startIndex);
        boolean resolveStartLower = startIndex2 == (endIndex2 = this.clampIndex(endIndex));
        LinearLocation startLoc = this.locationOf(startIndex2, resolveStartLower);
        LinearLocation endLoc = this.locationOf(endIndex2);
        return ExtractLineByLocation.Companion.extract(this.linearGeom, startLoc, endLoc);
    }

    private final LinearLocation locationOf(double index) {
        return LengthLocationMap.Companion.getLocation(this.linearGeom, index);
    }

    private final LinearLocation locationOf(double index, boolean resolveLower) {
        return LengthLocationMap.Companion.getLocation(this.linearGeom, index, resolveLower);
    }

    public final double indexOf(@Nullable Coordinate pt) {
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return LengthIndexOfPoint.Companion.indexOf(this.linearGeom, coordinate);
    }

    public final double indexOfAfter(@Nullable Coordinate pt, double minIndex) {
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return LengthIndexOfPoint.Companion.indexOfAfter(this.linearGeom, coordinate, minIndex);
    }

    @NotNull
    public final double[] indicesOf(@Nullable Geometry subLine) {
        Geometry geometry = subLine;
        Intrinsics.checkNotNull((Object)geometry);
        LinearLocation[] locIndex = LocationIndexOfLine.Companion.indicesOf(this.linearGeom, geometry);
        double[] dArray = new double[]{LengthLocationMap.Companion.getLength(this.linearGeom, locIndex[0]), LengthLocationMap.Companion.getLength(this.linearGeom, locIndex[1])};
        return dArray;
    }

    public final double project(@Nullable Coordinate pt) {
        Coordinate coordinate = pt;
        Intrinsics.checkNotNull((Object)coordinate);
        return LengthIndexOfPoint.Companion.indexOf(this.linearGeom, coordinate);
    }

    public final double getStartIndex() {
        return 0.0;
    }

    public final double getEndIndex() {
        return this.linearGeom.getLength();
    }

    public final boolean isValidIndex(double index) {
        double d = this.getStartIndex();
        return index <= this.getEndIndex() ? d <= index : false;
    }

    public final double clampIndex(double index) {
        double startIndex;
        double posIndex = this.positiveIndex(index);
        if (posIndex < (startIndex = this.getStartIndex())) {
            return startIndex;
        }
        double endIndex = this.getEndIndex();
        return posIndex > endIndex ? endIndex : posIndex;
    }

    private final double positiveIndex(double index) {
        return index >= 0.0 ? index : this.linearGeom.getLength() + index;
    }
}

