/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/linearref/LengthLocationMap;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "getLocation", "Lorg/locationtech/jts/linearref/LinearLocation;", "length", "", "resolveLower", "", "getLocationForward", "resolveHigher", "loc", "getLength", "Companion", "kts-core"})
public final class LengthLocationMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry linearGeom;

    public LengthLocationMap(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        this.linearGeom = linearGeom;
    }

    @NotNull
    public final LinearLocation getLocation(double length) {
        return this.getLocation(length, true);
    }

    @NotNull
    public final LinearLocation getLocation(double length, boolean resolveLower) {
        double forwardLength = length;
        if (length < 0.0) {
            double lineLen = this.linearGeom.getLength();
            forwardLength = lineLen + length;
        }
        LinearLocation loc = this.getLocationForward(forwardLength);
        return resolveLower ? loc : this.resolveHigher(loc);
    }

    private final LinearLocation getLocationForward(double length) {
        if (length <= 0.0) {
            return new LinearLocation();
        }
        double totalLength = 0.0;
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (it.isEndOfLine()) {
                if (totalLength == length) {
                    int compIndex = it.getComponentIndex();
                    int segIndex = it.getVertexIndex();
                    return new LinearLocation(compIndex, segIndex, 0.0);
                }
            } else {
                Coordinate p1;
                Coordinate p0 = it.getSegmentStart();
                Coordinate coordinate = p1 = it.getSegmentEnd();
                Intrinsics.checkNotNull((Object)coordinate);
                double segLen = coordinate.distance(p0);
                if (totalLength + segLen > length) {
                    double frac = (length - totalLength) / segLen;
                    int compIndex = it.getComponentIndex();
                    int segIndex = it.getVertexIndex();
                    return new LinearLocation(compIndex, segIndex, frac);
                }
                totalLength += segLen;
            }
            it.next();
        }
        return LinearLocation.Companion.getEndLocation(this.linearGeom);
    }

    private final LinearLocation resolveHigher(LinearLocation loc) {
        if (!loc.isEndpoint(this.linearGeom)) {
            return loc;
        }
        int compIndex = loc.getComponentIndex();
        if (compIndex >= this.linearGeom.getNumGeometries() - 1) {
            return loc;
        }
        while (++compIndex < this.linearGeom.getNumGeometries() - 1 && this.linearGeom.getGeometryN(compIndex).getLength() == 0.0) {
        }
        return new LinearLocation(compIndex, 0, 0.0);
    }

    public final double getLength(@NotNull LinearLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        double totalLength = 0.0;
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (!it.isEndOfLine()) {
                Coordinate p1;
                Coordinate p0 = it.getSegmentStart();
                Coordinate coordinate = p1 = it.getSegmentEnd();
                Intrinsics.checkNotNull((Object)coordinate);
                double segLen = coordinate.distance(p0);
                if (loc.getComponentIndex() == it.getComponentIndex() && loc.getSegmentIndex() == it.getVertexIndex()) {
                    return totalLength + segLen * loc.getSegmentFraction();
                }
                totalLength += segLen;
            } else if (loc.getComponentIndex() == it.getComponentIndex()) {
                return totalLength;
            }
            it.next();
        }
        return totalLength;
    }

    @JvmStatic
    public static final double getLength(@NotNull Geometry linearGeom, @NotNull LinearLocation loc) {
        return Companion.getLength(linearGeom, loc);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0005H\u0007\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/linearref/LengthLocationMap$Companion;", "", "<init>", "()V", "getLocation", "Lorg/locationtech/jts/linearref/LinearLocation;", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "length", "", "resolveLower", "", "getLength", "loc", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinearLocation getLocation(@NotNull Geometry linearGeom, double length) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            LengthLocationMap locater = new LengthLocationMap(linearGeom);
            return locater.getLocation(length);
        }

        @NotNull
        public final LinearLocation getLocation(@NotNull Geometry linearGeom, double length, boolean resolveLower) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            LengthLocationMap locater = new LengthLocationMap(linearGeom);
            return locater.getLocation(length, resolveLower);
        }

        @JvmStatic
        public final double getLength(@NotNull Geometry linearGeom, @NotNull LinearLocation loc) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            LengthLocationMap locater = new LengthLocationMap(linearGeom);
            return locater.getLength(loc);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

