/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\fJ\u001c\u0010\u0016\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0018\u001a\u00020\fH\u0007J\u0006\u0010\u0019\u001a\u00020\u0014J!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lorg/locationtech/jts/linearref/LinearGeometryBuilder;", "", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "lines", "", "Lorg/locationtech/jts/geom/Geometry;", "coordList", "Lorg/locationtech/jts/geom/CoordinateList;", "ignoreInvalidLines", "", "fixInvalidLines", "value", "Lorg/locationtech/jts/geom/Coordinate;", "lastCoordinate", "getLastCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "setIgnoreInvalidLines", "", "setFixInvalidLines", "add", "pt", "allowRepeatedPoints", "endLine", "validCoordinateSequence", "", "pts", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "geometry", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "kts-core"})
public final class LinearGeometryBuilder {
    @NotNull
    private final GeometryFactory geomFact;
    @NotNull
    private final List<Geometry> lines;
    @Nullable
    private CoordinateList coordList;
    private boolean ignoreInvalidLines;
    private boolean fixInvalidLines;
    @Nullable
    private Coordinate lastCoordinate;

    public LinearGeometryBuilder(@NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        this.geomFact = geomFact;
        this.lines = new ArrayList();
    }

    @Nullable
    public final Coordinate getLastCoordinate() {
        return this.lastCoordinate;
    }

    public final void setIgnoreInvalidLines(boolean ignoreInvalidLines) {
        this.ignoreInvalidLines = ignoreInvalidLines;
    }

    public final void setFixInvalidLines(boolean fixInvalidLines) {
        this.fixInvalidLines = fixInvalidLines;
    }

    @JvmOverloads
    public final void add(@Nullable Coordinate pt, boolean allowRepeatedPoints) {
        if (this.coordList == null) {
            this.coordList = new CoordinateList();
        }
        CoordinateList coordinateList = this.coordList;
        Intrinsics.checkNotNull((Object)coordinateList);
        coordinateList.add((Object)pt, allowRepeatedPoints);
        this.lastCoordinate = pt;
    }

    public static /* synthetic */ void add$default(LinearGeometryBuilder linearGeometryBuilder, Coordinate coordinate, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        linearGeometryBuilder.add(coordinate, bl);
    }

    public final void endLine() {
        LineString line;
        block7: {
            Coordinate[] rawPts;
            if (this.coordList == null) {
                return;
            }
            if (this.ignoreInvalidLines) {
                CoordinateList coordinateList = this.coordList;
                Intrinsics.checkNotNull((Object)coordinateList);
                if (coordinateList.size() < 2) {
                    this.coordList = null;
                    return;
                }
            }
            CoordinateList coordinateList = this.coordList;
            Intrinsics.checkNotNull((Object)coordinateList);
            Coordinate[] pts = rawPts = coordinateList.toCoordinateArray();
            if (this.fixInvalidLines) {
                pts = this.validCoordinateSequence(rawPts);
            }
            this.coordList = null;
            line = null;
            try {
                line = this.geomFact.createLineString(pts);
            }
            catch (IllegalArgumentException ex) {
                if (this.ignoreInvalidLines) break block7;
                throw ex;
            }
        }
        if (line != null) {
            this.lines.add(line);
        }
    }

    private final Coordinate[] validCoordinateSequence(Coordinate[] pts) {
        Coordinate[] coordinateArray;
        if (pts.length >= 2) {
            coordinateArray = pts;
        } else {
            Coordinate[] coordinateArray2 = new Coordinate[]{pts[0], pts[0]};
            coordinateArray = coordinateArray2;
        }
        return coordinateArray;
    }

    @NotNull
    public final Geometry getGeometry() {
        this.endLine();
        return this.geomFact.buildGeometry((Collection<? extends Geometry>)this.lines);
    }

    @JvmOverloads
    public final void add(@Nullable Coordinate pt) {
        LinearGeometryBuilder.add$default(this, pt, false, 2, null);
    }
}

