/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.linearref.LocationIndexOfPoint;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/linearref/LocationIndexOfLine;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "indicesOf", "", "Lorg/locationtech/jts/linearref/LinearLocation;", "subLine", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/linearref/LinearLocation;", "Companion", "kts-core"})
public final class LocationIndexOfLine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry linearGeom;

    public LocationIndexOfLine(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        this.linearGeom = linearGeom;
    }

    @NotNull
    public final LinearLocation[] indicesOf(@NotNull Geometry subLine) {
        Intrinsics.checkNotNullParameter((Object)subLine, (String)"subLine");
        Geometry geometry = subLine.getGeometryN(0);
        Intrinsics.checkNotNull((Object)geometry, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        Coordinate startPt = ((LineString)geometry).getCoordinateN(0);
        Geometry geometry2 = subLine.getGeometryN(subLine.getNumGeometries() - 1);
        Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.LineString");
        LineString lastLine = (LineString)geometry2;
        Coordinate endPt = lastLine.getCoordinateN(lastLine.getNumPoints() - 1);
        LocationIndexOfPoint locPt = new LocationIndexOfPoint(this.linearGeom);
        Object[] subLineLoc = new LinearLocation[2];
        subLineLoc[0] = locPt.indexOf(startPt);
        if (subLine.getLength() == 0.0) {
            LinearLocation linearLocation = subLineLoc[0];
            Intrinsics.checkNotNull((Object)linearLocation);
            subLineLoc[1] = linearLocation.copy();
        } else {
            subLineLoc[1] = locPt.indexOfAfter(endPt, subLineLoc[0]);
        }
        return (LinearLocation[])ArraysKt.requireNoNulls((Object[])subLineLoc);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/linearref/LocationIndexOfLine$Companion;", "", "<init>", "()V", "indicesOf", "", "Lorg/locationtech/jts/linearref/LinearLocation;", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "subLine", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/linearref/LinearLocation;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinearLocation[] indicesOf(@NotNull Geometry linearGeom, @NotNull Geometry subLine) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)subLine, (String)"subLine");
            LocationIndexOfLine locater = new LocationIndexOfLine(linearGeom);
            return locater.indicesOf(subLine);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

