/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.linearref;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.linearref.LinearIterator;
import org.locationtech.jts.linearref.LinearLocation;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007J\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/locationtech/jts/linearref/LocationIndexOfPoint;", "", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "indexOf", "Lorg/locationtech/jts/linearref/LinearLocation;", "inputPt", "Lorg/locationtech/jts/geom/Coordinate;", "indexOfAfter", "minIndex", "indexOfFromStart", "Companion", "kts-core"})
public final class LocationIndexOfPoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry linearGeom;

    public LocationIndexOfPoint(@NotNull Geometry linearGeom) {
        Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
        this.linearGeom = linearGeom;
    }

    @NotNull
    public final LinearLocation indexOf(@NotNull Coordinate inputPt) {
        Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
        return this.indexOfFromStart(inputPt, null);
    }

    @NotNull
    public final LinearLocation indexOfAfter(@NotNull Coordinate inputPt, @Nullable LinearLocation minIndex) {
        Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
        if (minIndex == null) {
            return this.indexOf(inputPt);
        }
        LinearLocation endLoc = LinearLocation.Companion.getEndLocation(this.linearGeom);
        if (endLoc.compareTo(minIndex) <= 0) {
            return endLoc;
        }
        LinearLocation closestAfter = this.indexOfFromStart(inputPt, minIndex);
        Assert.INSTANCE.isTrue(closestAfter.compareTo(minIndex) >= 0, "computed location is before specified minimum location");
        return closestAfter;
    }

    private final LinearLocation indexOfFromStart(Coordinate inputPt, LinearLocation minIndex) {
        LinearLocation linearLocation;
        double minDistance = Double.MAX_VALUE;
        int minComponentIndex = 0;
        int minSegmentIndex = 0;
        double minFrac = -1.0;
        LineSegment seg = new LineSegment(null, null, 3, null);
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            block6: {
                int candidateSegmentIndex;
                int candidateComponentIndex;
                double segFrac;
                double segDistance;
                block7: {
                    if (it.isEndOfLine()) break block6;
                    seg.p0 = it.getSegmentStart();
                    Intrinsics.checkNotNull((Object)it.getSegmentEnd());
                    seg.p1 = seg.p1;
                    segDistance = seg.distance(inputPt);
                    segFrac = seg.segmentFraction(inputPt);
                    candidateComponentIndex = it.getComponentIndex();
                    candidateSegmentIndex = it.getVertexIndex();
                    if (!(segDistance < minDistance)) break block6;
                    if (minIndex == null) break block7;
                    if (minIndex.compareLocationValues(candidateComponentIndex, candidateSegmentIndex, segFrac) >= 0) break block6;
                }
                minComponentIndex = candidateComponentIndex;
                minSegmentIndex = candidateSegmentIndex;
                minFrac = segFrac;
                minDistance = segDistance;
            }
            it.next();
        }
        if (minDistance == Double.MAX_VALUE) {
            LinearLocation linearLocation2 = minIndex;
            Intrinsics.checkNotNull((Object)linearLocation2);
            linearLocation = new LinearLocation(linearLocation2);
        } else {
            linearLocation = new LinearLocation(minComponentIndex, minSegmentIndex, minFrac);
        }
        return linearLocation;
    }

    @JvmStatic
    @NotNull
    public static final LinearLocation indexOf(@NotNull Geometry linearGeom, @NotNull Coordinate inputPt) {
        return Companion.indexOf(linearGeom, inputPt);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J \u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\f"}, d2={"Lorg/locationtech/jts/linearref/LocationIndexOfPoint$Companion;", "", "<init>", "()V", "indexOf", "Lorg/locationtech/jts/linearref/LinearLocation;", "linearGeom", "Lorg/locationtech/jts/geom/Geometry;", "inputPt", "Lorg/locationtech/jts/geom/Coordinate;", "indexOfAfter", "minIndex", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LinearLocation indexOf(@NotNull Geometry linearGeom, @NotNull Coordinate inputPt) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
            LocationIndexOfPoint locater = new LocationIndexOfPoint(linearGeom);
            return locater.indexOf(inputPt);
        }

        @NotNull
        public final LinearLocation indexOfAfter(@NotNull Geometry linearGeom, @NotNull Coordinate inputPt, @Nullable LinearLocation minIndex) {
            Intrinsics.checkNotNullParameter((Object)linearGeom, (String)"linearGeom");
            Intrinsics.checkNotNullParameter((Object)inputPt, (String)"inputPt");
            LocationIndexOfPoint locater = new LocationIndexOfPoint(linearGeom);
            return locater.indexOfAfter(inputPt, minIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

