/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 )2\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\u0007J\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u0016J\u0006\u0010\u001f\u001a\u00020\u0018J\u0006\u0010 \u001a\u00020\u0007J(\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR4\u0010\u0011\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u00102\u0010\u0010\u000b\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/noding/NodingIntersectionFinder;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "<init>", "(Lorg/locationtech/jts/algorithm/LineIntersector;)V", "findAllIntersections", "", "isCheckEndSegmentsOnly", "keepIntersections", "isInteriorIntersectionsOnly", "value", "Lorg/locationtech/jts/geom/Coordinate;", "intersection", "getIntersection", "()Lorg/locationtech/jts/geom/Coordinate;", "", "intersectionSegments", "getIntersectionSegments", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "intersections", "", "intersectionCount", "", "setFindAllIntersections", "", "setInteriorIntersectionsOnly", "setCheckEndSegmentsOnly", "setKeepIntersections", "getIntersections", "count", "hasIntersection", "processIntersections", "e0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "e1", "segIndex1", "isDone", "()Z", "Companion", "kts-core"})
public final class NodingIntersectionFinder
implements SegmentIntersector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineIntersector li;
    private boolean findAllIntersections;
    private boolean isCheckEndSegmentsOnly;
    private boolean keepIntersections;
    private boolean isInteriorIntersectionsOnly;
    @Nullable
    private Coordinate intersection;
    @Nullable
    private Coordinate[] intersectionSegments;
    @NotNull
    private final List<Coordinate> intersections;
    private int intersectionCount;

    public NodingIntersectionFinder(@NotNull LineIntersector li) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        this.li = li;
        this.keepIntersections = true;
        this.intersections = new ArrayList();
        this.intersection = null;
    }

    @Nullable
    public final Coordinate getIntersection() {
        return this.intersection;
    }

    @Nullable
    public final Coordinate[] getIntersectionSegments() {
        return this.intersectionSegments;
    }

    public final void setFindAllIntersections(boolean findAllIntersections) {
        this.findAllIntersections = findAllIntersections;
    }

    public final void setInteriorIntersectionsOnly(boolean isInteriorIntersectionsOnly) {
        this.isInteriorIntersectionsOnly = isInteriorIntersectionsOnly;
    }

    public final void setCheckEndSegmentsOnly(boolean isCheckEndSegmentsOnly) {
        this.isCheckEndSegmentsOnly = isCheckEndSegmentsOnly;
    }

    public final void setKeepIntersections(boolean keepIntersections) {
        this.keepIntersections = keepIntersections;
    }

    @NotNull
    public final List<Coordinate> getIntersections() {
        return this.intersections;
    }

    public final int count() {
        return this.intersectionCount;
    }

    public final boolean hasIntersection() {
        return this.intersection != null;
    }

    @Override
    public void processIntersections(@NotNull SegmentString e0, int segIndex0, @NotNull SegmentString e1, int segIndex1) {
        boolean isSameSegment;
        Intrinsics.checkNotNullParameter((Object)e0, (String)"e0");
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        if (!this.findAllIntersections && this.hasIntersection()) {
            return;
        }
        boolean isSameSegString = e0 == e1;
        boolean bl = isSameSegment = isSameSegString && segIndex0 == segIndex1;
        if (isSameSegment) {
            return;
        }
        if (this.isCheckEndSegmentsOnly) {
            boolean isEndSegPresent;
            boolean bl2 = isEndSegPresent = NodingIntersectionFinder.Companion.isEndSegment(e0, segIndex0) || NodingIntersectionFinder.Companion.isEndSegment(e1, segIndex1);
            if (!isEndSegPresent) {
                return;
            }
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        boolean isEnd00 = segIndex0 == 0;
        boolean isEnd01 = segIndex0 + 2 == e0.size();
        boolean isEnd10 = segIndex1 == 0;
        boolean isEnd11 = segIndex1 + 2 == e1.size();
        this.li.computeIntersection(p00, p01, p10, p11);
        boolean isInteriorInt = this.li.hasIntersection() && this.li.isInteriorIntersection();
        boolean isInteriorVertexInt = false;
        if (!this.isInteriorIntersectionsOnly) {
            boolean isAdjacentSegment = isSameSegString && Math.INSTANCE.abs(segIndex1 - segIndex0) <= 1;
            boolean bl3 = isInteriorVertexInt = !isAdjacentSegment && NodingIntersectionFinder.Companion.isInteriorVertexIntersection(p00, p01, p10, p11, isEnd00, isEnd01, isEnd10, isEnd11);
        }
        if (isInteriorInt || isInteriorVertexInt) {
            this.intersectionSegments = new Coordinate[4];
            Intrinsics.checkNotNull((Object)this.intersectionSegments);
            this.intersectionSegments[0] = p00;
            Intrinsics.checkNotNull((Object)this.intersectionSegments);
            this.intersectionSegments[1] = p01;
            Intrinsics.checkNotNull((Object)this.intersectionSegments);
            this.intersectionSegments[2] = p10;
            Intrinsics.checkNotNull((Object)this.intersectionSegments);
            this.intersectionSegments[3] = p11;
            this.intersection = this.li.getIntersection(0);
            if (this.keepIntersections) {
                Coordinate coordinate = this.intersection;
                Intrinsics.checkNotNull((Object)coordinate);
                this.intersections.add(coordinate);
            }
            int n = this.intersectionCount;
            this.intersectionCount = n + 1;
        }
    }

    @Override
    public boolean isDone() {
        return this.findAllIntersections ? false : this.intersection != null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007JH\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J(\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006 "}, d2={"Lorg/locationtech/jts/noding/NodingIntersectionFinder$Companion;", "", "<init>", "()V", "createAnyIntersectionFinder", "Lorg/locationtech/jts/noding/NodingIntersectionFinder;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "createAllIntersectionsFinder", "createInteriorIntersectionsFinder", "createIntersectionCounter", "createInteriorIntersectionCounter", "isInteriorVertexIntersection", "", "p00", "Lorg/locationtech/jts/geom/Coordinate;", "p01", "p10", "p11", "isEnd00", "isEnd01", "isEnd10", "isEnd11", "p0", "p1", "isEnd0", "isEnd1", "isEndSegment", "segStr", "Lorg/locationtech/jts/noding/SegmentString;", "index", "", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodingIntersectionFinder createAnyIntersectionFinder(@NotNull LineIntersector li) {
            Intrinsics.checkNotNullParameter((Object)li, (String)"li");
            return new NodingIntersectionFinder(li);
        }

        @NotNull
        public final NodingIntersectionFinder createAllIntersectionsFinder(@NotNull LineIntersector li) {
            Intrinsics.checkNotNullParameter((Object)li, (String)"li");
            NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
            finder.setFindAllIntersections(true);
            return finder;
        }

        @NotNull
        public final NodingIntersectionFinder createInteriorIntersectionsFinder(@NotNull LineIntersector li) {
            Intrinsics.checkNotNullParameter((Object)li, (String)"li");
            NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
            finder.setFindAllIntersections(true);
            finder.setInteriorIntersectionsOnly(true);
            return finder;
        }

        @NotNull
        public final NodingIntersectionFinder createIntersectionCounter(@NotNull LineIntersector li) {
            Intrinsics.checkNotNullParameter((Object)li, (String)"li");
            NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
            finder.setFindAllIntersections(true);
            finder.setKeepIntersections(false);
            return finder;
        }

        @NotNull
        public final NodingIntersectionFinder createInteriorIntersectionCounter(@NotNull LineIntersector li) {
            Intrinsics.checkNotNullParameter((Object)li, (String)"li");
            NodingIntersectionFinder finder = new NodingIntersectionFinder(li);
            finder.setInteriorIntersectionsOnly(true);
            finder.setFindAllIntersections(true);
            finder.setKeepIntersections(false);
            return finder;
        }

        private final boolean isInteriorVertexIntersection(Coordinate p00, Coordinate p01, Coordinate p10, Coordinate p11, boolean isEnd00, boolean isEnd01, boolean isEnd10, boolean isEnd11) {
            if (this.isInteriorVertexIntersection(p00, p10, isEnd00, isEnd10)) {
                return true;
            }
            if (this.isInteriorVertexIntersection(p00, p11, isEnd00, isEnd11)) {
                return true;
            }
            if (this.isInteriorVertexIntersection(p01, p10, isEnd01, isEnd10)) {
                return true;
            }
            return this.isInteriorVertexIntersection(p01, p11, isEnd01, isEnd11);
        }

        private final boolean isInteriorVertexIntersection(Coordinate p0, Coordinate p1, boolean isEnd0, boolean isEnd1) {
            if (isEnd0 && isEnd1) {
                return false;
            }
            return p0.equals2D(p1);
        }

        private final boolean isEndSegment(SegmentString segStr, int index) {
            if (index == 0) {
                return true;
            }
            return index >= segStr.size() - 2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

