/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.noding.SegmentIntersector;
import org.locationtech.jts.noding.SegmentString;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J(\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R4\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u00112\u0010\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010 \u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lorg/locationtech/jts/noding/SegmentIntersectionDetector;", "Lorg/locationtech/jts/noding/SegmentIntersector;", "li", "Lorg/locationtech/jts/algorithm/LineIntersector;", "<init>", "(Lorg/locationtech/jts/algorithm/LineIntersector;)V", "findProper", "", "findAllTypes", "hasIntersection", "hasProperIntersection", "hasNonProperIntersection", "value", "Lorg/locationtech/jts/geom/Coordinate;", "intersection", "getIntersection", "()Lorg/locationtech/jts/geom/Coordinate;", "", "intersectionSegments", "getIntersectionSegments", "()[Lorg/locationtech/jts/geom/Coordinate;", "[Lorg/locationtech/jts/geom/Coordinate;", "setFindProper", "", "setFindAllIntersectionTypes", "processIntersections", "e0", "Lorg/locationtech/jts/noding/SegmentString;", "segIndex0", "", "e1", "segIndex1", "isDone", "()Z", "kts-core"})
public final class SegmentIntersectionDetector
implements SegmentIntersector {
    @NotNull
    private final LineIntersector li;
    private boolean findProper;
    private boolean findAllTypes;
    private boolean hasIntersection;
    private boolean hasProperIntersection;
    private boolean hasNonProperIntersection;
    @Nullable
    private Coordinate intersection;
    @Nullable
    private Coordinate[] intersectionSegments;

    @JvmOverloads
    public SegmentIntersectionDetector(@NotNull LineIntersector li) {
        Intrinsics.checkNotNullParameter((Object)li, (String)"li");
        this.li = li;
    }

    public /* synthetic */ SegmentIntersectionDetector(LineIntersector lineIntersector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            lineIntersector = new RobustLineIntersector();
        }
        this(lineIntersector);
    }

    @Nullable
    public final Coordinate getIntersection() {
        return this.intersection;
    }

    @Nullable
    public final Coordinate[] getIntersectionSegments() {
        return this.intersectionSegments;
    }

    public final void setFindProper(boolean findProper) {
        this.findProper = findProper;
    }

    public final void setFindAllIntersectionTypes(boolean findAllTypes) {
        this.findAllTypes = findAllTypes;
    }

    public final boolean hasIntersection() {
        return this.hasIntersection;
    }

    public final boolean hasProperIntersection() {
        return this.hasProperIntersection;
    }

    public final boolean hasNonProperIntersection() {
        return this.hasNonProperIntersection;
    }

    @Override
    public void processIntersections(@NotNull SegmentString e0, int segIndex0, @NotNull SegmentString e1, int segIndex1) {
        Intrinsics.checkNotNullParameter((Object)e0, (String)"e0");
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        if (e0 == e1 && segIndex0 == segIndex1) {
            return;
        }
        Coordinate p00 = e0.getCoordinate(segIndex0);
        Coordinate p01 = e0.getCoordinate(segIndex0 + 1);
        Coordinate p10 = e1.getCoordinate(segIndex1);
        Coordinate p11 = e1.getCoordinate(segIndex1 + 1);
        this.li.computeIntersection(p00, p01, p10, p11);
        if (this.li.hasIntersection()) {
            this.hasIntersection = true;
            boolean isProper = this.li.isProper();
            if (isProper) {
                this.hasProperIntersection = true;
            }
            if (!isProper) {
                this.hasNonProperIntersection = true;
            }
            boolean saveLocation = true;
            if (this.findProper && !isProper) {
                saveLocation = false;
            }
            if (this.intersection == null || saveLocation) {
                this.intersection = this.li.getIntersection(0);
                this.intersectionSegments = new Coordinate[4];
                Intrinsics.checkNotNull((Object)this.intersectionSegments);
                this.intersectionSegments[0] = p00;
                Intrinsics.checkNotNull((Object)this.intersectionSegments);
                this.intersectionSegments[1] = p01;
                Intrinsics.checkNotNull((Object)this.intersectionSegments);
                this.intersectionSegments[2] = p10;
                Intrinsics.checkNotNull((Object)this.intersectionSegments);
                this.intersectionSegments[3] = p11;
            }
        }
    }

    @Override
    public boolean isDone() {
        if (this.findAllTypes) {
            return this.hasProperIntersection && this.hasNonProperIntersection;
        }
        return this.findProper ? this.hasProperIntersection : this.hasIntersection;
    }

    @JvmOverloads
    public SegmentIntersectionDetector() {
        this(null, 1, null);
    }
}

