/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.noding.MCIndexNoder;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.Noder;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.noding.snap.SnappingIntersectionAdder;
import org.locationtech.jts.noding.snap.SnappingPointIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0016J\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00120\fH\u0002J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u001a\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/noding/snap/SnappingNoder;", "Lorg/locationtech/jts/noding/Noder;", "snapTolerance", "", "<init>", "(D)V", "snapIndex", "Lorg/locationtech/jts/noding/snap/SnappingPointIndex;", "nodedResult", "", "Lorg/locationtech/jts/noding/NodedSegmentString;", "nodedSubstrings", "", "getNodedSubstrings", "()Ljava/util/Collection;", "computeNodes", "", "inputSegStrings", "Lorg/locationtech/jts/noding/SegmentString;", "snapVertices", "segStrings", "seedSnapIndex", "ss", "snap", "", "Lorg/locationtech/jts/geom/Coordinate;", "coords", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "snapIntersections", "inputSS", "kts-core"})
public final class SnappingNoder
implements Noder {
    private final double snapTolerance;
    @NotNull
    private final SnappingPointIndex snapIndex;
    @Nullable
    private List<NodedSegmentString> nodedResult;

    public SnappingNoder(double snapTolerance) {
        this.snapTolerance = snapTolerance;
        this.snapIndex = new SnappingPointIndex(this.snapTolerance);
    }

    @NotNull
    public Collection<NodedSegmentString> getNodedSubstrings() {
        List<NodedSegmentString> list = this.nodedResult;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @Override
    public void computeNodes(@NotNull Collection<? extends SegmentString> inputSegStrings) {
        Intrinsics.checkNotNullParameter(inputSegStrings, (String)"inputSegStrings");
        List<NodedSegmentString> snappedSS = this.snapVertices(inputSegStrings);
        Collection<?> collection = this.snapIntersections(snappedSS);
        Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.List<org.locationtech.jts.noding.NodedSegmentString>");
        this.nodedResult = (List)collection;
    }

    private final List<NodedSegmentString> snapVertices(Collection<? extends SegmentString> segStrings) {
        this.seedSnapIndex(segStrings);
        List nodedStrings = new ArrayList();
        for (SegmentString segmentString : segStrings) {
            nodedStrings.add(this.snapVertices(segmentString));
        }
        return nodedStrings;
    }

    private final void seedSnapIndex(Collection<? extends SegmentString> segStrings) {
        int SEED_SIZE_FACTOR = 100;
        for (SegmentString segmentString : segStrings) {
            Coordinate[] pts = segmentString.getCoordinates();
            int numPtsToLoad = pts.length / SEED_SIZE_FACTOR;
            double rand = 0.0;
            for (int i = 0; i < numPtsToLoad; ++i) {
                rand = MathUtil.quasirandom$default(MathUtil.INSTANCE, rand, 0.0, 2, null);
                int index = (int)((double)pts.length * rand);
                this.snapIndex.snap(pts[index]);
            }
        }
    }

    private final NodedSegmentString snapVertices(SegmentString ss) {
        Coordinate[] snapCoords = this.snap(ss.getCoordinates());
        return new NodedSegmentString(snapCoords, ss.getData());
    }

    private final Coordinate[] snap(Coordinate[] coords) {
        CoordinateList snapCoords = new CoordinateList();
        int n = coords.length;
        for (int i = 0; i < n; ++i) {
            Coordinate pt = this.snapIndex.snap(coords[i]);
            snapCoords.add(pt, false);
        }
        return snapCoords.toCoordinateArray();
    }

    private final Collection<?> snapIntersections(List<NodedSegmentString> inputSS) {
        SnappingIntersectionAdder intAdder = new SnappingIntersectionAdder(this.snapTolerance, this.snapIndex);
        MCIndexNoder noder = new MCIndexNoder(intAdder, (double)2 * this.snapTolerance);
        noder.computeNodes((Collection<? extends SegmentString>)inputSS);
        return noder.getNodedSubstrings();
    }
}

