/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.CGAlgorithmsDD;
import org.locationtech.jts.algorithm.LineIntersector;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003J(\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005H\u0002J\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\n\u0010#\u001a\u00020$H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000b\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/noding/snapround/HotPixel;", "", "coordinate", "Lorg/locationtech/jts/geom/Coordinate;", "scaleFactor", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;D)V", "getCoordinate", "()Lorg/locationtech/jts/geom/Coordinate;", "getScaleFactor", "()D", "hpx", "hpy", "value", "", "isNode", "()Z", "width", "getWidth", "setToNode", "", "scaleRound", "val", "scale", "intersects", "p", "p0", "p1", "intersectsScaled", "p0x", "p0y", "p1x", "p1y", "intersectsPixelClosure", "toString", "", "Companion", "kts-core"})
public final class HotPixel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Coordinate coordinate;
    private final double scaleFactor;
    private double hpx;
    private double hpy;
    private boolean isNode;
    private static final double TOLERANCE = 0.5;
    private static final int UPPER_RIGHT = 0;
    private static final int UPPER_LEFT = 1;
    private static final int LOWER_LEFT = 2;
    private static final int LOWER_RIGHT = 3;

    public HotPixel(@NotNull Coordinate coordinate, double scaleFactor) {
        Intrinsics.checkNotNullParameter((Object)coordinate, (String)"coordinate");
        this.coordinate = coordinate;
        this.scaleFactor = scaleFactor;
        if (this.scaleFactor <= 0.0) {
            throw new IllegalArgumentException("Scale factor must be non-zero");
        }
        if (!(this.scaleFactor == 1.0)) {
            this.hpx = this.scaleRound(this.coordinate.x);
            this.hpy = this.scaleRound(this.coordinate.y);
        } else {
            this.hpx = this.coordinate.x;
            this.hpy = this.coordinate.y;
        }
    }

    @NotNull
    public final Coordinate getCoordinate() {
        return this.coordinate;
    }

    public final double getScaleFactor() {
        return this.scaleFactor;
    }

    public final boolean isNode() {
        return this.isNode;
    }

    public final double getWidth() {
        return 1.0 / this.scaleFactor;
    }

    public final void setToNode() {
        this.isNode = true;
    }

    private final double scaleRound(double val) {
        return Math.INSTANCE.round(val * this.scaleFactor);
    }

    private final double scale(double val) {
        return val * this.scaleFactor;
    }

    public final boolean intersects(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double x = this.scale(p.x);
        double y = this.scale(p.y);
        if (x >= this.hpx + 0.5) {
            return false;
        }
        if (x < this.hpx - 0.5) {
            return false;
        }
        if (y >= this.hpy + 0.5) {
            return false;
        }
        return y >= this.hpy - 0.5;
    }

    public final boolean intersects(@NotNull Coordinate p0, @NotNull Coordinate p1) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        if (this.scaleFactor == 1.0) {
            return this.intersectsScaled(p0.x, p0.y, p1.x, p1.y);
        }
        double sp0x = this.scale(p0.x);
        double sp0y = this.scale(p0.y);
        double sp1x = this.scale(p1.x);
        double sp1y = this.scale(p1.y);
        return this.intersectsScaled(sp0x, sp0y, sp1x, sp1y);
    }

    private final boolean intersectsScaled(double p0x, double p0y, double p1x, double p1y) {
        double px = p0x;
        double py = p0y;
        double qx = p1x;
        double qy = p1y;
        if (px > qx) {
            px = p1x;
            py = p1y;
            qx = p0x;
            qy = p0y;
        }
        double maxx = this.hpx + 0.5;
        double segMinx = Math.INSTANCE.min(px, qx);
        if (segMinx >= maxx) {
            return false;
        }
        double minx = this.hpx - 0.5;
        double segMaxx = Math.INSTANCE.max(px, qx);
        if (segMaxx < minx) {
            return false;
        }
        double maxy = this.hpy + 0.5;
        double segMiny = Math.INSTANCE.min(py, qy);
        if (segMiny >= maxy) {
            return false;
        }
        double miny = this.hpy - 0.5;
        double segMaxy = Math.INSTANCE.max(py, qy);
        if (segMaxy < miny) {
            return false;
        }
        if (px == qx) {
            return true;
        }
        if (py == qy) {
            return true;
        }
        int orientUL = CGAlgorithmsDD.INSTANCE.orientationIndex(px, py, qx, qy, minx, maxy);
        if (orientUL == 0) {
            return py >= qy;
        }
        int orientUR = CGAlgorithmsDD.INSTANCE.orientationIndex(px, py, qx, qy, maxx, maxy);
        if (orientUR == 0) {
            return py <= qy;
        }
        if (orientUL != orientUR) {
            return true;
        }
        int orientLL = CGAlgorithmsDD.INSTANCE.orientationIndex(px, py, qx, qy, minx, miny);
        if (orientLL == 0) {
            return true;
        }
        if (orientLL != orientUL) {
            return true;
        }
        int orientLR = CGAlgorithmsDD.INSTANCE.orientationIndex(px, py, qx, qy, maxx, miny);
        if (orientLR == 0) {
            return py >= qy;
        }
        if (orientLL != orientLR) {
            return true;
        }
        return orientLR != orientUR;
    }

    private final boolean intersectsPixelClosure(Coordinate p0, Coordinate p1) {
        double minx = this.hpx - 0.5;
        double maxx = this.hpx + 0.5;
        double miny = this.hpy - 0.5;
        double maxy = this.hpy + 0.5;
        Coordinate[] corner = new Coordinate[]{new Coordinate(maxx, maxy), new Coordinate(minx, maxy), new Coordinate(minx, miny), new Coordinate(maxx, miny)};
        LineIntersector li = new RobustLineIntersector();
        li.computeIntersection(p0, p1, corner[0], corner[1]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[1], corner[2]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[2], corner[3]);
        if (li.hasIntersection()) {
            return true;
        }
        li.computeIntersection(p0, p1, corner[3], corner[0]);
        return li.hasIntersection();
    }

    @NotNull
    public String toString() {
        return "HP(" + WKTWriter.Companion.format(this.coordinate) + ")";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/noding/snapround/HotPixel$Companion;", "", "<init>", "()V", "TOLERANCE", "", "UPPER_RIGHT", "", "UPPER_LEFT", "LOWER_LEFT", "LOWER_RIGHT", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

