/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.noding.snapround;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdNodeVisitor;
import org.locationtech.jts.index.kdtree.KdTree;
import org.locationtech.jts.noding.snapround.HotPixel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0011J\u000e\u0010\n\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\"\u0010\u0018\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/locationtech/jts/noding/snapround/HotPixelIndex;", "", "precModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "scaleFactor", "", "index", "Lorg/locationtech/jts/index/kdtree/KdTree;", "add", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)V", "addNodes", "", "Lorg/locationtech/jts/noding/snapround/HotPixel;", "p", "find", "pixelPt", "round", "pt", "query", "p0", "p1", "visitor", "Lorg/locationtech/jts/index/kdtree/KdNodeVisitor;", "CoordinateShuffler", "kts-core"})
public final class HotPixelIndex {
    @NotNull
    private final PrecisionModel precModel;
    private final double scaleFactor;
    @NotNull
    private final KdTree index;

    public HotPixelIndex(@NotNull PrecisionModel precModel) {
        Intrinsics.checkNotNullParameter((Object)precModel, (String)"precModel");
        this.precModel = precModel;
        this.scaleFactor = this.precModel.getScale();
        this.index = new KdTree(0.0, 1, null);
    }

    public final void add(@NotNull Coordinate[] pts) {
        Intrinsics.checkNotNullParameter((Object)pts, (String)"pts");
        Iterator it = new CoordinateShuffler(pts);
        while (it.hasNext()) {
            this.add((Coordinate)it.next());
        }
    }

    public final void addNodes(@NotNull List<? extends Coordinate> pts) {
        Intrinsics.checkNotNullParameter(pts, (String)"pts");
        for (Coordinate coordinate : pts) {
            HotPixel hp = this.add(coordinate);
            hp.setToNode();
        }
    }

    @NotNull
    public final HotPixel add(@NotNull Coordinate p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Coordinate pRound = this.round(p);
        HotPixel hp = this.find(pRound);
        if (hp != null) {
            hp.setToNode();
            return hp;
        }
        hp = new HotPixel(pRound, this.scaleFactor);
        this.index.insert(hp.getCoordinate(), hp);
        return hp;
    }

    private final HotPixel find(Coordinate pixelPt) {
        KdNode kdNode = this.index.query(pixelPt);
        if (kdNode == null) {
            return null;
        }
        KdNode kdNode2 = kdNode;
        return (HotPixel)kdNode2.getData();
    }

    private final Coordinate round(Coordinate pt) {
        Coordinate p2 = pt.copy();
        this.precModel.makePrecise(p2);
        return p2;
    }

    public final void query(@Nullable Coordinate p0, @Nullable Coordinate p1, @NotNull KdNodeVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        Envelope queryEnv = new Envelope(coordinate, coordinate2);
        queryEnv.expandBy(1.0 / this.scaleFactor);
        this.index.query(queryEnv, visitor);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0082\u0004J\n\u0010\u0010\u001a\u00020\u0002H\u0096\u0082\u0004R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/locationtech/jts/noding/snapround/HotPixelIndex$CoordinateShuffler;", "", "Lorg/locationtech/jts/geom/Coordinate;", "coordinates", "", "<init>", "([Lorg/locationtech/jts/geom/Coordinate;)V", "[Lorg/locationtech/jts/geom/Coordinate;", "rnd", "Lkotlin/random/Random;", "indices", "", "index", "", "hasNext", "", "next", "kts-core"})
    private static final class CoordinateShuffler
    implements Iterator<Coordinate>,
    KMappedMarker {
        @NotNull
        private final Coordinate[] coordinates;
        @NotNull
        private final Random rnd;
        @NotNull
        private final int[] indices;
        private int index;

        public CoordinateShuffler(@NotNull Coordinate[] coordinates) {
            Intrinsics.checkNotNullParameter((Object)coordinates, (String)"coordinates");
            this.coordinates = coordinates;
            this.rnd = RandomKt.Random((int)13);
            this.indices = new int[this.coordinates.length];
            int n = this.coordinates.length;
            for (int i = 0; i < n; ++i) {
                this.indices[i] = i;
            }
            this.index = this.coordinates.length - 1;
        }

        @Override
        public boolean hasNext() {
            return this.index >= 0;
        }

        @Override
        @NotNull
        public Coordinate next() {
            int j = this.rnd.nextInt(this.index + 1);
            Coordinate res = this.coordinates[this.indices[j]];
            int n = this.index;
            this.index = n + -1;
            this.indices[j] = this.indices[n];
            return res;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

