/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Position;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.Triangle;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.noding.NodedSegmentString;
import org.locationtech.jts.noding.SegmentString;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 72\u00020\u0001:\u00017B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u001b\u0010\u0015\u001a\u00020\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002\u00a2\u0006\u0002\u0010\u0019J-\u0010\u001d\u001a\u00020\u00142\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u00142\b\u0010#\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010(\u001a\u00020.H\u0002J#\u0010/\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u00100J;\u00101\u001a\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u00106R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00068"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferCurveSetBuilder;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "distance", "", "precisionModel", "Lorg/locationtech/jts/geom/PrecisionModel;", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;DLorg/locationtech/jts/geom/PrecisionModel;Lorg/locationtech/jts/operation/buffer/BufferParameters;)V", "curveBuilder", "Lorg/locationtech/jts/operation/buffer/OffsetCurveBuilder;", "curveList", "", "Lorg/locationtech/jts/noding/SegmentString;", "isInvertOrientation", "", "setInvertOrientation", "", "isRingCCW", "coord", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Z", "curves", "getCurves", "()Ljava/util/List;", "addCurve", "leftLoc", "", "rightLoc", "([Lorg/locationtech/jts/geom/Coordinate;II)V", "add", "g", "addCollection", "gc", "Lorg/locationtech/jts/geom/GeometryCollection;", "addPoint", "p", "Lorg/locationtech/jts/geom/Point;", "addLineString", "line", "Lorg/locationtech/jts/geom/LineString;", "addPolygon", "Lorg/locationtech/jts/geom/Polygon;", "addRingBothSides", "([Lorg/locationtech/jts/geom/Coordinate;D)V", "addRingSide", "offsetDistance", "side", "cwLeftLoc", "cwRightLoc", "([Lorg/locationtech/jts/geom/Coordinate;DIII)V", "Companion", "kts-core"})
public final class BufferCurveSetBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Geometry inputGeom;
    private final double distance;
    @NotNull
    private final OffsetCurveBuilder curveBuilder;
    @NotNull
    private final List<SegmentString> curveList;
    private boolean isInvertOrientation;
    private static final int MAX_INVERTED_RING_SIZE = 9;
    private static final int INVERTED_CURVE_VERTEX_FACTOR = 4;
    private static final double NEARNESS_FACTOR = 0.99;

    public BufferCurveSetBuilder(@Nullable Geometry inputGeom, double distance, @NotNull PrecisionModel precisionModel, @NotNull BufferParameters bufParams) {
        Intrinsics.checkNotNullParameter((Object)precisionModel, (String)"precisionModel");
        Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.curveList = new ArrayList();
        this.curveBuilder = new OffsetCurveBuilder(precisionModel, bufParams);
    }

    public final void setInvertOrientation(boolean isInvertOrientation) {
        this.isInvertOrientation = isInvertOrientation;
    }

    private final boolean isRingCCW(Coordinate[] coord) {
        boolean isCCW = Orientation.isCCWArea(coord);
        return this.isInvertOrientation ? !isCCW : isCCW;
    }

    @NotNull
    public final List<SegmentString> getCurves() {
        this.add(this.inputGeom);
        return this.curveList;
    }

    private final void addCurve(Coordinate[] coord, int leftLoc, int rightLoc) {
        if (coord == null || coord.length < 2) {
            return;
        }
        SegmentString e = new NodedSegmentString(coord, new Label(0, 1, leftLoc, rightLoc));
        this.curveList.add(e);
    }

    private final void add(Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        if (geometry.isEmpty()) {
            return;
        }
        Geometry geometry2 = g;
        if (geometry2 instanceof Polygon) {
            this.addPolygon((Polygon)g);
        } else if (geometry2 instanceof LineString) {
            this.addLineString((LineString)g);
        } else if (geometry2 instanceof Point) {
            this.addPoint((Point)g);
        } else if (geometry2 instanceof MultiPoint) {
            this.addCollection((GeometryCollection)g);
        } else if (geometry2 instanceof MultiLineString) {
            this.addCollection((GeometryCollection)g);
        } else if (geometry2 instanceof MultiPolygon) {
            this.addCollection((GeometryCollection)g);
        } else if (geometry2 instanceof GeometryCollection) {
            this.addCollection((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(String.valueOf(new PropertyReference0Impl(Reflection.getOrCreateKotlinClass(g.getClass())){

                public Object get() {
                    return ((KClass)this.receiver).getSimpleName();
                }
            }));
        }
    }

    private final void addCollection(GeometryCollection gc) {
        int n = gc.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry g = gc.getGeometryN(i);
            this.add(g);
        }
    }

    private final void addPoint(Point p) {
        if (this.distance <= 0.0) {
            return;
        }
        Coordinate[] coord = p.getCoordinates();
        if (!(coord.length == 0) && !coord[0].isValid()) {
            return;
        }
        Coordinate[] curve2 = this.curveBuilder.getLineCurve(coord, this.distance);
        this.addCurve(curve2, 2, 0);
    }

    private final void addLineString(LineString line) {
        if (this.curveBuilder.isLineOffsetEmpty(this.distance)) {
            return;
        }
        Coordinate[] coord = BufferCurveSetBuilder.Companion.clean(line.getCoordinates());
        if (CoordinateArrays.INSTANCE.isRing(coord) && !this.curveBuilder.getBufferParameters().isSingleSided()) {
            this.addRingBothSides(coord, this.distance);
        } else {
            Coordinate[] curve2 = this.curveBuilder.getLineCurve(coord, this.distance);
            this.addCurve(curve2, 2, 0);
        }
    }

    private final void addPolygon(Polygon p) {
        LinearRing shell;
        double offsetDistance = this.distance;
        int offsetSide = 1;
        if (this.distance < 0.0) {
            offsetDistance = -this.distance;
            offsetSide = 2;
        }
        LinearRing linearRing = shell = p.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] shellCoord = BufferCurveSetBuilder.Companion.clean(linearRing.getCoordinates());
        if (this.distance < 0.0 && BufferCurveSetBuilder.Companion.isErodedCompletely(shell, this.distance)) {
            return;
        }
        if (this.distance <= 0.0 && shellCoord.length < 3) {
            return;
        }
        this.addRingSide(shellCoord, offsetDistance, offsetSide, 2, 0);
        int n = p.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = p.getInteriorRingN(i);
            Coordinate[] holeCoord = BufferCurveSetBuilder.Companion.clean(hole.getCoordinates());
            if (this.distance > 0.0 && BufferCurveSetBuilder.Companion.isErodedCompletely(hole, -this.distance)) continue;
            this.addRingSide(holeCoord, offsetDistance, Position.INSTANCE.opposite(offsetSide), 0, 2);
        }
    }

    private final void addRingBothSides(Coordinate[] coord, double distance) {
        this.addRingSide(coord, distance, 1, 2, 0);
        this.addRingSide(coord, distance, 2, 0, 2);
    }

    private final void addRingSide(Coordinate[] coord, double offsetDistance, int side, int cwLeftLoc, int cwRightLoc) {
        Coordinate[] curve2;
        int side2 = side;
        if (offsetDistance == 0.0 && coord.length < 3) {
            return;
        }
        int leftLoc = cwLeftLoc;
        int rightLoc = cwRightLoc;
        boolean isCCW = this.isRingCCW(coord);
        if (coord.length >= 3 && isCCW) {
            leftLoc = cwRightLoc;
            rightLoc = cwLeftLoc;
            side2 = Position.INSTANCE.opposite(side2);
        }
        if (BufferCurveSetBuilder.Companion.isRingCurveInverted(coord, offsetDistance, curve2 = this.curveBuilder.getRingCurve(coord, side2, offsetDistance))) {
            return;
        }
        this.addCurve(curve2, leftLoc, rightLoc);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\bJ3\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u00020\r2\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\rH\u0002J#\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001b\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/locationtech/jts/operation/buffer/BufferCurveSetBuilder$Companion;", "", "<init>", "()V", "clean", "", "Lorg/locationtech/jts/geom/Coordinate;", "coords", "([Lorg/locationtech/jts/geom/Coordinate;)[Lorg/locationtech/jts/geom/Coordinate;", "MAX_INVERTED_RING_SIZE", "", "INVERTED_CURVE_VERTEX_FACTOR", "NEARNESS_FACTOR", "", "isRingCurveInverted", "", "inputPts", "distance", "curvePts", "([Lorg/locationtech/jts/geom/Coordinate;D[Lorg/locationtech/jts/geom/Coordinate;)Z", "maxDistance", "pts", "line", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)D", "isErodedCompletely", "ring", "Lorg/locationtech/jts/geom/LinearRing;", "bufferDistance", "isTriangleErodedCompletely", "triangleCoord", "([Lorg/locationtech/jts/geom/Coordinate;D)Z", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate[] clean(Coordinate[] coords) {
            return CoordinateArrays.INSTANCE.removeRepeatedOrInvalidPoints(coords);
        }

        private final boolean isRingCurveInverted(Coordinate[] inputPts, double distance, Coordinate[] curvePts) {
            if (distance == 0.0) {
                return false;
            }
            if (inputPts.length <= 3) {
                return false;
            }
            if (inputPts.length >= 9) {
                return false;
            }
            Intrinsics.checkNotNull((Object)curvePts);
            if (curvePts.length > 4 * inputPts.length) {
                return false;
            }
            double distTol = 0.99 * Math.INSTANCE.abs(distance);
            double maxDist = this.maxDistance(curvePts, inputPts);
            return maxDist < distTol;
        }

        private final double maxDistance(Coordinate[] pts, Coordinate[] line) {
            double maxDistance = 0.0;
            Intrinsics.checkNotNull((Object)pts);
            for (Coordinate p : pts) {
                double dist = Distance.INSTANCE.pointToSegmentString(p, line);
                if (!(dist > maxDistance)) continue;
                maxDistance = dist;
            }
            return maxDistance;
        }

        private final boolean isErodedCompletely(LinearRing ring, double bufferDistance) {
            Coordinate[] ringCoord = ring.getCoordinates();
            if (ringCoord.length < 4) {
                return bufferDistance < 0.0;
            }
            if (ringCoord.length == 4) {
                return this.isTriangleErodedCompletely(ringCoord, bufferDistance);
            }
            Envelope env = ring.getEnvelopeInternal();
            double envMinDimension = Math.INSTANCE.min(env.getHeight(), env.getWidth());
            return bufferDistance < 0.0 && (double)2 * Math.INSTANCE.abs(bufferDistance) > envMinDimension;
        }

        private final boolean isTriangleErodedCompletely(Coordinate[] triangleCoord, double bufferDistance) {
            Triangle tri = new Triangle(triangleCoord[0], triangleCoord[1], triangleCoord[2]);
            Coordinate inCentre = tri.inCentre();
            double distToCentre = Distance.pointToSegment(inCentre, tri.getP0(), tri.getP1());
            return distToCentre < Math.INSTANCE.abs(bufferDistance);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

