/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Distance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.GeometryMapper;
import org.locationtech.jts.index.chain.MonotoneChain;
import org.locationtech.jts.index.chain.MonotoneChainSelectAction;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.buffer.OffsetCurveBuilder;
import org.locationtech.jts.operation.buffer.SegmentMCIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002%&B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J#\u0010\u0014\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0011\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u001bJ?\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00172\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\u0006\u0010 \u001a\u00020!2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetCurve;", "", "inputGeom", "Lorg/locationtech/jts/geom/Geometry;", "distance", "", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;DLorg/locationtech/jts/operation/buffer/BufferParameters;)V", "bufferParams", "matchDistance", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "curve", "getCurve", "()Lorg/locationtech/jts/geom/Geometry;", "computeCurve", "Lorg/locationtech/jts/geom/LineString;", "lineGeom", "offsetSegment", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;D)Lorg/locationtech/jts/geom/LineString;", "bufferPts", "rawOffset", "([Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/LineString;", "markMatchingSegments", "", "p0", "p1", "segIndex", "Lorg/locationtech/jts/operation/buffer/SegmentMCIndex;", "isInCurve", "", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/operation/buffer/SegmentMCIndex;[Lorg/locationtech/jts/geom/Coordinate;[Z)I", "MatchCurveSegmentAction", "Companion", "kts-core"})
public final class OffsetCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry inputGeom;
    private final double distance;
    @NotNull
    private final BufferParameters bufferParams;
    private final double matchDistance;
    @NotNull
    private final GeometryFactory geomFactory;
    private static final int NEARNESS_FACTOR = 10000;

    @JvmOverloads
    public OffsetCurve(@NotNull Geometry inputGeom, double distance, @Nullable BufferParameters bufParams) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this.inputGeom = inputGeom;
        this.distance = distance;
        this.matchDistance = Math.INSTANCE.abs(this.distance) / (double)10000;
        this.geomFactory = this.inputGeom.getFactory();
        this.bufferParams = new BufferParameters();
        if (bufParams != null) {
            this.bufferParams.setQuadrantSegments(bufParams.getQuadrantSegments());
            this.bufferParams.setJoinStyle(bufParams.getJoinStyle());
            this.bufferParams.setMitreLimit(bufParams.getMitreLimit());
        }
    }

    public /* synthetic */ OffsetCurve(Geometry geometry, double d, BufferParameters bufferParameters, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bufferParameters = null;
        }
        this(geometry, d, bufferParameters);
    }

    @NotNull
    public final Geometry getCurve() {
        return GeometryMapper.flatMap(this.inputGeom, 1, new GeometryMapper.MapOp(this){
            final /* synthetic */ OffsetCurve this$0;
            {
                this.this$0 = $receiver;
            }

            public Geometry map(Geometry geom) {
                Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
                if (geom instanceof Point) {
                    return null;
                }
                return geom instanceof Polygon ? this.toLineString(geom.buffer(OffsetCurve.access$getDistance$p(this.this$0)).getBoundary()) : (Geometry)OffsetCurve.access$computeCurve(this.this$0, (LineString)geom, OffsetCurve.access$getDistance$p(this.this$0));
            }

            private final Geometry toLineString(Geometry geom) {
                if (geom instanceof LinearRing) {
                    return ((LinearRing)geom).getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
                }
                return geom;
            }
        });
    }

    private final LineString computeCurve(LineString lineGeom, double distance) {
        Polygon bufferPoly;
        LineString lineString = lineGeom;
        Intrinsics.checkNotNull((Object)lineString);
        if (lineString.getNumPoints() < 2 || lineGeom.getLength() == 0.0) {
            return GeometryFactory.createLineString$default(this.geomFactory, null, 1, null);
        }
        if (lineGeom.getNumPoints() == 2) {
            return this.offsetSegment(lineGeom.getCoordinates(), distance);
        }
        Coordinate[] rawOffset = Companion.rawOffset(lineGeom, distance, this.bufferParams);
        Intrinsics.checkNotNull((Object)rawOffset);
        if (rawOffset.length == 0) {
            return GeometryFactory.createLineString$default(this.geomFactory, null, 1, null);
        }
        Polygon polygon = bufferPoly = OffsetCurve.Companion.getBufferOriented(lineGeom, distance, this.bufferParams);
        Intrinsics.checkNotNull((Object)polygon);
        LinearRing linearRing = polygon.getExteriorRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Coordinate[] shell = linearRing.getCoordinates();
        LineString offsetCurve = this.computeCurve(shell, rawOffset);
        if (!offsetCurve.isEmpty() || bufferPoly.getNumInteriorRing() == 0) {
            return offsetCurve;
        }
        LinearRing linearRing2 = OffsetCurve.Companion.extractLongestHole(bufferPoly);
        Intrinsics.checkNotNull((Object)linearRing2);
        Coordinate[] holePts = linearRing2.getCoordinates();
        offsetCurve = this.computeCurve(holePts, rawOffset);
        return offsetCurve;
    }

    private final LineString offsetSegment(Coordinate[] pts, double distance) {
        LineSegment offsetSeg = new LineSegment(pts[0], pts[1]).offset(distance);
        Coordinate[] coordinateArray = new Coordinate[]{offsetSeg.p0, offsetSeg.p1};
        return this.geomFactory.createLineString(coordinateArray);
    }

    private final LineString computeCurve(Coordinate[] bufferPts, Coordinate[] rawOffset) {
        boolean[] isInCurve = new boolean[bufferPts.length - 1];
        SegmentMCIndex segIndex = new SegmentMCIndex(bufferPts);
        int curveStart = -1;
        Intrinsics.checkNotNull((Object)rawOffset);
        int n = rawOffset.length - 1;
        for (int i = 0; i < n; ++i) {
            int index = this.markMatchingSegments(rawOffset[i], rawOffset[i + 1], segIndex, bufferPts, isInCurve);
            if (curveStart >= 0) continue;
            curveStart = index;
        }
        Coordinate[] curvePts = OffsetCurve.Companion.extractSection(bufferPts, curveStart, isInCurve);
        return this.geomFactory.createLineString(curvePts);
    }

    private final int markMatchingSegments(Coordinate p0, Coordinate p1, SegmentMCIndex segIndex, Coordinate[] bufferPts, boolean[] isInCurve) {
        Coordinate coordinate = p0;
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coordinate2 = p1;
        Intrinsics.checkNotNull((Object)coordinate2);
        Envelope matchEnv = new Envelope(coordinate, coordinate2);
        matchEnv.expandBy(this.matchDistance);
        MatchCurveSegmentAction action = new MatchCurveSegmentAction(p0, p1, bufferPts, this.matchDistance, isInCurve);
        segIndex.query(matchEnv, action);
        return action.getMinCurveIndex();
    }

    @JvmOverloads
    public OffsetCurve(@NotNull Geometry inputGeom, double distance) {
        Intrinsics.checkNotNullParameter((Object)inputGeom, (String)"inputGeom");
        this(inputGeom, distance, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Geometry getCurve(@NotNull Geometry geom, double distance) {
        return Companion.getCurve(geom, distance);
    }

    @JvmStatic
    @NotNull
    public static final Geometry getCurve(@NotNull Geometry geom, double distance, int quadSegs, int joinStyle, double mitreLimit) {
        return Companion.getCurve(geom, distance, quadSegs, joinStyle, mitreLimit);
    }

    public static final /* synthetic */ double access$getDistance$p(OffsetCurve $this) {
        return $this.distance;
    }

    public static final /* synthetic */ LineString access$computeCurve(OffsetCurve $this, LineString lineGeom, double distance) {
        return $this.computeCurve(lineGeom, distance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0018\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\nH\u0007J1\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J$\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0016H\u0002J4\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010 \u001a\u00020\nH\u0002J1\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020%H\u0002\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetCurve$Companion;", "", "<init>", "()V", "NEARNESS_FACTOR", "", "getCurve", "Lorg/locationtech/jts/geom/Geometry;", "geom", "distance", "", "quadSegs", "joinStyle", "mitreLimit", "rawOffset", "", "Lorg/locationtech/jts/geom/Coordinate;", "Lorg/locationtech/jts/geom/LineString;", "bufParams", "Lorg/locationtech/jts/operation/buffer/BufferParameters;", "(Lorg/locationtech/jts/geom/LineString;DLorg/locationtech/jts/operation/buffer/BufferParameters;)[Lorg/locationtech/jts/geom/Coordinate;", "getBufferOriented", "Lorg/locationtech/jts/geom/Polygon;", "extractMaxAreaPolygon", "extractLongestHole", "Lorg/locationtech/jts/geom/LinearRing;", "poly", "subsegmentMatchFrac", "p0", "p1", "seg0", "seg1", "matchDistance", "extractSection", "ring", "startIndex", "isExtracted", "", "([Lorg/locationtech/jts/geom/Coordinate;I[Z)[Lorg/locationtech/jts/geom/Coordinate;", "next", "i", "size", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry getCurve(@NotNull Geometry geom, double distance) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            OffsetCurve oc = new OffsetCurve(geom, distance, null, 4, null);
            return oc.getCurve();
        }

        @JvmStatic
        @NotNull
        public final Geometry getCurve(@NotNull Geometry geom, double distance, int quadSegs, int joinStyle, double mitreLimit) {
            Intrinsics.checkNotNullParameter((Object)geom, (String)"geom");
            BufferParameters bufferParams = new BufferParameters();
            if (quadSegs >= 0) {
                bufferParams.setQuadrantSegments(quadSegs);
            }
            if (joinStyle >= 0) {
                bufferParams.setJoinStyle(joinStyle);
            }
            if (mitreLimit >= 0.0) {
                bufferParams.setMitreLimit(mitreLimit);
            }
            OffsetCurve oc = new OffsetCurve(geom, distance, bufferParams);
            return oc.getCurve();
        }

        @JvmOverloads
        @Nullable
        public final Coordinate[] rawOffset(@Nullable LineString geom, double distance, @NotNull BufferParameters bufParams) {
            Intrinsics.checkNotNullParameter((Object)bufParams, (String)"bufParams");
            LineString lineString = geom;
            Intrinsics.checkNotNull((Object)lineString);
            OffsetCurveBuilder ocb = new OffsetCurveBuilder(lineString.getFactory().getPrecisionModel(), bufParams);
            return ocb.getOffsetCurve(geom.getCoordinates(), distance);
        }

        public static /* synthetic */ Coordinate[] rawOffset$default(Companion companion, LineString lineString, double d, BufferParameters bufferParameters, int n, Object object) {
            if ((n & 4) != 0) {
                bufferParameters = new BufferParameters();
            }
            return companion.rawOffset(lineString, d, bufferParameters);
        }

        private final Polygon getBufferOriented(LineString geom, double distance, BufferParameters bufParams) {
            Geometry buffer = BufferOp.Companion.bufferOp((Geometry)geom, Math.INSTANCE.abs(distance), bufParams);
            Polygon bufferPoly = this.extractMaxAreaPolygon(buffer);
            if (distance < 0.0) {
                Polygon polygon = bufferPoly;
                Intrinsics.checkNotNull((Object)polygon);
                bufferPoly = polygon.reverse();
            }
            return bufferPoly;
        }

        private final Polygon extractMaxAreaPolygon(Geometry geom) {
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            if (geometry.getNumGeometries() == 1) {
                return (Polygon)geom;
            }
            double maxArea = 0.0;
            Polygon maxPoly = null;
            int n = geom.getNumGeometries();
            for (int i = 0; i < n; ++i) {
                Geometry geometry2 = geom.getGeometryN(i);
                Intrinsics.checkNotNull((Object)geometry2, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Polygon");
                Polygon poly = (Polygon)geometry2;
                double area = poly.getArea();
                if (maxPoly != null && !(area > maxArea)) continue;
                maxPoly = poly;
                maxArea = area;
            }
            return maxPoly;
        }

        private final LinearRing extractLongestHole(Polygon poly) {
            LinearRing largestHole = null;
            double maxLen = -1.0;
            Polygon polygon = poly;
            Intrinsics.checkNotNull((Object)polygon);
            int n = polygon.getNumInteriorRing();
            for (int i = 0; i < n; ++i) {
                LinearRing hole = poly.getInteriorRingN(i);
                double len = hole.getLength();
                if (!(len > maxLen)) continue;
                largestHole = hole;
                maxLen = len;
            }
            return largestHole;
        }

        private final double subsegmentMatchFrac(Coordinate p0, Coordinate p1, Coordinate seg0, Coordinate seg1, double matchDistance) {
            Coordinate coordinate = seg0;
            Intrinsics.checkNotNull((Object)coordinate);
            Coordinate coordinate2 = seg1;
            Intrinsics.checkNotNull((Object)coordinate2);
            if (matchDistance < Distance.pointToSegment(p0, coordinate, coordinate2)) {
                return -1.0;
            }
            if (matchDistance < Distance.pointToSegment(p1, seg0, seg1)) {
                return -1.0;
            }
            LineSegment seg = new LineSegment(seg0, seg1);
            return seg.segmentFraction(p0);
        }

        private final Coordinate[] extractSection(Coordinate[] ring, int startIndex, boolean[] isExtracted) {
            if (startIndex < 0) {
                return new Coordinate[0];
            }
            CoordinateList coordList = new CoordinateList();
            int i = startIndex;
            do {
                coordList.add(ring[i], false);
            } while (isExtracted[i] && (i = this.next(i, ring.length - 1)) != startIndex);
            if (isExtracted[i]) {
                coordList.add(ring[i], false);
            }
            return coordList.size() == 1 ? new Coordinate[]{} : coordList.toCoordinateArray();
        }

        private final int next(int i, int size) {
            int i2 = i;
            return ++i2 < size ? i2 : 0;
        }

        @JvmOverloads
        @Nullable
        public final Coordinate[] rawOffset(@Nullable LineString geom, double distance) {
            return org.locationtech.jts.operation.buffer.OffsetCurve$Companion.rawOffset$default(this, geom, distance, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B9\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/operation/buffer/OffsetCurve$MatchCurveSegmentAction;", "Lorg/locationtech/jts/index/chain/MonotoneChainSelectAction;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "bufferPts", "", "matchDistance", "", "isInCurve", "", "<init>", "(Lorg/locationtech/jts/geom/Coordinate;Lorg/locationtech/jts/geom/Coordinate;[Lorg/locationtech/jts/geom/Coordinate;D[Z)V", "[Lorg/locationtech/jts/geom/Coordinate;", "minFrac", "value", "", "minCurveIndex", "getMinCurveIndex", "()I", "select", "", "mc", "Lorg/locationtech/jts/index/chain/MonotoneChain;", "segIndex", "kts-core"})
    private static final class MatchCurveSegmentAction
    extends MonotoneChainSelectAction {
        @Nullable
        private final Coordinate p0;
        @Nullable
        private final Coordinate p1;
        @NotNull
        private final Coordinate[] bufferPts;
        private final double matchDistance;
        @NotNull
        private final boolean[] isInCurve;
        private double minFrac;
        private int minCurveIndex;

        public MatchCurveSegmentAction(@Nullable Coordinate p0, @Nullable Coordinate p1, @NotNull Coordinate[] bufferPts, double matchDistance, @NotNull boolean[] isInCurve) {
            Intrinsics.checkNotNullParameter((Object)bufferPts, (String)"bufferPts");
            Intrinsics.checkNotNullParameter((Object)isInCurve, (String)"isInCurve");
            this.p0 = p0;
            this.p1 = p1;
            this.bufferPts = bufferPts;
            this.matchDistance = matchDistance;
            this.isInCurve = isInCurve;
            this.minFrac = -1.0;
            this.minCurveIndex = -1;
        }

        public final int getMinCurveIndex() {
            return this.minCurveIndex;
        }

        @Override
        public void select(@NotNull MonotoneChain mc, int segIndex) {
            Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
            double frac = Companion.subsegmentMatchFrac(this.bufferPts[segIndex], this.bufferPts[segIndex + 1], this.p0, this.p1, this.matchDistance);
            if (frac < 0.0) {
                return;
            }
            this.isInCurve[segIndex] = true;
            if (this.minFrac < 0.0 || frac < this.minFrac) {
                this.minFrac = frac;
                this.minCurveIndex = segIndex;
            }
        }
    }
}

