/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0016H\u0002J0\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\fH\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006("}, d2={"Lorg/locationtech/jts/operation/buffer/VariableBuffer;", "", "line", "Lorg/locationtech/jts/geom/Geometry;", "distance", "", "<init>", "(Lorg/locationtech/jts/geom/Geometry;[D)V", "Lorg/locationtech/jts/geom/LineString;", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "quadrantSegs", "", "result", "getResult", "()Lorg/locationtech/jts/geom/Geometry;", "segmentBuffer", "Lorg/locationtech/jts/geom/Polygon;", "p0", "Lorg/locationtech/jts/geom/Coordinate;", "p1", "dist0", "", "dist1", "circle", "center", "radius", "addCap", "", "p", "r", "t1", "t2", "coords", "Lorg/locationtech/jts/geom/CoordinateList;", "capAngle", "index", "capAngleIndex", "ang", "Companion", "kts-core"})
public final class VariableBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LineString line;
    @NotNull
    private final double[] distance;
    @NotNull
    private final GeometryFactory geomFactory;
    private final int quadrantSegs;
    private static final double SNAP_TRIG_TOL = 1.0E-6;

    public VariableBuffer(@NotNull Geometry line, @NotNull double[] distance) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
        this.quadrantSegs = 8;
        this.line = (LineString)line;
        this.distance = distance;
        this.geomFactory = line.getFactory();
        if (distance.length != this.line.getNumPoints()) {
            throw new IllegalArgumentException("Number of distances is not equal to number of vertices");
        }
    }

    @NotNull
    public final Geometry getResult() {
        Geometry buffer;
        List parts = new ArrayList();
        Coordinate[] pts = this.line.getCoordinates();
        int n = pts.length;
        for (int i = 1; i < n; ++i) {
            Polygon poly;
            double dist0 = this.distance[i - 1];
            double dist1 = this.distance[i];
            if (!(dist0 > 0.0) && !(dist1 > 0.0) || (poly = this.segmentBuffer(pts[i - 1], pts[i], dist0, dist1)) == null) continue;
            parts.add(poly);
        }
        GeometryCollection partsGeom = this.geomFactory.createGeometryCollection(GeometryFactory.Companion.toGeometryArray(parts));
        Geometry geometry = buffer = partsGeom.union();
        Intrinsics.checkNotNull((Object)geometry);
        return geometry.isEmpty() ? (Geometry)GeometryFactory.createPolygon$default(this.geomFactory, null, null, 3, null) : buffer;
    }

    private final Polygon segmentBuffer(Coordinate p0, Coordinate p1, double dist0, double dist1) {
        if (dist0 > dist1) {
            return this.segmentBuffer(p1, p0, dist1, dist0);
        }
        LineSegment tangent = VariableBuffer.Companion.outerTangent(p0, dist0, p1, dist1);
        if (tangent == null) {
            Coordinate center = p0;
            double dist = dist0;
            if (dist1 > dist0) {
                center = p1;
                dist = dist1;
            }
            return this.circle(center, dist);
        }
        Coordinate t0 = tangent.getCoordinate(0);
        Coordinate t1 = tangent.getCoordinate(1);
        LineSegment seg = new LineSegment(p0, p1);
        Coordinate tr0 = seg.reflect(t0);
        Coordinate tr1 = seg.reflect(t1);
        CoordinateList coords = new CoordinateList();
        coords.add(t0);
        coords.add(t1);
        this.addCap(p1, dist1, t1, tr1, coords);
        coords.add(tr1);
        coords.add(tr0);
        this.addCap(p0, dist0, tr0, t0, coords);
        coords.add(t0);
        Coordinate[] pts = coords.toCoordinateArray();
        return this.geomFactory.createPolygon(pts);
    }

    private final Polygon circle(Coordinate center, double radius) {
        if (radius <= 0.0) {
            return null;
        }
        int nPts = 4 * this.quadrantSegs;
        Object[] pts = new Coordinate[nPts + 1];
        double angInc = 1.5707963267948966 / (double)this.quadrantSegs;
        for (int i = 0; i < nPts; ++i) {
            pts[i] = VariableBuffer.Companion.projectPolar(center, radius, (double)i * angInc);
        }
        int n = pts.length - 1;
        Coordinate coordinate = pts[0];
        Intrinsics.checkNotNull((Object)coordinate);
        pts[n] = coordinate.copy();
        return this.geomFactory.createPolygon((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
    }

    private final void addCap(Coordinate p, double r, Coordinate t1, Coordinate t2, CoordinateList coords) {
        int i;
        double angEnd;
        double angStart = Angle.INSTANCE.angle(p, t1);
        if (angStart < (angEnd = Angle.INSTANCE.angle(p, t2))) {
            angStart += java.lang.Math.PI * 2;
        }
        int indexStart = this.capAngleIndex(angStart);
        int indexEnd = this.capAngleIndex(angEnd);
        int n = indexEnd + 1;
        if (n <= (i = indexStart)) {
            while (true) {
                double ang = this.capAngle(i);
                coords.add(VariableBuffer.Companion.projectPolar(p, r, ang));
                if (i == n) break;
                --i;
            }
        }
    }

    private final double capAngle(int index) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        return (double)index * capSegAng;
    }

    private final int capAngleIndex(double ang) {
        double capSegAng = 1.5707963267948966 / (double)this.quadrantSegs;
        return (int)(ang / capSegAng);
    }

    @JvmStatic
    @NotNull
    public static final Geometry buffer(@NotNull Geometry line, double startDistance, double endDistance) {
        return Companion.buffer(line, startDistance, endDistance);
    }

    @JvmStatic
    @NotNull
    public static final Geometry buffer(@NotNull Geometry line, double startDistance, double midDistance, double endDistance) {
        return Companion.buffer(line, startDistance, midDistance, endDistance);
    }

    @JvmStatic
    @NotNull
    public static final Geometry buffer(@NotNull Geometry line, @NotNull double[] distance) {
        return Companion.buffer(line, distance);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0007J \u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J(\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J#\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u001cJ*\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\bH\u0002J \u0010#\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\bH\u0002J\u0010\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\bH\u0002R\u000e\u0010'\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/locationtech/jts/operation/buffer/VariableBuffer$Companion;", "", "<init>", "()V", "buffer", "Lorg/locationtech/jts/geom/Geometry;", "line", "startDistance", "", "endDistance", "midDistance", "distance", "", "interpolate", "Lorg/locationtech/jts/geom/LineString;", "startValue", "endValue", "midValue", "indexAtLength", "", "pts", "", "Lorg/locationtech/jts/geom/Coordinate;", "targetLen", "([Lorg/locationtech/jts/geom/Coordinate;D)I", "length", "i1", "i2", "([Lorg/locationtech/jts/geom/Coordinate;II)D", "outerTangent", "Lorg/locationtech/jts/geom/LineSegment;", "c1", "r1", "c2", "r2", "projectPolar", "p", "r", "ang", "SNAP_TRIG_TOL", "snapTrig", "x", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Geometry buffer(@NotNull Geometry line, double startDistance, double endDistance) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            double[] distance = this.interpolate((LineString)line, startDistance, endDistance);
            VariableBuffer vb = new VariableBuffer(line, distance);
            return vb.getResult();
        }

        @JvmStatic
        @NotNull
        public final Geometry buffer(@NotNull Geometry line, double startDistance, double midDistance, double endDistance) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            double[] distance = this.interpolate((LineString)line, startDistance, midDistance, endDistance);
            VariableBuffer vb = new VariableBuffer(line, distance);
            return vb.getResult();
        }

        @JvmStatic
        @NotNull
        public final Geometry buffer(@NotNull Geometry line, @NotNull double[] distance) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            Intrinsics.checkNotNullParameter((Object)distance, (String)"distance");
            VariableBuffer vb = new VariableBuffer(line, distance);
            return vb.getResult();
        }

        private final double[] interpolate(LineString line, double startValue, double endValue) {
            double startValue2 = startValue;
            double endValue2 = endValue;
            startValue2 = Math.INSTANCE.abs(startValue2);
            endValue2 = Math.INSTANCE.abs(endValue2);
            double[] values2 = new double[line.getNumPoints()];
            values2[0] = startValue2;
            values2[values2.length - 1] = endValue2;
            double totalLen = line.getLength();
            Coordinate[] pts = line.getCoordinates();
            double currLen = 0.0;
            int n = values2.length - 1;
            for (int i = 1; i < n; ++i) {
                double segLen = pts[i].distance(pts[i - 1]);
                double lenFrac = (currLen += segLen) / totalLen;
                double delta = lenFrac * (endValue2 - startValue2);
                values2[i] = startValue2 + delta;
            }
            return values2;
        }

        private final double[] interpolate(LineString line, double startValue, double midValue, double endValue) {
            double startValue2 = startValue;
            double midValue2 = midValue;
            double endValue2 = endValue;
            startValue2 = Math.INSTANCE.abs(startValue2);
            midValue2 = Math.INSTANCE.abs(midValue2);
            endValue2 = Math.INSTANCE.abs(endValue2);
            double[] values2 = new double[line.getNumPoints()];
            values2[0] = startValue2;
            values2[values2.length - 1] = endValue2;
            Coordinate[] pts = line.getCoordinates();
            double lineLen = line.getLength();
            int midIndex = this.indexAtLength(pts, lineLen / (double)2);
            double delMidStart = midValue2 - startValue2;
            double delEndMid = endValue2 - midValue2;
            double lenSM = this.length(pts, 0, midIndex);
            double currLen = 0.0;
            int i = 1;
            if (i <= midIndex) {
                while (true) {
                    double val;
                    double segLen = pts[i].distance(pts[i - 1]);
                    double lenFrac = (currLen += segLen) / lenSM;
                    values2[i] = val = startValue2 + lenFrac * delMidStart;
                    if (i == midIndex) break;
                    ++i;
                }
            }
            double lenME = this.length(pts, midIndex, pts.length - 1);
            currLen = 0.0;
            int n = values2.length - 1;
            for (int i2 = midIndex + 1; i2 < n; ++i2) {
                double val;
                double segLen = pts[i2].distance(pts[i2 - 1]);
                double lenFrac = (currLen += segLen) / lenME;
                values2[i2] = val = midValue2 + lenFrac * delEndMid;
            }
            return values2;
        }

        private final int indexAtLength(Coordinate[] pts, double targetLen) {
            double len = 0.0;
            int n = pts.length;
            for (int i = 1; i < n; ++i) {
                if (!((len += pts[i].distance(pts[i - 1])) > targetLen)) continue;
                return i;
            }
            return pts.length - 1;
        }

        private final double length(Coordinate[] pts, int i1, int i2) {
            double len = 0.0;
            int i = i1 + 1;
            if (i <= i2) {
                while (true) {
                    len += pts[i].distance(pts[i - 1]);
                    if (i == i2) break;
                    ++i;
                }
            }
            return len;
        }

        private final LineSegment outerTangent(Coordinate c1, double r1, Coordinate c2, double r2) {
            if (r1 > r2) {
                LineSegment seg;
                LineSegment lineSegment = seg = this.outerTangent(c2, r2, c1, r1);
                Intrinsics.checkNotNull((Object)lineSegment);
                return new LineSegment(lineSegment.p1, seg.p0);
            }
            double x1 = c1.x;
            double y1 = c1.y;
            double x2 = c2.x;
            double y2 = c2.y;
            double a3 = -Math.INSTANCE.atan2(y2 - y1, x2 - x1);
            double dr = r2 - r1;
            double d = Math.INSTANCE.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
            double a2 = java.lang.Math.asin(dr / d);
            if (Math.INSTANCE.isNaN(a2)) {
                return null;
            }
            double a1 = a3 - a2;
            double aa = 1.5707963267948966 - a1;
            double x3 = x1 + r1 * Math.INSTANCE.cos(aa);
            double y3 = y1 + r1 * Math.INSTANCE.sin(aa);
            double x4 = x2 + r2 * Math.INSTANCE.cos(aa);
            double y4 = y2 + r2 * Math.INSTANCE.sin(aa);
            return new LineSegment(x3, y3, x4, y4);
        }

        private final Coordinate projectPolar(Coordinate p, double r, double ang) {
            double x = p.x + r * this.snapTrig(Math.INSTANCE.cos(ang));
            double y = p.y + r * this.snapTrig(Math.INSTANCE.sin(ang));
            return new Coordinate(x, y);
        }

        private final double snapTrig(double x) {
            if (x > 0.999999) {
                return 1.0;
            }
            if (x < -0.999999) {
                return -1.0;
            }
            return Math.INSTANCE.abs(x) < 1.0E-6 ? 0.0 : x;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

