/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.distance;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.distance.FacetSequence;
import org.locationtech.jts.operation.distance.FacetSequenceTreeBuilder;
import org.locationtech.jts.operation.distance.GeometryLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/distance/IndexedFacetDistance;", "", "baseGeometry", "Lorg/locationtech/jts/geom/Geometry;", "<init>", "(Lorg/locationtech/jts/geom/Geometry;)V", "cachedTree", "Lorg/locationtech/jts/index/strtree/STRtree;", "distance", "", "g", "nearestLocations", "", "Lorg/locationtech/jts/operation/distance/GeometryLocation;", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/operation/distance/GeometryLocation;", "nearestPoints", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "isWithinDistance", "", "maxDistance", "FacetSequenceDistance", "Companion", "kts-core"})
public final class IndexedFacetDistance {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry baseGeometry;
    @NotNull
    private final STRtree cachedTree;
    @NotNull
    private static final FacetSequenceDistance FACET_SEQ_DIST = new FacetSequenceDistance();

    public IndexedFacetDistance(@NotNull Geometry baseGeometry) {
        Intrinsics.checkNotNullParameter((Object)baseGeometry, (String)"baseGeometry");
        this.baseGeometry = baseGeometry;
        this.cachedTree = FacetSequenceTreeBuilder.INSTANCE.build(this.baseGeometry);
    }

    public final double distance(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        STRtree tree2 = FacetSequenceTreeBuilder.INSTANCE.build(geometry);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        Intrinsics.checkNotNull((Object)obj);
        Object object = obj[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        FacetSequence fs1 = (FacetSequence)object;
        Object object2 = obj[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        FacetSequence fs2 = (FacetSequence)object2;
        return fs1.distance(fs2);
    }

    @NotNull
    public final GeometryLocation[] nearestLocations(@Nullable Geometry g) {
        Geometry geometry = g;
        Intrinsics.checkNotNull((Object)geometry);
        STRtree tree2 = FacetSequenceTreeBuilder.INSTANCE.build(geometry);
        Object[] obj = this.cachedTree.nearestNeighbour(tree2, FACET_SEQ_DIST);
        Intrinsics.checkNotNull((Object)obj);
        Object object = obj[0];
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        FacetSequence fs1 = (FacetSequence)object;
        Object object2 = obj[1];
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
        FacetSequence fs2 = (FacetSequence)object2;
        return fs1.nearestLocations(fs2);
    }

    @Nullable
    public final Coordinate[] nearestPoints(@Nullable Geometry g) {
        GeometryLocation[] minDistanceLocation = this.nearestLocations(g);
        return IndexedFacetDistance.Companion.toPoints(minDistanceLocation);
    }

    public final boolean isWithinDistance(@NotNull Geometry g, double maxDistance) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        double envDist = this.baseGeometry.getEnvelopeInternal().distance(g.getEnvelopeInternal());
        if (envDist > maxDistance) {
            return false;
        }
        STRtree tree2 = FacetSequenceTreeBuilder.INSTANCE.build(g);
        return this.cachedTree.isWithinDistance(tree2, FACET_SEQ_DIST, maxDistance);
    }

    @JvmStatic
    public static final double distance(@NotNull Geometry g1, @Nullable Geometry g2) {
        return Companion.distance(g1, g2);
    }

    @JvmStatic
    public static final boolean isWithinDistance(@NotNull Geometry g1, @NotNull Geometry g2, double distance) {
        return Companion.isWithinDistance(g1, g2, distance);
    }

    @JvmStatic
    @Nullable
    public static final Coordinate[] nearestPoints(@NotNull Geometry g1, @Nullable Geometry g2) {
        return Companion.nearestPoints(g1, g2);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J'\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0007\u00a2\u0006\u0002\u0010\u0010J%\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/distance/IndexedFacetDistance$Companion;", "", "<init>", "()V", "FACET_SEQ_DIST", "Lorg/locationtech/jts/operation/distance/IndexedFacetDistance$FacetSequenceDistance;", "distance", "", "g1", "Lorg/locationtech/jts/geom/Geometry;", "g2", "isWithinDistance", "", "nearestPoints", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)[Lorg/locationtech/jts/geom/Coordinate;", "toPoints", "locations", "Lorg/locationtech/jts/operation/distance/GeometryLocation;", "([Lorg/locationtech/jts/operation/distance/GeometryLocation;)[Lorg/locationtech/jts/geom/Coordinate;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final double distance(@NotNull Geometry g1, @Nullable Geometry g2) {
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            IndexedFacetDistance dist = new IndexedFacetDistance(g1);
            return dist.distance(g2);
        }

        @JvmStatic
        public final boolean isWithinDistance(@NotNull Geometry g1, @NotNull Geometry g2, double distance) {
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
            IndexedFacetDistance dist = new IndexedFacetDistance(g1);
            return dist.isWithinDistance(g2, distance);
        }

        @JvmStatic
        @Nullable
        public final Coordinate[] nearestPoints(@NotNull Geometry g1, @Nullable Geometry g2) {
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            IndexedFacetDistance dist = new IndexedFacetDistance(g1);
            return dist.nearestPoints(g2);
        }

        private final Coordinate[] toPoints(GeometryLocation[] locations) {
            Coordinate[] coordinateArray;
            if (locations == null) {
                coordinateArray = null;
            } else {
                Coordinate[] coordinateArray2 = new Coordinate[2];
                Intrinsics.checkNotNull((Object)locations[0].getCoordinate());
                Intrinsics.checkNotNull((Object)locations[1].getCoordinate());
                coordinateArray = coordinateArray2;
            }
            return coordinateArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/operation/distance/IndexedFacetDistance$FacetSequenceDistance;", "Lorg/locationtech/jts/index/strtree/ItemDistance;", "<init>", "()V", "distance", "", "item1", "Lorg/locationtech/jts/index/strtree/ItemBoundable;", "item2", "kts-core"})
    private static final class FacetSequenceDistance
    implements ItemDistance {
        @Override
        public double distance(@NotNull ItemBoundable item1, @NotNull ItemBoundable item2) {
            Intrinsics.checkNotNullParameter((Object)item1, (String)"item1");
            Intrinsics.checkNotNullParameter((Object)item2, (String)"item2");
            Object object = item1.getItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
            FacetSequence fs1 = (FacetSequence)object;
            Object object2 = item2.getItem();
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.distance.FacetSequence");
            FacetSequence fs2 = (FacetSequence)object2;
            return fs1.distance(fs2);
        }
    }
}

