/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.PointLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geomgraph.EdgeEndStar;
import org.locationtech.jts.geomgraph.Label;
import org.locationtech.jts.geomgraph.Node;
import org.locationtech.jts.operation.overlay.OverlayOp;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/overlay/PointBuilder;", "", "op", "Lorg/locationtech/jts/operation/overlay/OverlayOp;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "ptLocator", "Lorg/locationtech/jts/algorithm/PointLocator;", "<init>", "(Lorg/locationtech/jts/operation/overlay/OverlayOp;Lorg/locationtech/jts/geom/GeometryFactory;Lorg/locationtech/jts/algorithm/PointLocator;)V", "resultPointList", "", "Lorg/locationtech/jts/geom/Geometry;", "build", "", "opCode", "", "extractNonCoveredResultNodes", "", "filterCoveredNodeToPoint", "n", "Lorg/locationtech/jts/geomgraph/Node;", "kts-core"})
public final class PointBuilder {
    @NotNull
    private final OverlayOp op;
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final List<Geometry> resultPointList;

    public PointBuilder(@NotNull OverlayOp op, @NotNull GeometryFactory geometryFactory, @Nullable PointLocator ptLocator) {
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.resultPointList = new ArrayList();
    }

    @NotNull
    public final List<Geometry> build(int opCode) {
        this.extractNonCoveredResultNodes(opCode);
        return this.resultPointList;
    }

    private final void extractNonCoveredResultNodes(int opCode) {
        Iterator<?> nodeit = this.op.getGraph().getNodes().iterator();
        while (nodeit.hasNext()) {
            Label label;
            Object obj = nodeit.next();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geomgraph.Node");
            Node n = (Node)obj;
            if (n.isInResult() || n.isIncidentEdgeInResult()) continue;
            EdgeEndStar edgeEndStar = n.getEdges();
            Intrinsics.checkNotNull((Object)edgeEndStar);
            if (edgeEndStar.getDegree() != 0 && opCode != 1) continue;
            Intrinsics.checkNotNull((Object)n.getLabel());
            if (!OverlayOp.Companion.isResultOfOp(label, opCode)) continue;
            this.filterCoveredNodeToPoint(n);
        }
    }

    private final void filterCoveredNodeToPoint(Node n) {
        Coordinate coordinate = n.getCoordinate();
        Intrinsics.checkNotNull((Object)coordinate);
        Coordinate coord = coordinate;
        if (!this.op.isCoveredByLA(coord)) {
            Point pt = this.geometryFactory.createPoint(coord);
            this.resultPointList.add(pt);
        }
    }
}

