/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlay.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Location;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.locationtech.jts.operation.overlay.validate.FuzzyPointLocator;
import org.locationtech.jts.operation.overlay.validate.OffsetPointGenerator;
import org.locationtech.jts.util.Debug;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0001%B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0002J\u0010\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0018\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010#\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u001aH\u0002R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/locationtech/jts/operation/overlay/validate/OverlayResultValidator;", "", "a", "Lorg/locationtech/jts/geom/Geometry;", "b", "result", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "geom", "", "[Lorg/locationtech/jts/geom/Geometry;", "locFinder", "Lorg/locationtech/jts/operation/overlay/validate/FuzzyPointLocator;", "[Lorg/locationtech/jts/operation/overlay/validate/FuzzyPointLocator;", "location", "", "value", "Lorg/locationtech/jts/geom/Coordinate;", "invalidLocation", "getInvalidLocation", "()Lorg/locationtech/jts/geom/Coordinate;", "boundaryDistanceTolerance", "", "testCoords", "", "isValid", "", "overlayOp", "", "addTestPts", "", "g", "checkValid", "pt", "isValidResult", "reportResult", "expectedInterior", "Companion", "kts-core"})
public final class OverlayResultValidator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry[] geom;
    @NotNull
    private final FuzzyPointLocator[] locFinder;
    @NotNull
    private final int[] location;
    @Nullable
    private Coordinate invalidLocation;
    private double boundaryDistanceTolerance;
    @NotNull
    private final List<Coordinate> testCoords;
    private static final double TOLERANCE = 1.0E-6;

    public OverlayResultValidator(@NotNull Geometry a, @NotNull Geometry b, @NotNull Geometry result2) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this.location = new int[3];
        this.boundaryDistanceTolerance = 1.0E-6;
        this.testCoords = new ArrayList();
        this.boundaryDistanceTolerance = OverlayResultValidator.Companion.computeBoundaryDistanceTolerance(a, b);
        Object[] objectArray = new Geometry[]{a, b, result2};
        this.geom = objectArray;
        objectArray = new FuzzyPointLocator[]{new FuzzyPointLocator(this.geom[0], this.boundaryDistanceTolerance), new FuzzyPointLocator(this.geom[1], this.boundaryDistanceTolerance), new FuzzyPointLocator(this.geom[2], this.boundaryDistanceTolerance)};
        this.locFinder = objectArray;
    }

    @Nullable
    public final Coordinate getInvalidLocation() {
        return this.invalidLocation;
    }

    public final boolean isValid(int overlayOp) {
        this.addTestPts(this.geom[0]);
        this.addTestPts(this.geom[1]);
        return this.checkValid(overlayOp);
    }

    private final void addTestPts(Geometry g) {
        OffsetPointGenerator ptGen = new OffsetPointGenerator(g);
        this.testCoords.addAll((Collection<Coordinate>)ptGen.getPoints((double)5 * this.boundaryDistanceTolerance));
    }

    private final boolean checkValid(int overlayOp) {
        int n = ((Collection)this.testCoords).size();
        for (int i = 0; i < n; ++i) {
            Coordinate pt = this.testCoords.get(i);
            if (this.checkValid(overlayOp, pt)) continue;
            this.invalidLocation = pt;
            return false;
        }
        return true;
    }

    private final boolean checkValid(int overlayOp, Coordinate pt) {
        this.location[0] = this.locFinder[0].getLocation(pt);
        this.location[1] = this.locFinder[1].getLocation(pt);
        this.location[2] = this.locFinder[2].getLocation(pt);
        return OverlayResultValidator.Companion.hasLocation(this.location, 1) ? true : this.isValidResult(overlayOp, this.location);
    }

    private final boolean isValidResult(int overlayOp, int[] location) {
        boolean isValid;
        boolean expectedInterior = OverlayOp.Companion.isResultOfOp(location[0], location[1], overlayOp);
        boolean resultInInterior = location[2] == 0;
        boolean bl = isValid = !(expectedInterior ^ resultInInterior);
        if (!isValid) {
            this.reportResult(overlayOp, location, expectedInterior);
        }
        return isValid;
    }

    private final void reportResult(int overlayOp, int[] location, boolean expectedInterior) {
        Debug.Companion.println("Overlay result invalid - A:" + Location.INSTANCE.toLocationSymbol(location[0]) + " B:" + Location.INSTANCE.toLocationSymbol(location[1]) + " expected:" + (expectedInterior ? (char)'i' : 'e') + " actual:" + Location.INSTANCE.toLocationSymbol(location[2]));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0018\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0002R\u000e\u0010\u0010\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/overlay/validate/OverlayResultValidator$Companion;", "", "<init>", "()V", "isValid", "", "a", "Lorg/locationtech/jts/geom/Geometry;", "b", "overlayOp", "", "result", "computeBoundaryDistanceTolerance", "", "g0", "g1", "TOLERANCE", "hasLocation", "location", "", "loc", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isValid(@NotNull Geometry a, @NotNull Geometry b, int overlayOp, @NotNull Geometry result2) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            OverlayResultValidator validator = new OverlayResultValidator(a, b, result2);
            return validator.isValid(overlayOp);
        }

        private final double computeBoundaryDistanceTolerance(Geometry g0, Geometry g1) {
            return Math.INSTANCE.min(GeometrySnapper.Companion.computeSizeBasedSnapTolerance(g0), GeometrySnapper.Companion.computeSizeBasedSnapTolerance(g1));
        }

        private final boolean hasLocation(int[] location, int loc) {
            for (int i = 0; i < 3; ++i) {
                if (location[i] != loc) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

