/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayGraph;
import org.locationtech.jts.operation.overlayng.OverlayLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0012J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/locationtech/jts/operation/overlayng/IntersectionPointBuilder;", "", "graph", "Lorg/locationtech/jts/operation/overlayng/OverlayGraph;", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/OverlayGraph;Lorg/locationtech/jts/geom/GeometryFactory;)V", "geometryFactory", "points", "", "Lorg/locationtech/jts/geom/Point;", "isAllowCollapseLines", "", "setStrictMode", "", "isStrictMode", "getPoints", "", "addResultPoints", "isResultPoint", "nodeEdge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "isEdgeOf", "label", "Lorg/locationtech/jts/operation/overlayng/OverlayLabel;", "i", "", "kts-core"})
public final class IntersectionPointBuilder {
    @NotNull
    private final GeometryFactory geometryFactory;
    @NotNull
    private final OverlayGraph graph;
    @NotNull
    private final List<Point> points;
    private boolean isAllowCollapseLines;

    public IntersectionPointBuilder(@NotNull OverlayGraph graph, @NotNull GeometryFactory geomFact) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)geomFact, (String)"geomFact");
        this.points = new ArrayList();
        this.isAllowCollapseLines = true;
        this.graph = graph;
        this.geometryFactory = geomFact;
    }

    public final void setStrictMode(boolean isStrictMode) {
        this.isAllowCollapseLines = !isStrictMode;
    }

    @NotNull
    public final List<Point> getPoints() {
        this.addResultPoints();
        return this.points;
    }

    private final void addResultPoints() {
        for (OverlayEdge nodeEdge : this.graph.getNodeEdges()) {
            if (!this.isResultPoint(nodeEdge)) continue;
            Point pt = this.geometryFactory.createPoint(nodeEdge.getCoordinate().copy());
            this.points.add(pt);
        }
    }

    private final boolean isResultPoint(OverlayEdge nodeEdge) {
        HalfEdge halfEdge;
        boolean isEdgeOfA = false;
        boolean isEdgeOfB = false;
        OverlayEdge edge = nodeEdge;
        do {
            if (edge.isInResult()) {
                return false;
            }
            OverlayLabel label = edge.getLabel();
            isEdgeOfA |= this.isEdgeOf(label, 0);
            isEdgeOfB |= this.isEdgeOf(label, 1);
            halfEdge = edge.oNext();
            Intrinsics.checkNotNull((Object)halfEdge, (String)"null cannot be cast to non-null type org.locationtech.jts.operation.overlayng.OverlayEdge");
        } while ((edge = (OverlayEdge)halfEdge) != nodeEdge);
        return isEdgeOfA && isEdgeOfB;
    }

    private final boolean isEdgeOf(OverlayLabel label, int i) {
        return !this.isAllowCollapseLines && label.isBoundaryCollapse() ? false : label.isBoundary(i) || label.isLine(i);
    }
}

