/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.overlayng.OverlayEdge;
import org.locationtech.jts.operation.overlayng.OverlayEdgeRing;
import org.locationtech.jts.util.Assert;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0003H\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\bH\u0002J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing;", "", "e", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "<init>", "(Lorg/locationtech/jts/operation/overlayng/OverlayEdge;)V", "startEdge", "attachEdges", "", "buildMinimalRings", "", "Lorg/locationtech/jts/operation/overlayng/OverlayEdgeRing;", "geometryFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "linkMinimalRings", "toString", "", "coordinates", "", "Lorg/locationtech/jts/geom/Coordinate;", "getCoordinates", "()[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
public final class MaximalEdgeRing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OverlayEdge startEdge;
    private static final int STATE_FIND_INCOMING = 1;
    private static final int STATE_LINK_OUTGOING = 2;

    public MaximalEdgeRing(@NotNull OverlayEdge e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.startEdge = e;
        this.attachEdges(e);
    }

    private final void attachEdges(OverlayEdge startEdge) {
        OverlayEdge edge = startEdge;
        do {
            if (edge == null) {
                throw new TopologyException("Ring edge is null");
            }
            if (edge.getEdgeRingMax() == this) {
                throw new TopologyException("Ring edge visited twice at " + edge.getCoordinate(), edge.getCoordinate());
            }
            if (edge.nextResultMax() == null) {
                throw new TopologyException("Ring edge missing at", edge.dest());
            }
            edge.setEdgeRingMax(this);
            Intrinsics.checkNotNull((Object)edge.nextResultMax());
        } while (edge != startEdge);
    }

    @NotNull
    public final List<OverlayEdgeRing> buildMinimalRings(@NotNull GeometryFactory geometryFactory) {
        Intrinsics.checkNotNullParameter((Object)geometryFactory, (String)"geometryFactory");
        this.linkMinimalRings();
        List minEdgeRings = new ArrayList();
        OverlayEdge e = this.startEdge;
        do {
            if (e.getEdgeRing() == null) {
                OverlayEdgeRing minEr = new OverlayEdgeRing(e, geometryFactory);
                minEdgeRings.add(minEr);
            }
            Intrinsics.checkNotNull((Object)e.nextResultMax());
        } while (e != this.startEdge);
        return minEdgeRings;
    }

    private final void linkMinimalRings() {
        OverlayEdge e = this.startEdge;
        do {
            MaximalEdgeRing.Companion.linkMinRingEdgesAtNode(e, this);
            Intrinsics.checkNotNull((Object)e.nextResultMax());
        } while (e != this.startEdge);
    }

    @NotNull
    public String toString() {
        Coordinate[] pts = this.getCoordinates();
        return WKTWriter.Companion.toLineString(pts);
    }

    private final Coordinate[] getCoordinates() {
        CoordinateList coords = new CoordinateList();
        OverlayEdge edge = this.startEdge;
        do {
            coords.add(edge.orig());
            if (edge.nextResultMax() == null) break;
            Intrinsics.checkNotNull((Object)edge.nextResultMax());
        } while (edge != this.startEdge);
        coords.add(edge.dest());
        return coords.toCoordinateArray();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing$Companion;", "", "<init>", "()V", "STATE_FIND_INCOMING", "", "STATE_LINK_OUTGOING", "linkResultAreaMaxRingAtNode", "", "nodeEdge", "Lorg/locationtech/jts/operation/overlayng/OverlayEdge;", "linkMinRingEdgesAtNode", "maxRing", "Lorg/locationtech/jts/operation/overlayng/MaximalEdgeRing;", "isAlreadyLinked", "", "edge", "selectMaxOutEdge", "currOut", "maxEdgeRing", "linkMaxInEdge", "currMaxRingOut", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void linkResultAreaMaxRingAtNode(@NotNull OverlayEdge nodeEdge) {
            OverlayEdge endOut;
            Intrinsics.checkNotNullParameter((Object)nodeEdge, (String)"nodeEdge");
            Assert.INSTANCE.isTrue(nodeEdge.isInResultArea(), "Attempt to link non-result edge");
            OverlayEdge currOut = endOut = nodeEdge.oNextOE();
            int state = 1;
            OverlayEdge currResultIn = null;
            block4: do {
                if (currResultIn != null && currResultIn.isResultMaxLinked()) {
                    return;
                }
                switch (state) {
                    case 1: {
                        OverlayEdge currIn = currOut.symOE();
                        if (!currIn.isInResultArea()) break block4;
                        currResultIn = currIn;
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (!currOut.isInResultArea()) break block4;
                        OverlayEdge overlayEdge = currResultIn;
                        Intrinsics.checkNotNull((Object)overlayEdge);
                        overlayEdge.setNextResultMax(currOut);
                        state = 1;
                    }
                }
            } while ((currOut = currOut.oNextOE()) != endOut);
            if (state == 2) {
                throw new TopologyException("no outgoing edge found", nodeEdge.getCoordinate());
            }
        }

        private final void linkMinRingEdgesAtNode(OverlayEdge nodeEdge, MaximalEdgeRing maxRing) {
            OverlayEdge endOut;
            OverlayEdge currMaxRingOut = endOut = nodeEdge;
            OverlayEdge overlayEdge = endOut;
            Intrinsics.checkNotNull((Object)overlayEdge);
            OverlayEdge currOut = overlayEdge.oNextOE();
            do {
                if (this.isAlreadyLinked(currOut.symOE(), maxRing)) {
                    return;
                }
                OverlayEdge overlayEdge2 = currMaxRingOut = currMaxRingOut == null ? this.selectMaxOutEdge(currOut, maxRing) : this.linkMaxInEdge(currOut, currMaxRingOut, maxRing);
            } while ((currOut = currOut.oNextOE()) != endOut);
            if (currMaxRingOut != null) {
                OverlayEdge overlayEdge3 = nodeEdge;
                throw new TopologyException("Unmatched edge found during min-ring linking", overlayEdge3 != null ? overlayEdge3.getCoordinate() : null);
            }
        }

        private final boolean isAlreadyLinked(OverlayEdge edge, MaximalEdgeRing maxRing) {
            return edge.getEdgeRingMax() == maxRing && edge.isResultLinked();
        }

        private final OverlayEdge selectMaxOutEdge(OverlayEdge currOut, MaximalEdgeRing maxEdgeRing) {
            return currOut.getEdgeRingMax() == maxEdgeRing ? currOut : null;
        }

        private final OverlayEdge linkMaxInEdge(OverlayEdge currOut, OverlayEdge currMaxRingOut, MaximalEdgeRing maxEdgeRing) {
            OverlayEdge currIn = currOut.symOE();
            if (currIn.getEdgeRingMax() != maxEdgeRing) {
                return currMaxRingOut;
            }
            currIn.setNextResult(currMaxRingOut);
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

