/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.polygonize;

import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.polygonize.EdgeRing;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\n2\u0010\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u00010\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/operation/polygonize/HoleAssigner;", "", "shells", "", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "<init>", "(Ljava/util/List;)V", "shellIndex", "Lorg/locationtech/jts/index/SpatialIndex;", "buildIndex", "", "assignHolesToShells", "holeList", "assignHoleToShell", "holeER", "queryOverlappingShells", "ringEnv", "Lorg/locationtech/jts/geom/Envelope;", "findShellContaining", "testEr", "Companion", "kts-core"})
public final class HoleAssigner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final List<EdgeRing> shells;
    @Nullable
    private SpatialIndex shellIndex;

    public HoleAssigner(@Nullable List<EdgeRing> shells) {
        this.shells = shells;
        this.buildIndex();
    }

    private final void buildIndex() {
        this.shellIndex = new STRtree();
        List<EdgeRing> list = this.shells;
        Intrinsics.checkNotNull(list);
        for (EdgeRing shell : list) {
            SpatialIndex spatialIndex = this.shellIndex;
            Intrinsics.checkNotNull((Object)spatialIndex);
            LinearRing linearRing = shell.getRing();
            Intrinsics.checkNotNull((Object)linearRing);
            spatialIndex.insert(linearRing.getEnvelopeInternal(), shell);
        }
    }

    public final void assignHolesToShells(@Nullable List<EdgeRing> holeList) {
        List<EdgeRing> list = holeList;
        Intrinsics.checkNotNull(list);
        Iterator<EdgeRing> i = list.iterator();
        while (i.hasNext()) {
            EdgeRing holeER;
            Intrinsics.checkNotNull((Object)i.next(), (String)"null cannot be cast to non-null type org.locationtech.jts.operation.polygonize.EdgeRing");
            this.assignHoleToShell(holeER);
        }
    }

    private final void assignHoleToShell(EdgeRing holeER) {
        block0: {
            EdgeRing edgeRing = this.findShellContaining(holeER);
            if (edgeRing == null) break block0;
            edgeRing.addHole(holeER);
        }
    }

    private final List<EdgeRing> queryOverlappingShells(Envelope ringEnv) {
        SpatialIndex spatialIndex = this.shellIndex;
        Intrinsics.checkNotNull((Object)spatialIndex);
        return spatialIndex.query(ringEnv);
    }

    private final EdgeRing findShellContaining(EdgeRing testEr) {
        List<EdgeRing> candidateShells;
        LinearRing linearRing = testEr.getRing();
        Intrinsics.checkNotNull((Object)linearRing);
        Envelope testEnv = linearRing.getEnvelopeInternal();
        List<EdgeRing> list = candidateShells = this.queryOverlappingShells(testEnv);
        Intrinsics.checkNotNull(list);
        return EdgeRing.Companion.findEdgeRingContaining(testEr, list);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a8\u0006\n"}, d2={"Lorg/locationtech/jts/operation/polygonize/HoleAssigner$Companion;", "", "<init>", "()V", "assignHolesToShells", "", "holes", "", "Lorg/locationtech/jts/operation/polygonize/EdgeRing;", "shells", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        public final void assignHolesToShells(@Nullable List<EdgeRing> holes, @Nullable List<EdgeRing> shells) {
            HoleAssigner assigner = new HoleAssigner(shells);
            assigner.assignHolesToShells(holes);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

