/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.union;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.GeometryCombiner;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u0004\u0018\u00010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\r\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J \u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/operation/union/UnionInteracting;", "", "g0", "Lorg/locationtech/jts/geom/Geometry;", "g1", "<init>", "(Lorg/locationtech/jts/geom/Geometry;Lorg/locationtech/jts/geom/Geometry;)V", "geomFactory", "Lorg/locationtech/jts/geom/GeometryFactory;", "interacts0", "", "interacts1", "union", "computeInteracting", "", "", "elem0", "extractElements", "geom", "interacts", "isInteracting", "Companion", "kts-core"})
public final class UnionInteracting {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Geometry g0;
    @NotNull
    private final Geometry g1;
    @NotNull
    private final GeometryFactory geomFactory;
    @NotNull
    private final boolean[] interacts0;
    @NotNull
    private final boolean[] interacts1;

    public UnionInteracting(@NotNull Geometry g0, @NotNull Geometry g1) {
        Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
        Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
        this.g0 = g0;
        this.g1 = g1;
        this.geomFactory = this.g0.getFactory();
        this.interacts0 = new boolean[this.g0.getNumGeometries()];
        this.interacts1 = new boolean[this.g1.getNumGeometries()];
    }

    @Nullable
    public final Geometry union() {
        this.computeInteracting();
        Geometry int0 = this.extractElements(this.g0, this.interacts0, true);
        Geometry int1 = this.extractElements(this.g1, this.interacts1, true);
        Geometry union = int0.union(int1);
        Geometry disjoint0 = this.extractElements(this.g0, this.interacts0, false);
        Geometry disjoint1 = this.extractElements(this.g1, this.interacts1, false);
        return GeometryCombiner.Companion.combine(union, disjoint0, disjoint1);
    }

    private final void computeInteracting() {
        int n = this.g0.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry elem = this.g0.getGeometryN(i);
            this.interacts0[i] = this.computeInteracting(elem);
        }
    }

    private final boolean computeInteracting(Geometry elem0) {
        boolean interactsWithAny = false;
        int n = this.g1.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry elem1 = this.g1.getGeometryN(i);
            boolean interacts = elem1.getEnvelopeInternal().intersects(elem0.getEnvelopeInternal());
            if (interacts) {
                this.interacts1[i] = true;
            }
            if (!interacts) continue;
            interactsWithAny = true;
        }
        return interactsWithAny;
    }

    private final Geometry extractElements(Geometry geom, boolean[] interacts, boolean isInteracting) {
        List extractedGeoms = new ArrayList();
        int n = geom.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry elem = geom.getGeometryN(i);
            if (interacts[i] != isInteracting) continue;
            extractedGeoms.add(elem);
        }
        return this.geomFactory.buildGeometry(extractedGeoms);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005\u00a8\u0006\b"}, d2={"Lorg/locationtech/jts/operation/union/UnionInteracting$Companion;", "", "<init>", "()V", "union", "Lorg/locationtech/jts/geom/Geometry;", "g0", "g1", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Geometry union(@NotNull Geometry g0, @NotNull Geometry g1) {
            Intrinsics.checkNotNullParameter((Object)g0, (String)"g0");
            Intrinsics.checkNotNullParameter((Object)g1, (String)"g1");
            UnionInteracting uue = new UnionInteracting(g0, g1);
            return uue.union();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

