/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.operation.valid.PolygonTopologyAnalyzer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/locationtech/jts/operation/valid/IndexedNestedHoleTester;", "", "polygon", "Lorg/locationtech/jts/geom/Polygon;", "<init>", "(Lorg/locationtech/jts/geom/Polygon;)V", "index", "Lorg/locationtech/jts/index/SpatialIndex;", "value", "Lorg/locationtech/jts/geom/Coordinate;", "nestedPoint", "getNestedPoint", "()Lorg/locationtech/jts/geom/Coordinate;", "loadIndex", "", "isNested", "", "()Z", "kts-core"})
public final class IndexedNestedHoleTester {
    @NotNull
    private final Polygon polygon;
    @Nullable
    private SpatialIndex index;
    @Nullable
    private Coordinate nestedPoint;

    public IndexedNestedHoleTester(@NotNull Polygon polygon) {
        Intrinsics.checkNotNullParameter((Object)polygon, (String)"polygon");
        this.polygon = polygon;
        this.loadIndex();
    }

    @Nullable
    public final Coordinate getNestedPoint() {
        return this.nestedPoint;
    }

    private final void loadIndex() {
        this.index = new STRtree();
        int n = this.polygon.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            LinearRing hole = this.polygon.getInteriorRingN(i);
            Envelope env = hole.getEnvelopeInternal();
            SpatialIndex spatialIndex = this.index;
            Intrinsics.checkNotNull((Object)spatialIndex);
            spatialIndex.insert(env, hole);
        }
    }

    public final boolean isNested() {
        int n = this.polygon.getNumInteriorRing();
        for (int i = 0; i < n; ++i) {
            List<?> results;
            LinearRing hole = this.polygon.getInteriorRingN(i);
            SpatialIndex spatialIndex = this.index;
            Intrinsics.checkNotNull((Object)spatialIndex);
            List<?> list = results = spatialIndex.query(hole.getEnvelopeInternal());
            Intrinsics.checkNotNull(list);
            for (LinearRing testHole : list) {
                if (hole == testHole || !testHole.getEnvelopeInternal().covers(hole.getEnvelopeInternal()) || !PolygonTopologyAnalyzer.Companion.isRingNested(hole, testHole)) continue;
                this.nestedPoint = hole.getCoordinateN(0);
                return true;
            }
        }
        return false;
    }
}

