/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.valid;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Quadrant;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007J,\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007J.\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0002J$\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/locationtech/jts/operation/valid/PolygonNode;", "", "<init>", "()V", "isCrossing", "", "nodePt", "Lorg/locationtech/jts/geom/Coordinate;", "a0", "a1", "b0", "b1", "isInteriorSegment", "b", "isBetween", "origin", "p", "e0", "e1", "isAngleGreater", "q", "quadrant", "", "kts-core"})
public final class PolygonNode {
    @NotNull
    public static final PolygonNode INSTANCE = new PolygonNode();

    private PolygonNode() {
    }

    public final boolean isCrossing(@NotNull Coordinate nodePt, @Nullable Coordinate a0, @Nullable Coordinate a1, @Nullable Coordinate b0, @Nullable Coordinate b1) {
        boolean isBetween1;
        boolean isBetween0;
        Intrinsics.checkNotNullParameter((Object)nodePt, (String)"nodePt");
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        if (this.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
        }
        return (isBetween0 = this.isBetween(nodePt, b0, aLo, aHi)) != (isBetween1 = this.isBetween(nodePt, b1, aLo, aHi));
    }

    public final boolean isInteriorSegment(@NotNull Coordinate nodePt, @Nullable Coordinate a0, @Nullable Coordinate a1, @Nullable Coordinate b) {
        boolean isBetween;
        Intrinsics.checkNotNullParameter((Object)nodePt, (String)"nodePt");
        Coordinate aLo = a0;
        Coordinate aHi = a1;
        boolean isInteriorBetween = true;
        if (this.isAngleGreater(nodePt, aLo, aHi)) {
            aLo = a1;
            aHi = a0;
            isInteriorBetween = false;
        }
        return (isBetween = this.isBetween(nodePt, b, aLo, aHi)) && isInteriorBetween || !isBetween && !isInteriorBetween;
    }

    private final boolean isBetween(Coordinate origin, Coordinate p, Coordinate e0, Coordinate e1) {
        boolean isGreater0 = this.isAngleGreater(origin, p, e0);
        if (!isGreater0) {
            return false;
        }
        boolean isGreater1 = this.isAngleGreater(origin, p, e1);
        return !isGreater1;
    }

    private final boolean isAngleGreater(Coordinate origin, Coordinate p, Coordinate q) {
        int quadrantQ;
        int quadrantP = this.quadrant(origin, p);
        if (quadrantP > (quadrantQ = this.quadrant(origin, q))) {
            return true;
        }
        if (quadrantP < quadrantQ) {
            return false;
        }
        int orient = Orientation.index(origin, q, p);
        return orient == 1;
    }

    private final int quadrant(Coordinate origin, Coordinate p) {
        Coordinate coordinate = p;
        Intrinsics.checkNotNull((Object)coordinate);
        double dx = coordinate.x - origin.x;
        double dy = p.y - origin.y;
        return Quadrant.INSTANCE.quadrant(dx, dy);
    }
}

