/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u001b\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/locationtech/jts/precision/PointwisePrecisionReducerTransformer;", "Lorg/locationtech/jts/geom/util/GeometryTransformer;", "targetPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "<init>", "(Lorg/locationtech/jts/geom/PrecisionModel;)V", "transformCoordinates", "Lorg/locationtech/jts/geom/CoordinateSequence;", "coordinates", "parent", "Lorg/locationtech/jts/geom/Geometry;", "reducePointwise", "", "Lorg/locationtech/jts/geom/Coordinate;", "(Lorg/locationtech/jts/geom/CoordinateSequence;)[Lorg/locationtech/jts/geom/Coordinate;", "Companion", "kts-core"})
public final class PointwisePrecisionReducerTransformer
extends GeometryTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PrecisionModel targetPM;

    public PointwisePrecisionReducerTransformer(@NotNull PrecisionModel targetPM) {
        Intrinsics.checkNotNullParameter((Object)targetPM, (String)"targetPM");
        this.targetPM = targetPM;
    }

    @Override
    @Nullable
    protected CoordinateSequence transformCoordinates(@Nullable CoordinateSequence coordinates, @Nullable Geometry parent) {
        CoordinateSequence coordinateSequence = coordinates;
        Intrinsics.checkNotNull((Object)coordinateSequence);
        if (coordinateSequence.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.reducePointwise(coordinates);
        GeometryFactory geometryFactory = this.getFactory();
        Intrinsics.checkNotNull((Object)geometryFactory);
        return geometryFactory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private final Coordinate[] reducePointwise(CoordinateSequence coordinates) {
        Object[] coordReduce = new Coordinate[coordinates.size()];
        int n = coordinates.size();
        for (int i = 0; i < n; ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            coordReduce[i] = coord;
        }
        return (Coordinate[])ArraysKt.requireNoNulls((Object[])coordReduce);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lorg/locationtech/jts/precision/PointwisePrecisionReducerTransformer$Companion;", "", "<init>", "()V", "reduce", "Lorg/locationtech/jts/geom/Geometry;", "geom", "targetPM", "Lorg/locationtech/jts/geom/PrecisionModel;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Geometry reduce(@Nullable Geometry geom, @NotNull PrecisionModel targetPM) {
            Intrinsics.checkNotNullParameter((Object)targetPM, (String)"targetPM");
            PointwisePrecisionReducerTransformer trans = new PointwisePrecisionReducerTransformer(targetPM);
            Geometry geometry = geom;
            Intrinsics.checkNotNull((Object)geometry);
            return trans.transform(geometry);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

