/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.fractal;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.legacy.Math;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0007J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/locationtech/jts/shape/fractal/MortonCode;", "", "<init>", "()V", "MAX_LEVEL", "", "size", "level", "maxOrdinate", "numPoints", "checkLevel", "", "encode", "x", "y", "interleave", "decode", "Lorg/locationtech/jts/geom/Coordinate;", "index", "deinterleave", "", "kts-core"})
public final class MortonCode {
    @NotNull
    public static final MortonCode INSTANCE = new MortonCode();
    public static final int MAX_LEVEL = 16;

    private MortonCode() {
    }

    @JvmStatic
    public static final int size(int level) {
        INSTANCE.checkLevel(level);
        return (int)Math.INSTANCE.pow(2.0, 2 * level);
    }

    @JvmStatic
    public static final int maxOrdinate(int level) {
        INSTANCE.checkLevel(level);
        return (int)Math.INSTANCE.pow(2.0, level) - 1;
    }

    @JvmStatic
    public static final int level(int numPoints) {
        int pow2 = (int)(Math.INSTANCE.log(numPoints) / Math.INSTANCE.log(2.0));
        int level = pow2 / 2;
        int size = MortonCode.size(level);
        if (size < numPoints) {
            ++level;
        }
        return level;
    }

    private final void checkLevel(int level) {
        if (level > 16) {
            throw new IllegalArgumentException("Level must be in range 0 to 16");
        }
    }

    @JvmStatic
    public static final int encode(int x, int y) {
        return (INSTANCE.interleave(y) << 1) + INSTANCE.interleave(x);
    }

    private final int interleave(int x) {
        int x2 = x;
        x2 &= 0xFFFF;
        x2 = (x2 ^ x2 << 8) & 0xFF00FF;
        x2 = (x2 ^ x2 << 4) & 0xF0F0F0F;
        x2 = (x2 ^ x2 << 2) & 0x33333333;
        x2 = (x2 ^ x2 << 1) & 0x55555555;
        return x2;
    }

    @JvmStatic
    @NotNull
    public static final Coordinate decode(int index) {
        long x = INSTANCE.deinterleave(index);
        long y = INSTANCE.deinterleave(index >> 1);
        return new Coordinate(x, y);
    }

    private final long deinterleave(int x) {
        int x2 = x;
        x2 &= 0x55555555;
        x2 = (x2 | x2 >> 1) & 0x33333333;
        x2 = (x2 | x2 >> 2) & 0xF0F0F0F;
        x2 = (x2 | x2 >> 4) & 0xFF00FF;
        x2 = (x2 | x2 >> 8) & 0xFFFF;
        return x2;
    }
}

