/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.shape.random;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.legacy.Math;
import org.locationtech.jts.math.MathUtil;
import org.locationtech.jts.shape.GeometricShapeBuilder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\nH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Lorg/locationtech/jts/shape/random/RandomPointsInGridBuilder;", "Lorg/locationtech/jts/shape/GeometricShapeBuilder;", "<init>", "()V", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "(Lorg/locationtech/jts/geom/GeometryFactory;)V", "isConstrainedToCircle", "", "gutterFraction", "", "setConstrainedToCircle", "", "setGutterFraction", "geometry", "Lorg/locationtech/jts/geom/Geometry;", "getGeometry", "()Lorg/locationtech/jts/geom/Geometry;", "randomPointInCell", "Lorg/locationtech/jts/geom/Coordinate;", "orgX", "orgY", "xLen", "yLen", "randomPointInGridCell", "Companion", "kts-core"})
public final class RandomPointsInGridBuilder
extends GeometricShapeBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isConstrainedToCircle;
    private double gutterFraction;

    public RandomPointsInGridBuilder() {
        super(new GeometryFactory());
    }

    public RandomPointsInGridBuilder(@Nullable GeometryFactory geomFact) {
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        super(geometryFactory);
    }

    public final void setConstrainedToCircle(boolean isConstrainedToCircle) {
        this.isConstrainedToCircle = isConstrainedToCircle;
    }

    public final void setGutterFraction(double gutterFraction) {
        this.gutterFraction = gutterFraction;
    }

    @Override
    @NotNull
    public Geometry getGeometry() {
        int nCells = (int)Math.INSTANCE.sqrt(this.getNumPts());
        if (nCells * nCells < this.getNumPts()) {
            ++nCells;
        }
        double gridDX = this.getExtent().getWidth() / (double)nCells;
        double gridDY = this.getExtent().getHeight() / (double)nCells;
        double gutterFrac = MathUtil.INSTANCE.clamp(this.gutterFraction, 0.0, 1.0);
        double gutterOffsetX = gridDX * gutterFrac / (double)2;
        double gutterOffsetY = gridDY * gutterFrac / (double)2;
        double cellFrac = 1.0 - gutterFrac;
        double cellDX = cellFrac * gridDX;
        double cellDY = cellFrac * gridDY;
        Object[] pts = new Coordinate[nCells * nCells];
        int index = 0;
        int n = nCells;
        for (int i = 0; i < n; ++i) {
            int n2 = nCells;
            for (int j = 0; j < n2; ++j) {
                double orgX = this.getExtent().getMinX() + (double)i * gridDX + gutterOffsetX;
                double orgY = this.getExtent().getMinY() + (double)j * gridDY + gutterOffsetY;
                pts[index++] = this.randomPointInCell(orgX, orgY, cellDX, cellDY);
            }
        }
        return this.getGeomFactory().createMultiPointFromCoords((Coordinate[])ArraysKt.requireNoNulls((Object[])pts));
    }

    private final Coordinate randomPointInCell(double orgX, double orgY, double xLen, double yLen) {
        return this.isConstrainedToCircle ? RandomPointsInGridBuilder.Companion.randomPointInCircle(orgX, orgY, xLen, yLen) : this.randomPointInGridCell(orgX, orgY, xLen, yLen);
    }

    private final Coordinate randomPointInGridCell(double orgX, double orgY, double xLen, double yLen) {
        double x = orgX + xLen * Random.Default.nextDouble();
        double y = orgY + yLen * Random.Default.nextDouble();
        return this.createCoord(x, y);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000b"}, d2={"Lorg/locationtech/jts/shape/random/RandomPointsInGridBuilder$Companion;", "", "<init>", "()V", "randomPointInCircle", "Lorg/locationtech/jts/geom/Coordinate;", "orgX", "", "orgY", "width", "height", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        private final Coordinate randomPointInCircle(double orgX, double orgY, double width, double height) {
            double centreX = orgX + width / (double)2;
            double centreY = orgY + height / (double)2;
            double rndAng = java.lang.Math.PI * 2 * Random.Default.nextDouble();
            double rndRadius = Random.Default.nextDouble();
            double rndRadius2 = Math.INSTANCE.sqrt(rndRadius);
            double rndX = width / (double)2 * rndRadius2 * Math.INSTANCE.cos(rndAng);
            double rndY = height / (double)2 * rndRadius2 * Math.INSTANCE.sin(rndAng);
            double x0 = centreX + rndX;
            double y0 = centreY + rndY;
            return new Coordinate(x0, y0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

