/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.triangulate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.triangulate.IncrementalDelaunayTriangulator;
import org.locationtech.jts.triangulate.quadedge.QuadEdgeSubdivision;
import org.locationtech.jts.triangulate.quadedge.Vertex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005J\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/locationtech/jts/triangulate/DelaunayTriangulationBuilder;", "", "<init>", "()V", "siteCoords", "", "tolerance", "", "subdiv", "Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "setSites", "", "geom", "Lorg/locationtech/jts/geom/Geometry;", "coords", "setTolerance", "create", "subdivision", "getSubdivision", "()Lorg/locationtech/jts/triangulate/quadedge/QuadEdgeSubdivision;", "getEdges", "geomFact", "Lorg/locationtech/jts/geom/GeometryFactory;", "getTriangles", "Companion", "kts-core"})
public final class DelaunayTriangulationBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Collection<?> siteCoords;
    private double tolerance;
    @Nullable
    private QuadEdgeSubdivision subdiv;

    public final void setSites(@Nullable Geometry geom) {
        this.siteCoords = Companion.extractUniqueCoordinates(geom);
    }

    public final void setSites(@Nullable Collection<?> coords) {
        Collection<?> collection = coords;
        Intrinsics.checkNotNull(collection);
        this.siteCoords = Companion.unique(CoordinateArrays.toCoordinateArray(collection));
    }

    public final void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private final void create() {
        if (this.subdiv != null) {
            return;
        }
        Envelope siteEnv = Companion.envelope(this.siteCoords);
        List<Vertex> vertices = Companion.toVertices(this.siteCoords);
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv = new QuadEdgeSubdivision(siteEnv, this.tolerance);
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        IncrementalDelaunayTriangulator triangulator = new IncrementalDelaunayTriangulator(quadEdgeSubdivision);
        triangulator.insertSites((Collection)vertices);
    }

    @Nullable
    public final QuadEdgeSubdivision getSubdivision() {
        this.create();
        return this.subdiv;
    }

    @NotNull
    public final Geometry getEdges(@Nullable GeometryFactory geomFact) {
        this.create();
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return quadEdgeSubdivision.getEdges(geometryFactory);
    }

    @NotNull
    public final Geometry getTriangles(@Nullable GeometryFactory geomFact) {
        this.create();
        QuadEdgeSubdivision quadEdgeSubdivision = this.subdiv;
        Intrinsics.checkNotNull((Object)quadEdgeSubdivision);
        GeometryFactory geometryFactory = geomFact;
        Intrinsics.checkNotNull((Object)geometryFactory);
        return quadEdgeSubdivision.getTriangles(geometryFactory);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0019\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010J\u0014\u0010\u0011\u001a\u00020\u00122\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/locationtech/jts/triangulate/DelaunayTriangulationBuilder$Companion;", "", "<init>", "()V", "extractUniqueCoordinates", "Lorg/locationtech/jts/geom/CoordinateList;", "geom", "Lorg/locationtech/jts/geom/Geometry;", "unique", "coords", "", "Lorg/locationtech/jts/geom/Coordinate;", "([Lorg/locationtech/jts/geom/Coordinate;)Lorg/locationtech/jts/geom/CoordinateList;", "toVertices", "", "Lorg/locationtech/jts/triangulate/quadedge/Vertex;", "", "envelope", "Lorg/locationtech/jts/geom/Envelope;", "kts-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CoordinateList extractUniqueCoordinates(@Nullable Geometry geom) {
            if (geom == null) {
                return new CoordinateList();
            }
            Coordinate[] coordinateArray = geom.getCoordinates();
            Intrinsics.checkNotNull((Object)coordinateArray);
            Coordinate[] coords = coordinateArray;
            return this.unique(coords);
        }

        @NotNull
        public final CoordinateList unique(@NotNull Coordinate[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            Coordinate[] coordsCopy = CoordinateArrays.copyDeep(coords);
            ArraysKt.sort((Object[])coordsCopy);
            return new CoordinateList(coordsCopy, false);
        }

        @NotNull
        public final List<Vertex> toVertices(@Nullable Collection<?> coords) {
            List verts = new ArrayList();
            Collection<?> collection = coords;
            Intrinsics.checkNotNull(collection);
            for (Object obj : collection) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
                Coordinate coord = (Coordinate)obj;
                verts.add(new Vertex(coord));
            }
            return verts;
        }

        @NotNull
        public final Envelope envelope(@Nullable Collection<?> coords) {
            Envelope env = new Envelope();
            Collection<?> collection = coords;
            Intrinsics.checkNotNull(collection);
            for (Object obj : collection) {
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.locationtech.jts.geom.Coordinate");
                Coordinate coord = (Coordinate)obj;
                env.expandToInclude(coord);
            }
            return env;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

