/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\t\u001a\u00020\u0007J\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\u000b\u001a\u00020\u0007J\b\u0010\f\u001a\u00020\u0007H\u0007J\b\u0010\r\u001a\u00020\u0007H\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0005J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000fR\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/locationtech/jts/util/Memory;", "", "<init>", "()V", "used", "", "usedString", "", "free", "freeString", "total", "totalString", "usedTotalString", "allString", "KB", "", "MB", "GB", "format", "mem", "round", "d", "kts-core"})
public final class Memory {
    @NotNull
    public static final Memory INSTANCE = new Memory();
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;

    private Memory() {
    }

    public final long used() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    @NotNull
    public final String usedString() {
        return this.format(this.used());
    }

    public final long free() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory();
    }

    @NotNull
    public final String freeString() {
        return this.format(this.free());
    }

    public final long total() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory();
    }

    @NotNull
    public final String totalString() {
        return this.format(this.total());
    }

    @JvmStatic
    @NotNull
    public static final String usedTotalString() {
        return "Used: " + INSTANCE.usedString() + "   Total: " + INSTANCE.totalString();
    }

    @JvmStatic
    @NotNull
    public static final String allString() {
        return "Used: " + INSTANCE.usedString() + "   Free: " + INSTANCE.freeString() + "   Total: " + INSTANCE.totalString();
    }

    @NotNull
    public final String format(long mem) {
        if ((double)mem < 2048.0) {
            return mem + " bytes";
        }
        if ((double)mem < 2097152.0) {
            return this.round((double)mem / 1024.0) + " KB";
        }
        return (double)mem < 2.147483648E9 ? this.round((double)mem / 1048576.0) + " MB" : this.round((double)mem / 1.073741824E9) + " GB";
    }

    public final double round(double d) {
        return Math.ceil(d * (double)100) / (double)100;
    }
}

