/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.aggregation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.AbstractAggregation;
import org.molap.aggregates.cube.DistributiveStatistics;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\b\u0016\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006BU\b\u0016\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u0012\u0018\u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004\u0012\u0018\u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\nJ\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\n\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lorg/molap/aggregates/aggregation/StdDevAggregation;", "Lorg/molap/aggregates/aggregation/AbstractAggregation;", "", "column", "Lorg/molap/series/Series;", "<init>", "(Lorg/molap/series/Series;)V", "uncorrectedSumOfSquares", "sum", "count", "(Lorg/molap/series/Series;Lorg/molap/series/Series;Lorg/molap/series/Series;)V", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "compute", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "group", "Lorg/molap/aggregates/cube/Group;", "toString", "", "molap"})
public final class StdDevAggregation
extends AbstractAggregation<Object> {
    @NotNull
    private final Series<Object, Object> column;
    @Nullable
    private final Series<Object, Object> sum;
    @Nullable
    private final Series<Object, Object> count;

    public StdDevAggregation(@NotNull Series<Object, Object> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.column = column;
        this.sum = null;
        this.count = null;
    }

    public StdDevAggregation(@NotNull Series<Object, Object> uncorrectedSumOfSquares, @Nullable Series<Object, Object> sum, @Nullable Series<Object, Object> count) {
        Intrinsics.checkNotNullParameter(uncorrectedSumOfSquares, (String)"uncorrectedSumOfSquares");
        this.column = uncorrectedSumOfSquares;
        this.sum = sum;
        this.count = count;
    }

    @Override
    @NotNull
    public KClass<Object> getType() {
        return Reflection.getOrCreateKotlinClass(Double.TYPE);
    }

    @Override
    @Nullable
    public Object compute(@Nullable Cuboid cuboid, @Nullable Group group) {
        Double d;
        Cuboid cuboid2 = cuboid;
        Intrinsics.checkNotNull((Object)cuboid2);
        DistributiveStatistics d2 = cuboid2.getDistributiveStatistics(group, this.column, null);
        if (this.count != null) {
            DistributiveStatistics s;
            DistributiveStatistics p = cuboid.getDistributiveStatistics(group, this.count, null);
            Series<Object, Object> series = this.sum;
            Intrinsics.checkNotNull(series);
            DistributiveStatistics distributiveStatistics = s = cuboid.getDistributiveStatistics(group, series, null);
            Intrinsics.checkNotNull((Object)distributiveStatistics);
            Double d3 = distributiveStatistics.getSum();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = d3;
            DistributiveStatistics distributiveStatistics2 = p;
            Intrinsics.checkNotNull((Object)distributiveStatistics2);
            Double d5 = distributiveStatistics2.getSum();
            Intrinsics.checkNotNull((Object)d5);
            double mean = d4 / d5;
            DistributiveStatistics distributiveStatistics3 = d2;
            Intrinsics.checkNotNull((Object)distributiveStatistics3);
            Double d6 = distributiveStatistics3.getSum();
            Intrinsics.checkNotNull((Object)d6);
            double d7 = d6;
            Double d8 = p.getSum();
            Intrinsics.checkNotNull((Object)d8);
            double variance = d7 / d8 - mean * mean;
            d = Math.sqrt(variance);
        } else {
            DistributiveStatistics distributiveStatistics = d2;
            Intrinsics.checkNotNull((Object)distributiveStatistics);
            d = distributiveStatistics.getStandardDeviation();
        }
        return d;
    }

    @NotNull
    public String toString() {
        return "StdDev(" + this.column.getName() + ")";
    }
}

