/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cube;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.aggregation.CountAggregation;
import org.molap.aggregates.aggregation.CountDistinctAggregation;
import org.molap.aggregates.aggregation.CountDistinctWithNullAggregation;
import org.molap.aggregates.aggregation.MaxAggregation;
import org.molap.aggregates.aggregation.MeanAggregation;
import org.molap.aggregates.aggregation.MinAggregation;
import org.molap.aggregates.aggregation.StdDevAggregation;
import org.molap.aggregates.aggregation.SumAggregation;
import org.molap.aggregates.aggregation.VarianceAggregation;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.Dice;
import org.molap.aggregates.cube.Dimensions;
import org.molap.aggregates.cube.DistributiveStatistics;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.ApexCuboid;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.aggregates.cuboid.DrilledCuboid;
import org.molap.aggregates.query.CuboidQuery;
import org.molap.aggregates.query.Query;
import org.molap.aggregates.query.Structure;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001GB'\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\"\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010&\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010'\u001a\u0004\u0018\u00010\u001a2\b\u0010(\u001a\u0004\u0018\u00010\u001aH\u0016J/\u0010)\u001a\u00020*2\"\u0010+\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040-0,\"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040-\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010\u0004J\"\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u0001022\u0010\u00103\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0018\u000104J\u0010\u00105\u001a\u0002062\b\u00101\u001a\u0004\u0018\u000102J\u0010\u00107\u001a\u0002082\b\u00101\u001a\u0004\u0018\u000102J\u0010\u00109\u001a\u00020:2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u0010;\u001a\u00020<2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u0010=\u001a\u00020>2\b\u00101\u001a\u0004\u0018\u000102J\u001a\u0010=\u001a\u00020>2\b\u00101\u001a\u0004\u0018\u0001022\b\u0010?\u001a\u0004\u0018\u000102J\u0010\u0010@\u001a\u00020A2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u0010B\u001a\u00020C2\b\u00101\u001a\u0004\u0018\u000102J\u0010\u0010D\u001a\u00020E2\b\u00101\u001a\u0004\u0018\u000102J\n\u0010F\u001a\u000202H\u0096\u0080\u0004R,\u0010\u0002\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001a0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006H"}, d2={"Lorg/molap/aggregates/cube/InMemoryCube;", "Lorg/molap/aggregates/cube/Cube;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "", "<init>", "(Lorg/molap/dataframe/DataFrame;)V", "getDataFrame", "()Lorg/molap/dataframe/DataFrame;", "apex", "Lorg/molap/aggregates/cuboid/ApexCuboid;", "root", "Lorg/molap/aggregates/cube/Dimensions;", "getRoot", "()Lorg/molap/aggregates/cube/Dimensions;", "dice", "Lorg/molap/aggregates/cube/Dice;", "getDice", "()Lorg/molap/aggregates/cube/Dice;", "structure", "Lorg/molap/aggregates/query/Structure;", "getStructure", "()Lorg/molap/aggregates/query/Structure;", "cuboids", "", "Lorg/molap/aggregates/cube/InMemoryCube$DimensionsDiceStructure;", "Lorg/molap/aggregates/cuboid/Cuboid;", "child", "listener", "Lorg/molap/dataframe/DataFrameListener;", "apexCuboid", "getApexCuboid", "()Lorg/molap/aggregates/cuboid/Cuboid;", "rootGroup", "Lorg/molap/aggregates/cube/Group;", "getRootGroup", "()Lorg/molap/aggregates/cube/Group;", "getCuboid", "dimensions", "getChildCuboid", "cuboid", "query", "Lorg/molap/aggregates/query/Query;", "aggregations", "", "Lorg/molap/aggregates/aggregation/Aggregation;", "([Lorg/molap/aggregates/aggregation/Aggregation;)Lorg/molap/aggregates/query/Query;", "getSum", "Lorg/molap/aggregates/aggregation/SumAggregation;", "name", "", "filter", "Lorg/molap/aggregates/cube/DistributiveStatistics$RowFilter;", "getCount", "Lorg/molap/aggregates/aggregation/CountAggregation;", "getMin", "Lorg/molap/aggregates/aggregation/MinAggregation;", "getMax", "Lorg/molap/aggregates/aggregation/MaxAggregation;", "getMean", "Lorg/molap/aggregates/aggregation/MeanAggregation;", "getVariance", "Lorg/molap/aggregates/aggregation/VarianceAggregation;", "population", "getStdDev", "Lorg/molap/aggregates/aggregation/StdDevAggregation;", "getCountDistinct", "Lorg/molap/aggregates/aggregation/CountDistinctAggregation;", "getCountDistinctWithNull", "Lorg/molap/aggregates/aggregation/CountDistinctWithNullAggregation;", "toString", "DimensionsDiceStructure", "molap"})
public final class InMemoryCube
implements Cube {
    @NotNull
    private final DataFrame<Object, Object, Object> dataFrame;
    @NotNull
    private final ApexCuboid apex;
    @NotNull
    private final Dimensions root;
    @NotNull
    private final Dice dice;
    @NotNull
    private final Structure structure;
    @NotNull
    private final Map<DimensionsDiceStructure, Cuboid> cuboids;
    @NotNull
    private final Map<Cuboid, Cuboid> child;
    @NotNull
    private final DataFrameListener<Object, Object> listener;

    public InMemoryCube(@NotNull DataFrame<Object, Object, Object> dataFrame) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        this.cuboids = new HashMap();
        this.child = new HashMap();
        this.listener = new DataFrameListener<Object, Object>(this){
            final /* synthetic */ InMemoryCube this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<Object, Object> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                for (Cuboid cuboid : InMemoryCube.access$getCuboids$p(this.this$0).values()) {
                    cuboid.setDirty(true);
                }
            }
        };
        this.dataFrame = dataFrame;
        this.root = Dimensions.Companion.create(new Object[0]);
        this.dice = Dice.Companion.create(new Set[0]);
        this.structure = Structure.Companion.create(new boolean[0]);
        this.apex = new ApexCuboid(this, this.getRoot());
        this.cuboids.put(new DimensionsDiceStructure(this.getRoot(), this.getDice(), this.getStructure()), this.apex);
        dataFrame.addWeakDataFrameListener(this.listener);
    }

    @Override
    @NotNull
    public DataFrame<Object, Object, Object> getDataFrame() {
        return this.dataFrame;
    }

    @Override
    @NotNull
    public Dimensions getRoot() {
        return this.root;
    }

    @Override
    @NotNull
    public Dice getDice() {
        return this.dice;
    }

    @Override
    @NotNull
    public Structure getStructure() {
        return this.structure;
    }

    @Override
    @NotNull
    public Cuboid getApexCuboid() {
        return this.apex;
    }

    @Override
    @NotNull
    public Group getRootGroup() {
        return this.apex.getGroup();
    }

    @Override
    @Nullable
    public Cuboid getCuboid(@NotNull Dimensions dimensions, @NotNull Dice dice, @NotNull Structure structure) {
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)dice, (String)"dice");
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        DimensionsDiceStructure key = new DimensionsDiceStructure(dimensions, dice, structure);
        if (!this.cuboids.containsKey(key)) {
            Dimensions drillUp = dimensions.drillUp();
            Dice diceUp = dice.drillUp();
            Structure structureUp = structure.drillUp();
            Dimensions dimensions2 = drillUp;
            Intrinsics.checkNotNull((Object)dimensions2);
            Dice dice2 = diceUp;
            Intrinsics.checkNotNull((Object)dice2);
            Structure structure2 = structureUp;
            Intrinsics.checkNotNull((Object)structure2);
            Cuboid parentCuboid = this.getCuboid(dimensions2, dice2, structure2);
            Cube cube = this;
            Cuboid cuboid = parentCuboid;
            Intrinsics.checkNotNull((Object)cuboid);
            DrilledCuboid cuboid2 = new DrilledCuboid(cube, cuboid, dimensions, dice, structure);
            this.cuboids.put(key, cuboid2);
            this.child.put(parentCuboid, cuboid2);
            return cuboid2;
        }
        return this.cuboids.get(key);
    }

    @Override
    @Nullable
    public Cuboid getChildCuboid(@Nullable Cuboid cuboid) {
        return this.child.get(cuboid);
    }

    @NotNull
    public final Query query(Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        return new CuboidQuery(this.getApexCuboid(), Arrays.copyOf(aggregations, aggregations.length));
    }

    @NotNull
    public final SumAggregation getSum(@Nullable Object name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new SumAggregation(series, null, 2, null);
    }

    @NotNull
    public final SumAggregation getSum(@Nullable String name, @Nullable DistributiveStatistics.RowFilter<Object> filter) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new SumAggregation(series, filter);
    }

    @NotNull
    public final CountAggregation getCount(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new CountAggregation(series);
    }

    @NotNull
    public final MinAggregation getMin(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new MinAggregation(series);
    }

    @NotNull
    public final MaxAggregation getMax(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new MaxAggregation(series);
    }

    @NotNull
    public final MeanAggregation getMean(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new MeanAggregation(series);
    }

    @NotNull
    public final VarianceAggregation getVariance(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new VarianceAggregation(series);
    }

    @NotNull
    public final VarianceAggregation getVariance(@Nullable String name, @Nullable String population) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        Series<Object, Object> series2 = this.getDataFrame().getColumn(population);
        Intrinsics.checkNotNull(series2);
        return new VarianceAggregation(series, series2);
    }

    @NotNull
    public final StdDevAggregation getStdDev(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new StdDevAggregation(series);
    }

    @NotNull
    public final CountDistinctAggregation getCountDistinct(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new CountDistinctAggregation(series);
    }

    @NotNull
    public final CountDistinctWithNullAggregation getCountDistinctWithNull(@Nullable String name) {
        Series<Object, Object> series = this.getDataFrame().getColumn(name);
        Intrinsics.checkNotNull(series);
        return new CountDistinctWithNullAggregation(series);
    }

    @NotNull
    public String toString() {
        return "InMemoryCube{cuboids=" + this.cuboids.keySet() + "}";
    }

    public static final /* synthetic */ Map access$getCuboids$p(InMemoryCube $this) {
        return $this.cuboids;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0096\u0082\u0004J\n\u0010\r\u001a\u00020\u000eH\u0096\u0080\u0004J\n\u0010\u000f\u001a\u00020\u0010H\u0096\u0080\u0004R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/molap/aggregates/cube/InMemoryCube$DimensionsDiceStructure;", "", "dimensions", "Lorg/molap/aggregates/cube/Dimensions;", "dice", "Lorg/molap/aggregates/cube/Dice;", "structure", "Lorg/molap/aggregates/query/Structure;", "<init>", "(Lorg/molap/aggregates/cube/Dimensions;Lorg/molap/aggregates/cube/Dice;Lorg/molap/aggregates/query/Structure;)V", "equals", "", "o", "hashCode", "", "toString", "", "molap"})
    private static final class DimensionsDiceStructure {
        @Nullable
        private final Dimensions dimensions;
        @Nullable
        private final Dice dice;
        @Nullable
        private final Structure structure;

        public DimensionsDiceStructure(@Nullable Dimensions dimensions, @Nullable Dice dice, @Nullable Structure structure) {
            this.dimensions = dimensions;
            this.dice = dice;
            this.structure = structure;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DimensionsDiceStructure that = (DimensionsDiceStructure)o;
            Dice dice = this.dice;
            Intrinsics.checkNotNull((Object)dice);
            if (!dice.equals(that.dice)) {
                return false;
            }
            return !Intrinsics.areEqual((Object)this.dimensions, (Object)that.dimensions) ? false : Intrinsics.areEqual((Object)this.structure, (Object)that.structure);
        }

        public int hashCode() {
            Dimensions dimensions = this.dimensions;
            int result = dimensions != null ? ((Object)dimensions).hashCode() : 0;
            Dice dice = this.dice;
            result = 31 * result + (dice != null ? ((Object)dice).hashCode() : 0);
            Structure structure = this.structure;
            result = 31 * result + (structure != null ? ((Object)structure).hashCode() : 0);
            return result;
        }

        @NotNull
        public String toString() {
            return "DimensionsDiceStructure{dimensions=" + this.dimensions + ", dice=" + this.dice + ", structure=" + this.structure + "}";
        }
    }
}

