/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.cube;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.cube.KthSelector;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0004\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 <2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0001:\u0006789:;<B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B1\b\u0016\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\b\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0010\u0010'\u001a\u0004\u0018\u00010\u00042\u0006\u0010(\u001a\u00020\rJ\u001d\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\r\u00a2\u0006\u0002\u0010/J\u0015\u00100\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0002\u00101J\u0015\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010.\u001a\u00020\r\u00a2\u0006\u0002\u00101J\u0014\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u00010\u0000H\u0096\u0082\u0004J\n\u00105\u001a\u000206H\u0096\u0080\u0004R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0016\u001a\u0004\u0018\u00010\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0017\u0010\u0014R\u001e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u0013\u0010!\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0014R\u0013\u0010#\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0014R\u0013\u0010%\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0014R\u0013\u0010)\u001a\u0004\u0018\u00010\u00108F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001e\u00a8\u0006="}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics;", "", "column", "Lorg/molap/series/Series;", "", "<init>", "(Lorg/molap/series/Series;)V", "rows", "", "(Ljava/lang/Iterable;Lorg/molap/series/Series;)V", "statistics", "", "Lorg/molap/aggregates/cube/UnivariateStatistics$Statistics;", "", "values", "", "", "value", "sum", "getSum", "()Ljava/lang/Double;", "Ljava/lang/Double;", "uncorrectedSumOfSquares", "getUncorrectedSumOfSquares", "", "count", "getCount", "()J", "minimum", "getMinimum", "()Ljava/lang/Number;", "maximum", "getMaximum", "mean", "getMean", "variance", "getVariance", "stdDev", "getStdDev", "getSigma", "sigma", "median", "getMedian", "getPercentile", "type", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;", "p", "(Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;D)Ljava/lang/Double;", "toPercentile", "(D)Ljava/lang/Double;", "compareTo", "", "o", "toString", "", "Statistics", "EstimationType", "EstimationFunction", "AbstractEstimationFunction", "NumberComparator", "Companion", "molap"})
public final class UnivariateStatistics
implements Comparable<UnivariateStatistics> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Map<Statistics, Double> statistics;
    @NotNull
    private final List<Number> values;
    @Nullable
    private Double sum;
    @Nullable
    private Double uncorrectedSumOfSquares;
    private long count;
    @NotNull
    private static final Comparator<Number> numberComparator = new Comparator<Number>(){

        public int compare(Number o1, Number o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
    };

    @Nullable
    public final Double getSum() {
        return this.sum;
    }

    @Nullable
    public final Double getUncorrectedSumOfSquares() {
        return this.uncorrectedSumOfSquares;
    }

    public final long getCount() {
        return this.count;
    }

    public UnivariateStatistics(@NotNull Series<Object, Object> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.values = new ArrayList();
        Double sum = null;
        Double uncorrectedSumOfSquares = null;
        Iterable<Object> iterable = column.keys();
        Intrinsics.checkNotNull(iterable);
        for (Object row : iterable) {
            Number number;
            double v;
            Object value = column.get(row);
            if (value == null || !(value instanceof Number) || Double.isInfinite(v = (number = (Number)value).doubleValue()) || Double.isNaN(v)) continue;
            ((ArrayList)this.values).add(number);
            sum = sum != null ? Double.valueOf(sum + number.doubleValue()) : Double.valueOf(number.doubleValue());
            uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
            long l = this.count;
            this.count = l + 1L;
        }
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        CollectionsKt.sortWith(this.values, numberComparator);
    }

    public UnivariateStatistics(@NotNull Iterable<? extends Object> rows, @NotNull Series<Object, Object> column) {
        Intrinsics.checkNotNullParameter(rows, (String)"rows");
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.values = new ArrayList();
        Double sum = null;
        Double uncorrectedSumOfSquares = null;
        for (Object object : rows) {
            Object number;
            double v;
            Object value = column.get(object);
            if (value == null || !(value instanceof Number) || Double.isInfinite(v = ((Number)(number = value)).doubleValue()) || Double.isNaN(v)) continue;
            ((ArrayList)this.values).add(number);
            sum = sum != null ? Double.valueOf(sum + ((Number)number).doubleValue()) : Double.valueOf(((Number)number).doubleValue());
            uncorrectedSumOfSquares = uncorrectedSumOfSquares != null ? Double.valueOf(uncorrectedSumOfSquares + v * v) : Double.valueOf(v * v);
            long l = this.count;
            this.count = l + 1L;
        }
        this.sum = sum;
        this.uncorrectedSumOfSquares = uncorrectedSumOfSquares;
        CollectionsKt.sortWith(this.values, numberComparator);
    }

    @Nullable
    public final Number getMinimum() {
        return this.values.size() > 0 ? (Number)this.values.get(0) : (Number)null;
    }

    @Nullable
    public final Number getMaximum() {
        return this.values.size() > 0 ? (Number)this.values.get(this.values.size() - 1) : (Number)null;
    }

    @Nullable
    public final Double getMean() {
        Double d;
        if (this.count > 0L) {
            Double d2 = this.sum;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getVariance() {
        Double d;
        Double mean = this.getMean();
        if (mean != null) {
            Double d2 = this.uncorrectedSumOfSquares;
            Intrinsics.checkNotNull((Object)d2);
            d = d2 / (double)this.count - mean * mean;
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double getStdDev() {
        Double variance = this.getVariance();
        return variance != null ? Double.valueOf(Math.sqrt(variance)) : null;
    }

    @Nullable
    public final Object getSigma(double sigma) {
        Double stdDev;
        Double mean = this.getMean();
        return mean != null ? ((stdDev = this.getStdDev()) != null ? Double.valueOf(mean + sigma * stdDev) : null) : null;
    }

    @Nullable
    public final Number getMedian() {
        return this.getPercentile(50.0);
    }

    @Nullable
    public final Double getPercentile(@NotNull EstimationType type, double p) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        int n = this.values.size();
        if (n > 0) {
            double[] arr = new double[n];
            int n2 = ((Collection)this.values).size();
            for (int i = 0; i < n2; ++i) {
                Number number = this.values.get(i);
                arr[i] = number.doubleValue();
            }
            d = type.evaluate(arr, p, new KthSelector());
        } else {
            d = null;
        }
        return d;
    }

    @Nullable
    public final Double toPercentile(double value) {
        Double d;
        int n = this.values.size();
        if (n > 1) {
            double mid;
            Double percentileValue = this.getPercentile(0.0);
            int lowerPercentile = 0;
            for (int p = 0; p < 101; ++p) {
                Double d2 = percentileValue = this.getPercentile(p);
                Intrinsics.checkNotNull((Object)d2);
                if (!(value <= d2)) continue;
                lowerPercentile = p;
                break;
            }
            int upperPercentile = lowerPercentile;
            int p = lowerPercentile + 1;
            while (p < 101) {
                Double d3 = this.getPercentile(p);
                Intrinsics.checkNotNull((Object)d3);
                double d4 = d3;
                Double d5 = percentileValue;
                Intrinsics.checkNotNull((Object)d5);
                if (!(d4 == d5)) break;
                upperPercentile = p++;
            }
            d = (mid = (double)(lowerPercentile + upperPercentile) / 2.0) > 50.0 ? Math.ceil(mid) : Math.floor(mid);
        } else {
            d = n > 0 ? Double.valueOf(50.0) : null;
        }
        return d;
    }

    @Nullable
    public final Double getPercentile(double p) {
        return this.getPercentile(EstimationType.R_7, p);
    }

    @Override
    public int compareTo(@Nullable UnivariateStatistics o) {
        int n;
        if (o != null && this.getMean() != null) {
            Double oMean = o.getMean();
            if (oMean != null) {
                Double d = this.getMean();
                Intrinsics.checkNotNull((Object)d);
                n = Double.compare(d, oMean);
            } else {
                n = 1;
            }
        } else {
            n = 1;
        }
        return n;
    }

    @NotNull
    public String toString() {
        return "UnivariateStatistics{count=" + this.count + ", min=" + this.getMinimum() + ", median=" + this.getMedian() + ", mean=" + this.getMean() + ", max=" + this.getMaximum() + "}";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "<init>", "()V", "estimate", "", "work", "", "pivotsHeap", "", "pos", "length", "", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "molap"})
    public static abstract class AbstractEstimationFunction
    implements EstimationFunction {
        @Override
        public double estimate(@NotNull double[] work, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            double fpos = Math.floor(pos);
            int intPos = (int)fpos;
            double dif = pos - fpos;
            if (pos < 1.0) {
                return selector.select(work, pivotsHeap, 0);
            }
            if (pos >= (double)length) {
                return selector.select(work, pivotsHeap, length - 1);
            }
            double lower = selector.select(work, pivotsHeap, intPos - 1);
            double upper = selector.select(work, pivotsHeap, intPos);
            return lower + dif * (upper - lower);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$Companion;", "", "<init>", "()V", "numberComparator", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "molap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H&J2\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH&\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "", "index", "", "p", "length", "", "estimate", "work", "", "pivotsHeap", "", "pos", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "molap"})
    public static interface EstimationFunction {
        public double index(double var1, int var3);

        public double estimate(@NotNull double[] var1, @Nullable int[] var2, double var3, int var5, @NotNull KthSelector var6);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\n\"#$%&'()*+B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0004J2\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 H\u0004J*\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 H\u0004J\u001e\u0010!\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006,"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType;", "", "longName", "", "func", "Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationFunction;)V", "getLongName", "()Ljava/lang/String;", "LEGACY", "R_1", "R_2", "R_3", "R_4", "R_5", "R_6", "R_7", "R_8", "R_9", "index", "", "p", "length", "", "estimate", "work", "", "pivotsHeap", "", "pos", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "evaluate", "LegacyEstimationFunction", "R1EstimationFunction", "R2EstimationFunction", "R3EstimationFunction", "R4EstimationFunction", "R5EstimationFunction", "R6EstimationFunction", "R7EstimationFunction", "R8EstimationFunction", "R9EstimationFunction", "molap"})
    @SourceDebugExtension(value={"SMAP\nUnivariateStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnivariateStatistics.kt\norg/molap/aggregates/cube/UnivariateStatistics$EstimationType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,714:1\n1#2:715\n*E\n"})
    public static final class EstimationType
    extends Enum<EstimationType> {
        @NotNull
        private final String longName;
        @NotNull
        private final EstimationFunction func;
        public static final /* enum */ EstimationType LEGACY = new EstimationType("Legacy Apache Commons Math", new LegacyEstimationFunction());
        public static final /* enum */ EstimationType R_1 = new EstimationType("R-1", new R1EstimationFunction());
        public static final /* enum */ EstimationType R_2 = new EstimationType("R-2", new R2EstimationFunction());
        public static final /* enum */ EstimationType R_3 = new EstimationType("R-3", new R3EstimationFunction());
        public static final /* enum */ EstimationType R_4 = new EstimationType("R-4", new R4EstimationFunction());
        public static final /* enum */ EstimationType R_5 = new EstimationType("R-5", new R5EstimationFunction());
        public static final /* enum */ EstimationType R_6 = new EstimationType("R-6", new R6EstimationFunction());
        public static final /* enum */ EstimationType R_7 = new EstimationType("R-7", new R7EstimationFunction());
        public static final /* enum */ EstimationType R_8 = new EstimationType("R-8", new R8EstimationFunction());
        public static final /* enum */ EstimationType R_9 = new EstimationType("R-9", new R9EstimationFunction());
        private static final /* synthetic */ EstimationType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EstimationType(String longName, EstimationFunction func2) {
            this.longName = longName;
            this.func = func2;
        }

        @NotNull
        public final String getLongName() {
            return this.longName;
        }

        protected final double index(double p, int length) {
            return this.func.index(p, length);
        }

        protected final double estimate(@NotNull double[] work, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            return this.func.estimate(work, pivotsHeap, pos, length, selector);
        }

        protected final double evaluate(@NotNull double[] work, @Nullable int[] pivotsHeap, double p, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            if (!(!(p > 100.0) && !(p < 0.0))) {
                boolean bl = false;
                String string = "OUT_OF_BOUNDS_QUANTILE_VALUE";
                throw new IllegalArgumentException(string.toString());
            }
            return this.estimate(work, pivotsHeap, this.index(p / 100.0, work.length), work.length, selector);
        }

        public final double evaluate(@NotNull double[] work, double p, @NotNull KthSelector selector) {
            Intrinsics.checkNotNullParameter((Object)work, (String)"work");
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            return this.evaluate(work, null, p, selector);
        }

        public static EstimationType[] values() {
            return (EstimationType[])$VALUES.clone();
        }

        public static EstimationType valueOf(String value) {
            return Enum.valueOf(EstimationType.class, value);
        }

        @NotNull
        public static EnumEntries<EstimationType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = estimationTypeArray = new EstimationType[]{EstimationType.LEGACY, EstimationType.R_1, EstimationType.R_2, EstimationType.R_3, EstimationType.R_4, EstimationType.R_5, EstimationType.R_6, EstimationType.R_7, EstimationType.R_8, EstimationType.R_9};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$LegacyEstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class LegacyEstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : p * ((double)length + 1.0));
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R1EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "estimate", "values", "", "pivotsHeap", "", "pos", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "molap"})
        private static final class R1EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (double)length * p + 0.5;
            }

            @Override
            public double estimate(@NotNull double[] values, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                return super.estimate(values, pivotsHeap, Math.ceil(pos - 0.5), length, selector);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J2\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R2EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "estimate", "values", "", "pivotsHeap", "", "pos", "selector", "Lorg/molap/aggregates/cube/KthSelector;", "molap"})
        private static final class R2EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, maxLimit) == 0 ? (double)length : (Double.compare(p, minLimit) == 0 ? 0.0 : (double)length * p + 0.5);
            }

            @Override
            public double estimate(@NotNull double[] values, @Nullable int[] pivotsHeap, double pos, int length, @NotNull KthSelector selector) {
                Intrinsics.checkNotNullParameter((Object)values, (String)"values");
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                double low = super.estimate(values, pivotsHeap, Math.ceil(pos - 0.5), length, selector);
                double high = super.estimate(values, pivotsHeap, Math.floor(pos + 0.5), length, selector);
                return (low + high) / (double)2;
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R3EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R3EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.5 / (double)length;
                return Double.compare(p, minLimit) <= 0 ? 0.0 : Math.rint((double)length * p);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R4EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R4EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 1.0 / (double)length;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : (double)length * p);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R5EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R5EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.5 / (double)length;
                double maxLimit = ((double)length - 0.5) / (double)length;
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)length * p + 0.5);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R6EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R6EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 1.0 / (double)(length + 1);
                double maxLimit = 1.0 * (double)length / (double)(length + 1);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : (double)(length + 1) * p);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R7EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R7EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.0;
                double maxLimit = 1.0;
                return Double.compare(p, minLimit) == 0 ? 0.0 : (Double.compare(p, maxLimit) == 0 ? (double)length : 1.0 + (double)(length - 1) * p);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R8EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R8EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.6666666666666666 / ((double)length + 0.3333333333333333);
                double maxLimit = ((double)length - 0.3333333333333333) / ((double)length + 0.3333333333333333);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.3333333333333333) * p + 0.3333333333333333);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$EstimationType$R9EstimationFunction;", "Lorg/molap/aggregates/cube/UnivariateStatistics$AbstractEstimationFunction;", "<init>", "()V", "index", "", "p", "length", "", "molap"})
        private static final class R9EstimationFunction
        extends AbstractEstimationFunction {
            @Override
            public double index(double p, int length) {
                double minLimit = 0.625 / ((double)length + 0.25);
                double maxLimit = ((double)length - 0.375) / ((double)length + 0.25);
                return Double.compare(p, minLimit) < 0 ? 0.0 : (Double.compare(p, maxLimit) >= 0 ? (double)length : ((double)length + 0.25) * p + 0.375);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$NumberComparator;", "Ljava/util/Comparator;", "", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "o1", "o2", "molap"})
    private static final class NumberComparator
    implements Comparator<Number> {
        @Override
        public int compare(@NotNull Number o1, @NotNull Number o2) {
            Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
            Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/molap/aggregates/cube/UnivariateStatistics$Statistics;", "", "<init>", "(Ljava/lang/String;I)V", "Min", "Max", "Mean", "Median", "molap"})
    private static final class Statistics
    extends Enum<Statistics> {
        public static final /* enum */ Statistics Min = new Statistics();
        public static final /* enum */ Statistics Max = new Statistics();
        public static final /* enum */ Statistics Mean = new Statistics();
        public static final /* enum */ Statistics Median = new Statistics();
        private static final /* synthetic */ Statistics[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Statistics[] values() {
            return (Statistics[])$VALUES.clone();
        }

        public static Statistics valueOf(String value) {
            return Enum.valueOf(Statistics.class, value);
        }

        @NotNull
        public static EnumEntries<Statistics> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = statisticsArray = new Statistics[]{Statistics.Min, Statistics.Max, Statistics.Mean, Statistics.Median};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

