/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.HexExtensionsKt;
import kotlin.text.HexFormat;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.AggregateDataFrame;
import org.molap.aggregates.aggregation.Aggregation;
import org.molap.aggregates.aggregation.SumAggregation;
import org.molap.aggregates.cube.Cube;
import org.molap.aggregates.cube.InMemoryCube;
import org.molap.aggregates.query.CuboidQuery;
import org.molap.aggregates.query.QueryDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.series.AbstractSeries;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 B*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0003@ABB\t\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u0011H\u0016J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0015\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001aJ#\u0010\"\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0002\u0018\u00010#2\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010$J7\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010&2\"\u0010'\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010*0)0(\"\n\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0016\u00a2\u0006\u0002\u0010+J?\u0010%\u001a\b\u0012\u0004\u0012\u00028\u00010&2\u0006\u0010,\u001a\u00020-2\"\u0010'\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010*0)0(\"\n\u0012\u0006\u0012\u0004\u0018\u00010*0)H\u0016\u00a2\u0006\u0002\u0010.J\u0017\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00101J\u0017\u00102\u001a\u0004\u0018\u0001032\u0006\u0010\u001c\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0016J\u001c\u00108\u001a\u0002062\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0016J\u001c\u0010:\u001a\u0002062\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0016J\u001c\u0010;\u001a\u0002062\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u0016J\b\u0010<\u001a\u000206H\u0016J\u001c\u0010=\u001a\u0002062\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010?H\u0004R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u0014\u0010\u001d\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001f\u00a8\u0006C"}, d2={"Lorg/molap/dataframe/AbstractDataFrame;", "Row", "Column", "V", "Lorg/molap/dataframe/DataFrame;", "<init>", "()V", "listeners", "", "Lorg/molap/dataframe/DataFrameListener;", "cube", "Lorg/molap/aggregates/cube/Cube;", "getCube", "()Lorg/molap/aggregates/cube/Cube;", "cube$delegate", "Lkotlin/Lazy;", "rows", "", "columns", "getRowKey", "index", "", "(I)Ljava/lang/Object;", "getColumnKey", "getRowAddress", "row", "(Ljava/lang/Object;)I", "getColumnAddress", "column", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "getColumn", "Lorg/molap/series/Series;", "(Ljava/lang/Object;)Lorg/molap/series/Series;", "aggregate", "Lorg/molap/aggregates/AggregateDataFrame;", "aggregations", "", "Lorg/molap/aggregates/aggregation/Aggregation;", "", "([Lorg/molap/aggregates/aggregation/Aggregation;)Lorg/molap/aggregates/AggregateDataFrame;", "includeIndex", "", "(Z[Lorg/molap/aggregates/aggregation/Aggregation;)Lorg/molap/aggregates/AggregateDataFrame;", "getSum", "Lorg/molap/aggregates/aggregation/SumAggregation;", "(Ljava/lang/Object;)Lorg/molap/aggregates/aggregation/SumAggregation;", "getColumnName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "printSchema", "", "print", "addDataFrameListener", "listener", "addWeakDataFrameListener", "removeDataFrameListener", "removeDataFrameListeners", "notifyDataFrameChanged", "event", "Lorg/molap/dataframe/DataFrameEvent;", "WeakDataFrameListener", "ColumnSeries", "Companion", "molap"})
@SourceDebugExtension(value={"SMAP\nAbstractDataFrame.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDataFrame.kt\norg/molap/dataframe/AbstractDataFrame\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,671:1\n1#2:672\n*E\n"})
public abstract class AbstractDataFrame<Row, Column, V>
implements DataFrame<Row, Column, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DataFrameListener<Row, Column>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final Lazy cube$delegate = LazyKt.lazy(() -> AbstractDataFrame.cube_delegate$lambda$0(this));

    protected AbstractDataFrame() {
    }

    @NotNull
    protected final Cube getCube() {
        Lazy lazy = this.cube$delegate;
        return (Cube)lazy.getValue();
    }

    @Override
    @NotNull
    public Iterable<Row> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    @NotNull
    public Iterable<Column> columns() {
        return this.getColumnIndex().keys();
    }

    @Override
    public Row getRowKey(int index) {
        return (Row)this.getRowIndex().getKey(index);
    }

    @Override
    public Column getColumnKey(int index) {
        return (Column)this.getColumnIndex().getKey(index);
    }

    @Override
    public int getRowAddress(Row row) {
        return this.getRowIndex().getAddress(row);
    }

    @Override
    public int getColumnAddress(Column column) {
        return this.getColumnIndex().getAddress(column);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }

    @Override
    @Nullable
    public Series<Row, V> getColumn(Column column) {
        return new ColumnSeries(column);
    }

    @Override
    @NotNull
    public AggregateDataFrame<Column> aggregate(Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        return this.aggregate(true, Arrays.copyOf(aggregations, aggregations.length));
    }

    @Override
    @NotNull
    public AggregateDataFrame<Column> aggregate(boolean includeIndex, Aggregation<Object> ... aggregations) {
        Intrinsics.checkNotNullParameter(aggregations, (String)"aggregations");
        CuboidQuery query = new CuboidQuery(this.getCube().getApexCuboid(), Arrays.copyOf(aggregations, aggregations.length));
        return new QueryDataFrame(query, includeIndex);
    }

    @Override
    @Nullable
    public SumAggregation getSum(Column column) {
        Series<Row, V> series = this.getColumn(column);
        Intrinsics.checkNotNull(series, (String)"null cannot be cast to non-null type org.molap.series.Series<kotlin.Any?, kotlin.Any?>");
        return new SumAggregation(series, null, 2, null);
    }

    @Override
    @Nullable
    public String getColumnName(Column column) {
        Column Column2 = column;
        return Column2 != null ? Column2.toString() : null;
    }

    @Override
    public void printSchema() {
        for (Column column : this.columns()) {
            KClass<?> value;
            System.out.print((Object)Companion.abbreviate(this.getColumnName(column), 19));
            System.out.print((Object)": ");
            KClass<?> kClass = value = this.getColumnClass(column);
            System.out.print((Object)Companion.abbreviate(kClass != null ? kClass.getSimpleName() : "", 19));
            System.out.println();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void print() {
        for (Column column : this.columns()) {
            System.out.print((Object)Companion.fill(20, Companion.abbreviate(this.getColumnName(column), 19)));
        }
        System.out.println();
        Iterable<Row> iterable = this.rows();
        Intrinsics.checkNotNull(iterable);
        for (Object row : iterable) {
            Iterable<Column> iterable2 = this.columns();
            Intrinsics.checkNotNull(iterable2);
            for (Column column : iterable2) {
                Object value = this.getValueAt(row, column);
                if (value instanceof byte[]) {
                    void $this$print_u24lambda_u240;
                    HexFormat.Builder builder;
                    HexFormat.Builder builder2 = builder = new HexFormat.Builder();
                    byte[] byArray = (byte[])value;
                    boolean bl = false;
                    $this$print_u24lambda_u240.getNumber().setPrefix("0x");
                    value = HexExtensionsKt.toHexString((byte[])byArray, (HexFormat)builder.build());
                }
                if (value != null) {
                    System.out.print((Object)Companion.fill(20, Companion.abbreviate(value.toString(), 19)));
                    continue;
                }
                System.out.print((Object)Companion.fill(20, Companion.abbreviate("(null)", 19)));
            }
            System.out.println();
        }
    }

    @Override
    public void addDataFrameListener(@NotNull DataFrameListener<Row, Column> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    @Override
    public void addWeakDataFrameListener(@NotNull DataFrameListener<Row, Column> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.listeners.add(new WeakDataFrameListener(listener2));
    }

    @Override
    public void removeDataFrameListener(@NotNull DataFrameListener<Row, Column> listener2) {
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        if (listener2 instanceof WeakDataFrameListener) {
            this.listeners.remove(listener2);
        } else {
            DataFrameListener<Row, Column> toRemove = null;
            for (DataFrameListener<Row, Column> dataFrameListener2 : this.listeners) {
                DataFrameListener<Row, Column> comparable = null;
                comparable = dataFrameListener2 instanceof WeakDataFrameListener ? ((WeakDataFrameListener)dataFrameListener2).getReference() : dataFrameListener2;
                if (!Intrinsics.areEqual(listener2, comparable)) continue;
                toRemove = dataFrameListener2;
            }
            if (toRemove != null) {
                this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeDataFrameListeners() {
        this.listeners.clear();
    }

    protected final void notifyDataFrameChanged(@NotNull DataFrameEvent<Row, Column> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        for (DataFrameListener<Row, Column> listener2 : this.listeners) {
            listener2.dataFrameChanged(event);
        }
    }

    private static final InMemoryCube cube_delegate$lambda$0(AbstractDataFrame this$0) {
        Intrinsics.checkNotNull((Object)this$0, (String)"null cannot be cast to non-null type org.molap.dataframe.DataFrame<kotlin.Any?, kotlin.Any?, kotlin.Any?>");
        return new InMemoryCube(this$0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00028\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0011\u001a\u00028\u00022\u0006\u0010\u0012\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0013J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u0015\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001cH\u0016J;\u0010\u001d\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u0001H\u001f\u0012\u0006\u0012\u0004\u0018\u00018\u0002\u0018\u00010\u001e\"\u0004\b\u0003\u0010\u001f2\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u001f0 \"\u0004\u0018\u0001H\u001f\u00a2\u0006\u0002\u0010!R\u001c\u0010\u0002\u001a\u00028\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\t\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u001c\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lorg/molap/dataframe/AbstractDataFrame$ColumnSeries;", "Lorg/molap/series/AbstractSeries;", "column", "<init>", "(Lorg/molap/dataframe/AbstractDataFrame;Ljava/lang/Object;)V", "getColumn", "()Ljava/lang/Object;", "setColumn", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "name", "", "getName", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "i", "", "(I)Ljava/lang/Object;", "size", "getAddress", "(Ljava/lang/Object;)I", "keys", "", "reindex", "Lorg/molap/series/Series;", "L", "", "([Ljava/lang/Object;)Lorg/molap/series/Series;", "molap"})
    public final class ColumnSeries
    extends AbstractSeries<Row, V> {
        private Column column;

        public ColumnSeries(Column column) {
            this.column = column;
            this.column = this.column;
        }

        public final Column getColumn() {
            return this.column;
        }

        public final void setColumn(Column Column2) {
            this.column = Column2;
        }

        @Override
        @Nullable
        public Object getName() {
            return this.column;
        }

        @Override
        @NotNull
        public KClass<? extends Object> getType() {
            return AbstractDataFrame.this.getColumnClass(this.column);
        }

        @Override
        public V get(Row key) {
            return AbstractDataFrame.this.getValueAt(key, this.column);
        }

        @Override
        public Row getKey(int i) {
            return AbstractDataFrame.this.getRowIndex().getKey(i);
        }

        @Override
        public int size() {
            return AbstractDataFrame.this.getRowIndex().getSize();
        }

        @Override
        public int getAddress(Row key) {
            return AbstractDataFrame.this.getRowAddress(key);
        }

        @Override
        @NotNull
        public Iterable<Row> keys() {
            return AbstractDataFrame.this.getRowIndex().keys();
        }

        @Nullable
        public final <L> Series<L, V> reindex(L ... keys2) {
            Intrinsics.checkNotNullParameter(keys2, (String)"keys");
            return null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\b2\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000b"}, d2={"Lorg/molap/dataframe/AbstractDataFrame$Companion;", "", "<init>", "()V", "abbreviate", "", "str", "maxWidth", "", "fill", "width", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String abbreviate(@Nullable String str, int maxWidth) {
            Object object;
            if (str == null) {
                return null;
            }
            if (str.length() <= maxWidth) {
                object = str;
            } else {
                String string = str.substring(0, maxWidth - 3);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = string + "...";
            }
            return object;
        }

        @Nullable
        public final String fill(int width, @Nullable String str) {
            Object object;
            if (str == null) {
                return null;
            }
            if (str.length() < width) {
                int n = 0;
                int n2 = width - str.length();
                char[] cArray = new char[n2];
                String string = str;
                while (n < n2) {
                    int n3 = n++;
                    cArray[n3] = 32;
                }
                object = string + StringsKt.concatToString((char[])cArray);
            } else {
                String string = str.substring(0, width);
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0016R \u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/molap/dataframe/AbstractDataFrame$WeakDataFrameListener;", "Lorg/molap/dataframe/DataFrameListener;", "listener", "<init>", "(Lorg/molap/dataframe/AbstractDataFrame;Lorg/molap/dataframe/DataFrameListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "dataFrameChanged", "", "event", "Lorg/molap/dataframe/DataFrameEvent;", "reference", "getReference", "()Lorg/molap/dataframe/DataFrameListener;", "molap"})
    private final class WeakDataFrameListener
    implements DataFrameListener<Row, Column> {
        @NotNull
        private final WeakReference<DataFrameListener<Row, Column>> l_ref;

        public WeakDataFrameListener(DataFrameListener<Row, Column> listener2) {
            Intrinsics.checkNotNullParameter(listener2, (String)"listener");
            this.l_ref = new WeakReference(listener2);
        }

        @Override
        public void dataFrameChanged(@NotNull DataFrameEvent<Row, Column> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            DataFrameListener l = this.getReference();
            if (l != null) {
                l.dataFrameChanged(event);
            } else {
                AbstractDataFrame.this.removeDataFrameListener(this);
            }
        }

        @Nullable
        public final DataFrameListener<Row, Column> getReference() {
            return (DataFrameListener)this.l_ref.get();
        }
    }
}

