/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.UniqueIndex;
import org.molap.series.AbstractSeries;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u00011B#\b\u0016\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tB?\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000b\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\rJ\u001d\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001d\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0002\b\u0003\u0018\u00010\u00072\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014J!\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00072\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001d\u0010\u001c\u001a\u00028\u00022\u0006\u0010\u0015\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\u001fH\u0016J\u0015\u0010!\u001a\u00028\u00002\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010%\u001a\u00028\u00012\u0006\u0010\"\u001a\u00020#H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010&\u001a\u00020#2\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0015\u0010(\u001a\u00020#2\u0006\u0010\u0018\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010'J=\u0010.\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010/2\u0010\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00072\u0010\u0010 \u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0006\u00a2\u0006\u0002\u00100R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\"\u0010\u0005\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010)\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010+\u00a8\u00062"}, d2={"Lorg/molap/dataframe/IndexedDataFrame;", "R", "C", "V", "Lorg/molap/dataframe/AbstractDataFrame;", "series", "", "Lorg/molap/series/Series;", "<init>", "([Lorg/molap/series/Series;)V", "rowIndex", "Lorg/molap/index/UniqueIndex;", "columnIndex", "(Lorg/molap/index/UniqueIndex;Lorg/molap/index/UniqueIndex;[Lorg/molap/series/Series;)V", "getColumnIndex", "()Lorg/molap/index/UniqueIndex;", "getRowIndex", "[Lorg/molap/series/Series;", "getRowClass", "Lkotlin/reflect/KClass;", "", "row", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getColumnClass", "column", "getRow", "getColumn", "(Ljava/lang/Object;)Lorg/molap/series/Series;", "getValueAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "rows", "", "columns", "getRowKey", "index", "", "(I)Ljava/lang/Object;", "getColumnKey", "getRowAddress", "(Ljava/lang/Object;)I", "getColumnAddress", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "join", "Lorg/molap/dataframe/DataFrame;", "(Lorg/molap/series/Series;[Ljava/lang/Object;)Lorg/molap/dataframe/DataFrame;", "ColumnSeries", "molap"})
public final class IndexedDataFrame<R, C, V>
extends AbstractDataFrame<R, C, V> {
    @NotNull
    private final UniqueIndex<C> columnIndex;
    @NotNull
    private final UniqueIndex<R> rowIndex;
    @NotNull
    private final Series<R, V>[] series;

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        return this.rowIndex;
    }

    public IndexedDataFrame(@NotNull Series<R, V>[] series) {
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this.series = Arrays.copyOf(series, series.length);
        Set rows = new LinkedHashSet();
        int n = series.length;
        for (int i = 0; i < n; ++i) {
            Series<R, V> s = series[i];
            Iterable<R> iterable = s.keys();
            Intrinsics.checkNotNull(iterable);
            for (R r : iterable) {
                rows.add(r);
            }
        }
        Object[] columns = new Object[series.length];
        int n2 = series.length;
        for (int i = 0; i < n2; ++i) {
            Series<R, V> s = series[i];
            columns[i] = s.getName() != null ? s.getName() : Integer.valueOf(i);
        }
        n2 = 0;
        Series<R, V> series2 = this.series[0];
        Intrinsics.checkNotNull(series2);
        int n3 = series2.size();
        Object[] objectArray = new Object[n3];
        while (n2 < n3) {
            int n4 = n2++;
            Series<R, V> series3 = this.series[0];
            Intrinsics.checkNotNull(series3);
            Intrinsics.checkNotNull(series3.getKey(n4));
        }
        Object[] array = objectArray;
        DefaultUniqueIndex<Object> defaultUniqueIndex = DefaultUniqueIndex.Companion.fromArray(array);
        Intrinsics.checkNotNull(defaultUniqueIndex, (String)"null cannot be cast to non-null type org.molap.index.UniqueIndex<R of org.molap.dataframe.IndexedDataFrame>");
        this.rowIndex = defaultUniqueIndex;
        DefaultUniqueIndex<Object> defaultUniqueIndex2 = DefaultUniqueIndex.Companion.fromArray(columns);
        Intrinsics.checkNotNull(defaultUniqueIndex2, (String)"null cannot be cast to non-null type org.molap.index.UniqueIndex<C of org.molap.dataframe.IndexedDataFrame>");
        this.columnIndex = defaultUniqueIndex2;
    }

    public IndexedDataFrame(@NotNull UniqueIndex<R> rowIndex, @NotNull UniqueIndex<C> columnIndex, @NotNull Series<R, V>[] series) {
        Intrinsics.checkNotNullParameter(rowIndex, (String)"rowIndex");
        Intrinsics.checkNotNullParameter(columnIndex, (String)"columnIndex");
        Intrinsics.checkNotNullParameter(series, (String)"series");
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.series = series;
    }

    @Override
    @Nullable
    public KClass<Object> getRowClass(R row) {
        return null;
    }

    @Override
    @NotNull
    public KClass<? extends Object> getColumnClass(C column) {
        int address = this.getColumnIndex().getAddress(column);
        return this.series[address].getType();
    }

    @Nullable
    public final Series<Object, ?> getRow(@Nullable Object row) {
        return null;
    }

    @Override
    @NotNull
    public Series<R, V> getColumn(C column) {
        return new ColumnSeries(column, this.getRowIndex());
    }

    @Override
    public V getValueAt(R row, C column) {
        int address = this.getColumnIndex().getAddress(column);
        return this.series[address].get(row);
    }

    @Override
    @NotNull
    public Iterable<R> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    @NotNull
    public Iterable<C> columns() {
        return this.getColumnIndex().keys();
    }

    @Override
    public R getRowKey(int index) {
        return (R)this.getRowIndex().getKey(index);
    }

    @Override
    public C getColumnKey(int index) {
        return (C)this.getColumnIndex().getKey(index);
    }

    @Override
    public int getRowAddress(R row) {
        return this.getRowIndex().getAddress(row);
    }

    @Override
    public int getColumnAddress(C column) {
        return this.getColumnIndex().getAddress(column);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }

    @Nullable
    public final DataFrame<?, ?, ?> join(@Nullable Series<?, ?> series, @Nullable Object[] columns) {
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0000\b\u0086\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00028\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0010\u001a\u00028\u00022\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\u0015\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001bH\u0016R\u0016\u0010\u0007\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lorg/molap/dataframe/IndexedDataFrame$ColumnSeries;", "Lorg/molap/series/AbstractSeries;", "column", "index", "Lorg/molap/index/UniqueIndex;", "<init>", "(Lorg/molap/dataframe/IndexedDataFrame;Ljava/lang/Object;Lorg/molap/index/UniqueIndex;)V", "name", "getName", "()Ljava/lang/Object;", "Ljava/lang/Object;", "type", "Lkotlin/reflect/KClass;", "", "getType", "()Lkotlin/reflect/KClass;", "get", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "getKey", "i", "", "(I)Ljava/lang/Object;", "size", "getAddress", "(Ljava/lang/Object;)I", "keys", "", "molap"})
    public final class ColumnSeries
    extends AbstractSeries<R, V> {
        private final C name;
        @NotNull
        private final UniqueIndex<R> index;

        public ColumnSeries(@NotNull C column, UniqueIndex<R> index) {
            Intrinsics.checkNotNullParameter(index, (String)"index");
            this.name = column;
            this.index = index;
        }

        @Override
        public C getName() {
            return this.name;
        }

        @Override
        @NotNull
        public KClass<? extends Object> getType() {
            return IndexedDataFrame.this.getColumnClass(this.getName());
        }

        @Override
        public V get(R key) {
            int address = this.index.getAddress(key);
            return IndexedDataFrame.this.getValueAt(IndexedDataFrame.this.getRowIndex().getKey(address), this.getName());
        }

        @Override
        public R getKey(int i) {
            return IndexedDataFrame.this.getRowKey(i);
        }

        @Override
        public int size() {
            return this.index.getSize();
        }

        @Override
        public int getAddress(R key) {
            return IndexedDataFrame.this.getRowAddress(key);
        }

        @Override
        @Nullable
        public Iterable<R> keys() {
            return this.index.keys();
        }
    }
}

