/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.DataFrameListener;
import org.molap.dataframe.MutableDataFrame;
import org.molap.dataframe.ReIndexRecipe;
import org.molap.index.UniqueIndex;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u0004*\u0004\b\u0004\u0010\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0007B5\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00020\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bH\u0004J\b\u0010!\u001a\u00020 H\u0004J\u001b\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010#2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u0019\u0010&\u001a\u0006\u0012\u0002\b\u00030#2\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010%J\u001d\u0010(\u001a\u00028\u00022\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010)J%\u0010*\u001a\u00020 2\u0006\u0010$\u001a\u00028\u00002\u0006\u0010'\u001a\u00028\u00012\u0006\u0010+\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010,J\u001f\u0010-\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0002\b\u0003\u0018\u00010.2\u0006\u0010$\u001a\u00028\u0000\u00a2\u0006\u0002\u0010/J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00028\u000001H\u0016J\u000e\u00102\u001a\b\u0012\u0004\u0012\u00028\u000101H\u0016J\u0015\u00103\u001a\u00028\u00002\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u00106J\u0015\u00107\u001a\u00028\u00012\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u00106J\u0015\u00108\u001a\u0002052\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00109J\u0015\u0010:\u001a\u0002052\u0006\u0010'\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u00109R&\u0010\b\u001a\u0014\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u0004\u0012\u0004\u0012\u00028\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0013R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00028\u00040\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010;\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0014\u0010>\u001a\u0002058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010=\u00a8\u0006@"}, d2={"Lorg/molap/dataframe/ReIndexedDataFrame;", "R", "C", "V", "X", "Y", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "Lorg/molap/dataframe/MutableDataFrame;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "recipe", "Lorg/molap/dataframe/ReIndexRecipe;", "<init>", "(Lorg/molap/dataframe/DataFrame;Lorg/molap/dataframe/ReIndexRecipe;)V", "getDataFrame", "()Lorg/molap/dataframe/DataFrame;", "cacheColumnIndex", "Lorg/molap/index/UniqueIndex;", "getCacheColumnIndex", "()Lorg/molap/index/UniqueIndex;", "setCacheColumnIndex", "(Lorg/molap/index/UniqueIndex;)V", "cacheRowIndex", "getCacheRowIndex", "setCacheRowIndex", "columnIndex", "getColumnIndex", "rowIndex", "getRowIndex", "dataFrameListener", "Lorg/molap/dataframe/DataFrameListener;", "setRecipe", "", "dataFrameChanged", "getRowClass", "Lkotlin/reflect/KClass;", "row", "(Ljava/lang/Object;)Lkotlin/reflect/KClass;", "getColumnClass", "column", "getValueAt", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "setValueAt", "value", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getRow", "Lorg/molap/series/Series;", "(Ljava/lang/Object;)Lorg/molap/series/Series;", "rows", "", "columns", "getRowKey", "index", "", "(I)Ljava/lang/Object;", "getColumnKey", "getRowAddress", "(Ljava/lang/Object;)I", "getColumnAddress", "rowCount", "getRowCount", "()I", "columnCount", "getColumnCount", "molap"})
public final class ReIndexedDataFrame<R, C, V, X, Y>
extends AbstractMutableDataFrame<R, C, V>
implements MutableDataFrame<R, C, V> {
    @NotNull
    private final DataFrame<X, Y, V> dataFrame;
    @NotNull
    private ReIndexRecipe<R, C> recipe;
    @Nullable
    private UniqueIndex<C> cacheColumnIndex;
    @Nullable
    private UniqueIndex<R> cacheRowIndex;
    @NotNull
    private final DataFrameListener<X, Y> dataFrameListener;

    public ReIndexedDataFrame(@NotNull DataFrame<X, Y, V> dataFrame, @NotNull ReIndexRecipe<R, C> recipe2) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter(recipe2, (String)"recipe");
        this.dataFrame = dataFrame;
        this.recipe = recipe2;
        this.dataFrameListener = new DataFrameListener<X, Y>(this){
            final /* synthetic */ ReIndexedDataFrame<R, C, V, X, Y> this$0;
            {
                this.this$0 = $receiver;
            }

            public void dataFrameChanged(DataFrameEvent<X, Y> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.this$0.dataFrameChanged();
            }
        };
        this.dataFrame.addWeakDataFrameListener(this.dataFrameListener);
    }

    @NotNull
    protected final DataFrame<X, Y, V> getDataFrame() {
        return this.dataFrame;
    }

    @Nullable
    public final UniqueIndex<C> getCacheColumnIndex() {
        return this.cacheColumnIndex;
    }

    public final void setCacheColumnIndex(@Nullable UniqueIndex<C> uniqueIndex) {
        this.cacheColumnIndex = uniqueIndex;
    }

    @Nullable
    public final UniqueIndex<R> getCacheRowIndex() {
        return this.cacheRowIndex;
    }

    public final void setCacheRowIndex(@Nullable UniqueIndex<R> uniqueIndex) {
        this.cacheRowIndex = uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<C> getColumnIndex() {
        UniqueIndex<C> uniqueIndex;
        if (this.cacheColumnIndex == null) {
            UniqueIndex<C> uniqueIndex2 = this.cacheColumnIndex = this.recipe.buildColumnIndex();
            uniqueIndex = uniqueIndex2;
            Intrinsics.checkNotNull(uniqueIndex2);
        } else {
            UniqueIndex<C> uniqueIndex3 = this.cacheColumnIndex;
            uniqueIndex = uniqueIndex3;
            Intrinsics.checkNotNull(uniqueIndex3);
        }
        return uniqueIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<R> getRowIndex() {
        UniqueIndex<R> uniqueIndex;
        if (this.cacheRowIndex == null) {
            UniqueIndex<R> uniqueIndex2 = this.cacheRowIndex = this.recipe.buildRowIndex();
            uniqueIndex = uniqueIndex2;
            Intrinsics.checkNotNull(uniqueIndex2);
        } else {
            UniqueIndex<R> uniqueIndex3 = this.cacheRowIndex;
            uniqueIndex = uniqueIndex3;
            Intrinsics.checkNotNull(uniqueIndex3);
        }
        return uniqueIndex;
    }

    protected final void setRecipe(@NotNull ReIndexRecipe<R, C> recipe2) {
        Intrinsics.checkNotNullParameter(recipe2, (String)"recipe");
        if (this.recipe != recipe2) {
            this.recipe = recipe2;
            this.cacheRowIndex = null;
            this.cacheColumnIndex = null;
            this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.emptyList(), CollectionsKt.emptyList(), true));
        }
    }

    protected final void dataFrameChanged() {
        this.cacheRowIndex = null;
        this.cacheColumnIndex = null;
        this.notifyDataFrameChanged(new DataFrameEvent(CollectionsKt.emptyList(), CollectionsKt.emptyList(), false));
    }

    @Override
    @Nullable
    public KClass<?> getRowClass(R row) {
        return this.dataFrame.getRowClass(this.dataFrame.getRowKey(this.getRowIndex().getAddress(row)));
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(C column) {
        return this.dataFrame.getColumnClass(this.dataFrame.getColumnKey(this.getColumnIndex().getAddress(column)));
    }

    @Override
    public V getValueAt(R row, C column) {
        int r = this.getRowIndex().getAddress(row);
        int c = this.getColumnIndex().getAddress(column);
        X rowKey = this.dataFrame.getRowKey(r);
        Y columnKey = this.dataFrame.getColumnKey(c);
        return this.dataFrame.getValueAt(rowKey, columnKey);
    }

    @Override
    public void setValueAt(R row, C column, V value) {
        if (this.dataFrame instanceof MutableDataFrame) {
            int r = this.getRowIndex().getAddress(row);
            int c = this.getColumnIndex().getAddress(column);
            if (r >= 0 && c >= 0) {
                ((MutableDataFrame)this.dataFrame).setValueAt(((MutableDataFrame)this.dataFrame).getRowKey(r), ((MutableDataFrame)this.dataFrame).getColumnKey(c), value);
            }
        }
    }

    @Nullable
    public final Series<C, ?> getRow(R row) {
        return null;
    }

    @Override
    @NotNull
    public Iterable<R> rows() {
        return this.getRowIndex().keys();
    }

    @Override
    @NotNull
    public Iterable<C> columns() {
        return this.getColumnIndex().keys();
    }

    @Override
    public R getRowKey(int index) {
        return (R)this.getRowIndex().getKey(index);
    }

    @Override
    public C getColumnKey(int index) {
        return (C)this.getColumnIndex().getKey(index);
    }

    @Override
    public int getRowAddress(R row) {
        return this.getRowIndex().getAddress(row);
    }

    @Override
    public int getColumnAddress(C column) {
        return this.getColumnIndex().getAddress(column);
    }

    @Override
    public int getRowCount() {
        return this.getRowIndex().getSize();
    }

    @Override
    public int getColumnCount() {
        return this.getColumnIndex().getSize();
    }
}

