/*
 * Decompiled with CFR 0.152.
 */
package org.molap.subset;

import com.macrofocus.common.collection.ArrayFnKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\r\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005J\u001a\u0010\u000e\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u000f"}, d2={"Lorg/molap/subset/SortedArraySetOperations;", "", "<init>", "()V", "diffSortedTIntArrays", "", "size", "", "indices", "diffSortedTIntList", "a", "b", "unionSortedTIntList", "unionSortedArrays", "intersectSortedArrays", "molap"})
public final class SortedArraySetOperations {
    @NotNull
    public static final SortedArraySetOperations INSTANCE = new SortedArraySetOperations();

    private SortedArraySetOperations() {
    }

    @NotNull
    public final int[] diffSortedTIntArrays(int size, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        int[] result = new int[size - indices.length];
        int r = 0;
        int j = 0;
        for (int i = 0; i < size; ++i) {
            if (j < indices.length && indices[j] <= i) {
                ++j;
                continue;
            }
            result[r++] = i;
        }
        return result;
    }

    @NotNull
    public final int[] diffSortedTIntList(int size, @NotNull int[] indices) {
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        List result = new ArrayList(size - indices.length);
        int j = 0;
        for (int i = 0; i < size; ++i) {
            if (j < indices.length && indices[j] <= i) {
                ++j;
                continue;
            }
            result.add(i);
        }
        return CollectionsKt.toIntArray((Collection)result);
    }

    @Nullable
    public final int[] diffSortedTIntList(@Nullable int[] a, @Nullable int[] b) {
        int[] nArray;
        if (a != null) {
            if (b != null) {
                List result = new ArrayList(Math.max(a.length, b.length));
                int i = 0;
                int j = 0;
                while (i < a.length && j < b.length) {
                    if (a[i] < b[j]) {
                        result.add(a[i]);
                        ++i;
                        continue;
                    }
                    if (a[i] > b[j]) {
                        ++j;
                        continue;
                    }
                    ++i;
                    ++j;
                }
                while (i < a.length) {
                    result.add(a[i]);
                    ++i;
                }
                nArray = CollectionsKt.toIntArray((Collection)result);
            } else {
                nArray = a;
            }
        } else {
            nArray = null;
        }
        return nArray;
    }

    @NotNull
    public final int[] unionSortedTIntList(@NotNull int[] a, @NotNull int[] b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        List answer = new ArrayList(Math.max(a.length, b.length));
        int i = 0;
        int j = 0;
        int tmp = 0;
        while (i < a.length && j < b.length) {
            int n = tmp = a[i] < b[j] ? a[i++] : b[j++];
            while (i < a.length && a[i] == tmp) {
                ++i;
            }
            while (j < b.length && b[j] == tmp) {
                ++j;
            }
            answer.add(tmp);
        }
        while (i < a.length) {
            tmp = a[i++];
            while (i < a.length && a[i] == tmp) {
                ++i;
            }
            answer.add(tmp);
        }
        while (j < b.length) {
            tmp = b[j++];
            while (j < b.length && b[j] == tmp) {
                ++j;
            }
            answer.add(tmp);
        }
        return CollectionsKt.toIntArray((Collection)answer);
    }

    @NotNull
    public final int[] unionSortedArrays(@Nullable int[] a, @Nullable int[] b) {
        Intrinsics.checkNotNull((Object)a);
        int n = a.length;
        Intrinsics.checkNotNull((Object)b);
        int[] answer = new int[n + b.length];
        int i = 0;
        int j = 0;
        int k = 0;
        int tmp = 0;
        while (i < a.length && j < b.length) {
            int n2 = tmp = a[i] < b[j] ? a[i++] : b[j++];
            while (i < a.length && a[i] == tmp) {
                ++i;
            }
            while (j < b.length && b[j] == tmp) {
                ++j;
            }
            answer[k++] = tmp;
        }
        while (i < a.length) {
            tmp = a[i++];
            while (i < a.length && a[i] == tmp) {
                ++i;
            }
            answer[k++] = tmp;
        }
        while (j < b.length) {
            tmp = b[j++];
            while (j < b.length && b[j] == tmp) {
                ++j;
            }
            answer[k++] = tmp;
        }
        return ArrayFnKt.copyOf((int[])answer, (int)k);
    }

    @NotNull
    public final int[] intersectSortedArrays(@Nullable int[] a, @Nullable int[] b) {
        Intrinsics.checkNotNull((Object)a);
        int n = a.length;
        Intrinsics.checkNotNull((Object)b);
        int[] c = new int[Math.min(n, b.length)];
        int ai = 0;
        int bi = 0;
        int ci = 0;
        while (ai < a.length && bi < b.length) {
            if (a[ai] < b[bi]) {
                ++ai;
                continue;
            }
            if (a[ai] > b[bi]) {
                ++bi;
                continue;
            }
            if (ci == 0 || a[ai] != c[ci - 1]) {
                c[ci++] = a[ai];
            }
            ++ai;
            ++bi;
        }
        return ArrayFnKt.copyOfRange((int[])c, (int)0, (int)ci);
    }
}

