/*
 * Decompiled with CFR 0.152.
 */
import com.treemap.AbstractTreeMapNode;
import com.treemap.DefaultTreeMap;
import com.treemap.Rendering;
import com.treemap.RenderingFactory;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapSettings;
import java.util.Arrays;
import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.SplitPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.stage.Stage;
import org.jetbrains.annotations.NotNull;
import org.mkui.colormap.MutableColorMap;
import org.mkui.font.crossplatform.CPFont;
import org.mkui.javafx.HorizontalHierarchicalComboBox;
import org.mkui.javafx.Orientation;
import org.mkui.javafx.SingleSelectionSingleSelectionModel;
import org.mkui.javafx.VerticalHierarchicalComboBox;
import org.mkui.palette.FixedPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.JsonDataFrame;

public class Demo
extends Application {
    public void start(Stage primaryStage) throws Exception {
        String json = new String(Demo.class.getResourceAsStream("Forbes Global 2000 - 2021.json").readAllBytes(), "UTF-8");
        JsonDataFrame dataFrame = new JsonDataFrame(json);
        DefaultTreeMap treeMap = new DefaultTreeMap((DataFrame)dataFrame);
        TreeMapModel model = treeMap.getModel();
        TreeMapSettings settings = model.getSettings();
        settings.setRendering(RenderingFactory.getFLAT());
        settings.setGroupByColumns(Arrays.asList("Sector", "Industry"));
        settings.setSizeColumn((Object)"Market Value");
        settings.setColorColumn((Object)"Profits");
        TreeMapColumnSettings profitsSettings = settings.getColumnSettings((Object)"Profits");
        FixedPalette negpos = PaletteFactory.Companion.getInstance().get("negpos").getPalette();
        MutableColorMap colorMap = model.getColorMap((Object)"Profits");
        colorMap.setPalette((MutablePalette)negpos);
        colorMap.getInterval().setValue(-63.93, 127.86);
        treeMap.getView().setShowTiming(true);
        TreeMapColumnSettings companySettings = settings.getColumnSettings((Object)"Company");
        companySettings.setLabelingFont(new CPFont(new Font("Helvetica", 9.0), FontWeight.NORMAL, FontPosture.REGULAR).getNativeFont());
        companySettings.setLabelingMinimumCharactersToDisplay(Integer.valueOf(5));
        companySettings.setLabelingResizeTextToFitShape(true);
        companySettings.setLabelingVerticalAlignment(0);
        companySettings.setLabelingHorizontalAlignment(0);
        Pane configuration = Demo.createConfiguration((TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings);
        SplitPane splitPane = new SplitPane(new Node[]{configuration, treeMap.getComponent().getNativeComponent()});
        SplitPane.setResizableWithParent((Node)configuration, (Boolean)false);
        splitPane.setDividerPositions(new double[]{0.25});
        BorderPane mainPanel = new BorderPane();
        mainPanel.topProperty().setValue((Object)Demo.createGroupBy(Orientation.Horizontal, (TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String>)model, (TreeMapSettings<String>)settings));
        mainPanel.centerProperty().setValue((Object)splitPane);
        StackPane root = new StackPane();
        root.getChildren().add((Object)mainPanel);
        primaryStage.setTitle("TreeMap");
        primaryStage.setScene(new Scene((Parent)root, 1024.0, 768.0));
        primaryStage.show();
    }

    @NotNull
    private static Pane createConfiguration(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        GridPane configuration = new GridPane();
        configuration.setHgap(5.0);
        configuration.setVgap(5.0);
        configuration.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        int row = 0;
        configuration.add((Node)new Label("Group by:"), 0, row);
        configuration.add(Demo.createGroupBy(Orientation.Vertical, model, settings), 1, row);
        configuration.add((Node)new Label("Size:"), 0, ++row);
        configuration.add(Demo.createSizeComboBox(model, settings), 1, row);
        configuration.add((Node)new Label("Color:"), 0, ++row);
        configuration.add(Demo.createColorComboBox(model, settings), 1, row);
        configuration.add((Node)new Label("Rendering:"), 0, ++row);
        configuration.add(Demo.createRenderingComboBox(settings), 1, row);
        return configuration;
    }

    @NotNull
    private static Node createGroupBy(Orientation orientation, TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        if (orientation == Orientation.Vertical) {
            return new VerticalHierarchicalComboBox(settings.getGroupByColumnsSelection(), model.getGroupByColumns());
        }
        return new HorizontalHierarchicalComboBox(settings.getGroupByColumnsSelection(), model.getGroupByColumns());
    }

    private static Node createSizeComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        SingleSelectionSingleSelectionModel selectionModel = new SingleSelectionSingleSelectionModel(settings.getSizeColumnSelection(), model.getSizeColumns());
        ComboBox comboBox = new ComboBox(selectionModel.getList());
        comboBox.getSelectionModel().select((Object)((String)settings.getSizeColumnSelection().getSelected()));
        comboBox.setSelectionModel((SingleSelectionModel)selectionModel);
        return comboBox;
    }

    private static Node createColorComboBox(TreeMapModel<AbstractTreeMapNode<Integer, String>, Integer, String> model, TreeMapSettings<String> settings) {
        SingleSelectionSingleSelectionModel selectionModel = new SingleSelectionSingleSelectionModel(settings.getColorColumnSelection(), model.getColorColumns());
        ComboBox comboBox = new ComboBox(selectionModel.getList());
        comboBox.getSelectionModel().select((Object)((String)settings.getColorColumnSelection().getSelected()));
        comboBox.setSelectionModel((SingleSelectionModel)selectionModel);
        return comboBox;
    }

    private static Node createRenderingComboBox(TreeMapSettings<String> settings) {
        ComboBox comboBox = new ComboBox();
        SingleSelectionSingleSelectionModel selectionModel = new SingleSelectionSingleSelectionModel(settings.getRenderingSelection(), (Iterable)RenderingFactory.getInstance().getRenderings());
        comboBox.setItems(selectionModel.getList());
        comboBox.getSelectionModel().select((Object)((Rendering)settings.getRenderingSelection().getSelected()));
        comboBox.setSelectionModel((SingleSelectionModel)selectionModel);
        return comboBox;
    }

    public static void main(String[] args) {
        Demo.launch(Demo.class, (String[])args);
    }
}

