/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.TreeMapModel;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.graphics.CPImage;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001BM\b\u0016\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fBY\b\u0016\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0000\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\u000eJT\u0010\u0011\u001a\u00020\u00122\u0014\u0010\u0002\u001a\u0010\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00032\u000e\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019JR\u0010\u001a\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00032\u000e\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/treemap/Cushion;", "", "model", "Lcom/treemap/TreeMapModel;", "left", "", "right", "width", "top", "bottom", "height", "<init>", "(Lcom/treemap/TreeMapModel;IIIIII)V", "master", "(Lcom/treemap/Cushion;Lcom/treemap/TreeMapModel;IIIIII)V", "_surface", "", "fillRaster", "", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "x", "y", "raster", "Lorg/mkui/graphics/CPImage;", "computeColor", "treemap"})
@StabilityInferred(parameters=0)
public final class Cushion {
    @NotNull
    private final double[] _surface;
    public static final int $stable = 8;

    public Cushion(@NotNull TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        this._surface = new double[4];
        double h4 = (double)4 * model.getSettings().getLightSourceHeight();
        double wf = 0.0;
        wf = width <= 0 ? 0.0 : h4 / (double)width;
        this._surface[2] = wf * (double)(right + left);
        this._surface[0] = -wf;
        double hf = 0.0;
        hf = height <= 0 ? 0.0 : h4 / (double)height;
        this._surface[3] = hf * (double)(bottom + top);
        this._surface[1] = -hf;
    }

    public Cushion(@Nullable Cushion master, @Nullable TreeMapModel<?, ?, ?> model, int left, int right, int width, int top, int bottom, int height) {
        this._surface = new double[4];
        if (master != null) {
            double d = 4;
            TreeMapModel<?, ?, ?> treeMapModel = model;
            Intrinsics.checkNotNull(treeMapModel);
            double h4 = d * treeMapModel.getSettings().getLightSourceHeight();
            double wf = 0.0;
            wf = width <= 0 ? 0.0 : h4 / (double)width;
            this._surface[2] = master._surface[2] + wf * (double)(right + left);
            this._surface[0] = master._surface[0] - wf;
            double hf = 0.0;
            hf = height <= 0 ? 0.0 : h4 / (double)height;
            this._surface[3] = master._surface[3] + hf * (double)(bottom + top);
            this._surface[1] = master._surface[1] - hf;
        }
    }

    public final void fillRaster(@Nullable TreeMapModel<?, ?, ?> model, @Nullable Color color, int x, int y, int width, int height, @NotNull CPImage raster) {
        Intrinsics.checkNotNullParameter((Object)raster, (String)"raster");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            double colR = UnsignedKt.uintToDouble((int)(MkColorKt.getURed((Color)color) & 0xFF));
            double colG = UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen((Color)color) & 0xFF));
            double colB = UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue((Color)color) & 0xFF));
            TreeMapModel<?, ?, ?> treeMapModel = model;
            Intrinsics.checkNotNull(treeMapModel);
            double ia = treeMapModel.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            if (!raster.isOneSamplePerArrayElement()) {
                int base = 0;
                int[] data = new int[width * height];
                for (int iy = y; iy < bottom; ++iy) {
                    double ny = -(s1 * ((double)iy + 0.5) + s3);
                    for (int ix = x; ix < right; ++ix) {
                        double nx = -(s0 * ((double)ix + 0.5) + s2);
                        double cosa = Math.min(1.0, (nx * lx + ny * ly + lz) / Math.sqrt(nx * nx + ny * ny + 1.0));
                        double pixel = Math.min(1.0, Math.max(0.0, is * cosa + ia));
                        int red = (int)(colR * pixel);
                        int green = (int)(colG * pixel);
                        int blue = (int)(colB * pixel);
                        int alpha = MkColorKt.getUAlpha((Color)color) & 0xFF;
                        data[base] = (alpha << 24) + (red << 16) + (green << 8) + blue;
                        ++base;
                    }
                }
                raster.setPixels(0, 0, width, height, data);
            } else {
                int base = 0;
                int[] data = new int[width * height << 2];
                for (int iy = y; iy < bottom; ++iy) {
                    double ny = -(s1 * ((double)iy + 0.5) + s3);
                    for (int ix = x; ix < right; ++ix) {
                        double nx = -(s0 * ((double)ix + 0.5) + s2);
                        double cosa = Math.min(1.0, (nx * lx + ny * ly + lz) / Math.sqrt(nx * nx + ny * ny + 1.0));
                        double pixel = Math.min(1.0, Math.max(0.0, is * cosa + ia));
                        int red = (int)(colR * pixel);
                        int green = (int)(colG * pixel);
                        int blue = (int)(colB * pixel);
                        int alpha = MkColorKt.getUAlpha((Color)color) & 0xFF;
                        data[base++] = red;
                        data[base++] = green;
                        data[base++] = blue;
                        data[base++] = alpha;
                    }
                }
                raster.setPixels(0, 0, width, height, data);
            }
        }
    }

    @Nullable
    public final Color computeColor(@NotNull TreeMapModel<?, ?, ?> model, @Nullable Color color, int x, int y, int width, int height) {
        Color color2;
        Intrinsics.checkNotNullParameter(model, (String)"model");
        if (color != null) {
            int bottom = y + height;
            int right = x + width;
            double colR = UnsignedKt.uintToDouble((int)(MkColorKt.getURed((Color)color) & 0xFF));
            double colG = UnsignedKt.uintToDouble((int)(MkColorKt.getUGreen((Color)color) & 0xFF));
            double colB = UnsignedKt.uintToDouble((int)(MkColorKt.getUBlue((Color)color) & 0xFF));
            double ia = model.getSettings().getLightSourceAmbient();
            double is = 1.0 - model.getSettings().getLightSourceAmbient();
            double lx = model.getNormalizedLightSourceX();
            double ly = model.getNormalizedLightSourceY();
            double lz = model.getNormalizedLightSourceZ();
            double s0 = (double)2 * this._surface[0];
            double s1 = (double)2 * this._surface[1];
            double s2 = this._surface[2];
            double s3 = this._surface[3];
            int iy = (y + bottom) / 2;
            int ix = (x + right) / 2;
            double nx = -(s0 * ((double)ix + 0.5) + s2);
            double ny = -(s1 * ((double)iy + 0.5) + s3);
            double cosa = Math.min(1.0, (nx * lx + ny * ly + lz) / Math.sqrt(nx * nx + ny * ny + 1.0));
            double pixel = Math.min(1.0, Math.max(0.0, is * cosa + ia));
            int red = (int)(colR * pixel);
            int green = (int)(colG * pixel);
            int blue = (int)(colB * pixel);
            color2 = MkColorKt.colorOf((int)red, (int)green, (int)blue);
        } else {
            color2 = null;
        }
        return color2;
    }
}

