/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.license.LicenseModel;
import com.treemap.AbstractTreeMapView;
import com.treemap.LabelingFactory;
import com.treemap.Progressive;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapRenderer;
import com.treemap.TreeMapToolTip;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.TGraphics;
import com.treemap.crossplatform.TGraphicsDrawing;
import com.treemap.crossplatform.TreeMapCanvas;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.CPCanvas;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontFactory;
import org.mkui.font.MkFontKt;
import org.mkui.font.Weight;
import org.mkui.geom.Point;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.CPImage;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u0002*\u0004\b\u0002\u0010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u0004:\u0001LB\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u0019H\u0014J\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010'\u001a\u00020\u0019H\u0016J\u0017\u0010,\u001a\u0004\u0018\u00010)2\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010.J\u0017\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010-\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u00020\u0019H\u0016J\u0010\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\u0019H\u0002J\b\u0010C\u001a\u00020\u0019H\u0002J\u0010\u0010D\u001a\u00020\u00192\u0006\u0010@\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00192\u0006\u0010@\u001a\u00020GH\u0016J\u0010\u0010H\u001a\u00020\u00192\u0006\u0010@\u001a\u00020IH\u0016J\u0010\u0010J\u001a\u00020\u00192\u0006\u0010@\u001a\u00020KH\u0016R-\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010RL\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00132\u001a\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0018\u00010\u00138V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R$\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020!8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0016\u0010(\u001a\u0004\u0018\u00010)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u001c\u00103\u001a\n\u0018\u000104j\u0004\u0018\u0001`58VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u00107R$\u0010:\u001a\u0002092\u0006\u00108\u001a\u0002098V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006M"}, d2={"Lcom/treemap/DefaultTreeMapView;", "N", "Row", "Column", "Lcom/treemap/AbstractTreeMapView;", "<init>", "()V", "component", "Lcom/treemap/crossplatform/TreeMapCanvas;", "getComponent", "()Lcom/treemap/crossplatform/TreeMapCanvas;", "component$delegate", "Lkotlin/Lazy;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "timer$delegate", "model", "Lcom/treemap/TreeMapModel;", "getModel", "()Lcom/treemap/TreeMapModel;", "setModel", "(Lcom/treemap/TreeMapModel;)V", "repaint", "", "delay", "", "updateSize", "setLicenseModel", "licenseModel", "Lcom/macrofocus/license/LicenseModel;", "value", "Lcom/treemap/Progressive;", "progressive", "getProgressive", "()Lcom/treemap/Progressive;", "setProgressive", "(Lcom/treemap/Progressive;)V", "updateModelDimension", "image", "Lorg/mkui/graphics/CPImage;", "getImage", "()Lorg/mkui/graphics/CPImage;", "getToolTipImage", "node", "(Ljava/lang/Object;)Lorg/mkui/graphics/CPImage;", "getToolTipPreferredLocation", "Lorg/mkui/geom/Point;", "(Ljava/lang/Object;)Lorg/mkui/geom/Point;", "waitUntilReady", "background", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "getBackground", "()Ljavafx/scene/paint/Color;", "dimension", "Lcom/macrofocus/common/geom/Dimension;", "size", "getSize", "()Lcom/macrofocus/common/geom/Dimension;", "setSize", "(Lcom/macrofocus/common/geom/Dimension;)V", "addMouseListener", "l", "Lorg/mkui/canvas/MouseListener;", "startDragging", "stopDragging", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "addKeyListener", "Lorg/mkui/canvas/KeyListener;", "addContextMenuListener", "Lorg/mkui/canvas/ContextMenuListener;", "NativeComponent", "treemap"})
@StabilityInferred(parameters=0)
public final class DefaultTreeMapView<N, Row, Column>
extends AbstractTreeMapView<N, Row, Column> {
    @NotNull
    private final Lazy component$delegate = LazyKt.lazy(() -> DefaultTreeMapView.component_delegate$lambda$0(this));
    @NotNull
    private final Lazy timer$delegate = LazyKt.lazy(() -> DefaultTreeMapView.timer_delegate$lambda$0(this));
    public static final int $stable = 8;

    public DefaultTreeMapView() {
        super(new Headless());
        this.getComponent().addCanvasListener(new CanvasListener(){

            public void sizeChange(int width, int height) {
                this.updateModelDimension();
                this.updateSize();
            }
        });
        this.getComponent().addLayer(new TGraphicsDrawing(){

            @Override
            public <N, Row, Column> void draw(TreeMapView<N, Row, Column> view, TGraphics tg, double width, double height) {
                Intrinsics.checkNotNullParameter(view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)tg, (String)"tg");
                int width2 = (int)width;
                int height2 = (int)height;
                if (width2 > 0 && height2 > 0) {
                    Dimension tooltipDimension;
                    Point tooltipPosition;
                    long current = CPHelper.Companion.getInstance().getCurrentTimeMillis();
                    for (TreeMapRenderer<N, Row, Column> treeMapRenderer : view.getPreRenderers()) {
                        treeMapRenderer.paint(tg, view, null);
                    }
                    boolean paintingForPrint = false;
                    for (TreeMapRenderer<N, Row, Column> renderer : view.getProgressiveRenderers()) {
                        renderer.paint(tg, view, null);
                    }
                    for (TreeMapRenderer<N, Row, Column> renderer : view.getPostRenderers()) {
                        renderer.paint(tg, view, null);
                    }
                    2 $this$draw_u24lambda_u240 = this;
                    boolean bl = false;
                    TreeMapToolTip<N, Row, Column> toolTip = view.getToolTip();
                    if (toolTip != null && toolTip.getType() == TreeMapToolTip.ToolTipType.Painted) {
                        tooltipPosition = toolTip.getPopupLocation();
                        tooltipDimension = toolTip.getPreferredSize(tg);
                        if (tooltipPosition != null && tooltipDimension != null) {
                            toolTip.setSize(tooltipDimension);
                            tg.save();
                            tg.translate(tooltipPosition.getX(), tooltipPosition.getY());
                            tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                            toolTip.paintBackground(tg);
                            toolTip.paintText(tg);
                            tg.restore();
                        }
                    }
                    Object $this$draw_u24lambda_u241 = this;
                    boolean bl2 = false;
                    toolTip = view.getSelectionToolTip();
                    if (toolTip != null && toolTip.getType() == TreeMapToolTip.ToolTipType.Painted) {
                        tooltipPosition = toolTip.getPreferredLocation();
                        tooltipDimension = toolTip.getPreferredSize(tg);
                        if (tooltipPosition != null && tooltipDimension != null) {
                            toolTip.setSize(tooltipDimension);
                            tg.save();
                            tg.translate(tooltipPosition.getX(), tooltipPosition.getY());
                            tg.clip((Shape)new Rectangle2D.Double(0.0, 0.0, tooltipDimension.getWidth(), tooltipDimension.getHeight()));
                            toolTip.paintBackground(tg);
                            toolTip.paintText(tg);
                            tg.restore();
                        }
                    }
                    if (view.getRubberBand().getRubberBand().isActive()) {
                        tg.save();
                        tg.setStroke(MkColorFactory.Companion.getInstance().getBlack());
                        $this$draw_u24lambda_u241 = new double[4];
                        $this$draw_u24lambda_u241[0] = 10.0;
                        $this$draw_u24lambda_u241[1] = 2.0;
                        $this$draw_u24lambda_u241[2] = 2.0;
                        $this$draw_u24lambda_u241[3] = 2.0;
                        Object object = $this$draw_u24lambda_u241;
                        tg.setLineWidth(1.0);
                        tg.setLineDash((double[])object);
                        Rectangle2D rectangle2D = view.getRubberBand().getRubberBandScreen();
                        Intrinsics.checkNotNull((Object)rectangle2D);
                        Rectangle2D r = rectangle2D;
                        tg.stroke((Shape)new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
                        tg.restore();
                    }
                    if (view.isShowTiming()) {
                        tg.save();
                        long l = CPHelper.Companion.getInstance().getCurrentTimeMillis() - current;
                        tg.setColor(MkColorKt.colorOf-8NGXxBw((byte)-1, (byte)0, (byte)0));
                        tg.setFont(MkFontKt.deriveFontWeight((Font)CPFontFactory.Companion.getInstance().createDefaultFont(), (Weight)Weight.BOLD));
                        tg.fillText(l + " ms", 5.0f, (float)height2 - 5.0f);
                        tg.restore();
                    }
                }
            }
        });
        this.updateModelDimension();
        this.updateSize();
    }

    @NotNull
    public TreeMapCanvas<N, Row, Column> getComponent() {
        Lazy lazy = this.component$delegate;
        return (TreeMapCanvas)((Object)lazy.getValue());
    }

    @NotNull
    protected final CPTimer getTimer() {
        Lazy lazy = this.timer$delegate;
        return (CPTimer)lazy.getValue();
    }

    @Override
    @Nullable
    public TreeMapModel<N, Row, Column> getModel() {
        return super.getModel();
    }

    @Override
    public void setModel(@Nullable TreeMapModel<N, Row, Column> model) {
        LabelingFactory.Companion.getSURROUND().setHeadless(new Headless());
        LabelingFactory.Companion.getCOLORED_SURROUND().setHeadless(new Headless());
        super.setModel(model);
    }

    @Override
    protected void repaint(long delay) {
        this.getTimer().restart();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void updateSize() {
        if (this.getModel() == null) ** GOTO lbl-1000
        v0 = this.getModel();
        Intrinsics.checkNotNull(v0);
        if (v0.getSettings().getDimension() != null) {
            v1 = this.getModel();
            Intrinsics.checkNotNull(v1);
            v2 = v1.getSettings().getDimension();
            v3 = v2;
            Intrinsics.checkNotNull((Object)v2);
        } else lbl-1000:
        // 2 sources

        {
            v3 = new Dimension(0, 0);
        }
        m = v3;
        width = 0.0;
        height = 0.0;
        w = 0;
        h = 0;
        v = new Dimension((int)this.getComponent().getWidth(), (int)this.getComponent().getHeight());
        width = Math.max(0.0, Math.max(m.getWidth(), v.getWidth()));
        height = Math.max(0.0, Math.max(m.getHeight(), v.getHeight()));
        w = Math.max(0, v.getIwidth());
        h = Math.max(0, v.getIheight());
        this.getXRangeModel().setMinMax(0.0, width);
        this.getYRangeModel().setMinMax(0.0, height);
        this.getXRangeModel().setMaximumExtent((double)w);
        this.getYRangeModel().setMaximumExtent((double)h);
        this.getXRangeModel().setValue(0.0, this.getXRangeModel().getMaximumExtent());
        this.getYRangeModel().setValue(height - this.getYRangeModel().getMaximumExtent(), this.getYRangeModel().getMaximumExtent());
        this.getScreenTransform().setScreenSize(w, h);
    }

    @Override
    public void setLicenseModel(@Nullable LicenseModel licenseModel) {
    }

    @Override
    @NotNull
    public Progressive getProgressive() {
        return super.getProgressive();
    }

    @Override
    public void setProgressive(@NotNull Progressive value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
    }

    @Override
    public void updateModelDimension() {
        if (this.getModel() != null && this.isUpdateModelDimension()) {
            TreeMapModel<N, Row, Column> treeMapModel = this.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            Boolean bl = treeMapModel.getSettings().getDimensionFixed();
            Intrinsics.checkNotNull((Object)bl);
            if (!bl.booleanValue()) {
                Dimension dimension = new Dimension((int)this.getComponent().getWidth(), (int)this.getComponent().getHeight());
                TreeMapModel<N, Row, Column> treeMapModel2 = this.getModel();
                Intrinsics.checkNotNull(treeMapModel2);
                treeMapModel2.getSettings().setDimension(dimension);
            }
        }
    }

    @Override
    @Nullable
    public CPImage getImage() {
        return null;
    }

    @Override
    @Nullable
    public CPImage getToolTipImage(N node) {
        return null;
    }

    @Override
    @Nullable
    public Point getToolTipPreferredLocation(N node) {
        TreeMapToolTip treeMapToolTip = this.getToolTip();
        Intrinsics.checkNotNull(treeMapToolTip);
        TreeMapToolTip toolTip = treeMapToolTip;
        Object oldNode = toolTip.getNode();
        toolTip.setNode(node);
        Point p = toolTip.getPreferredLocation();
        toolTip.setNode(oldNode);
        return p;
    }

    @Override
    public void waitUntilReady() {
    }

    @Override
    @Nullable
    public Color getBackground() {
        return null;
    }

    @Override
    @NotNull
    public Dimension getSize() {
        return new Dimension((int)this.getComponent().getWidth(), (int)this.getComponent().getHeight());
    }

    @Override
    public void setSize(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getComponent().addMouseListener(l);
    }

    private final void startDragging() {
    }

    private final void stopDragging() {
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getComponent().addMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getComponent().addMouseWheelListener(l);
    }

    @Override
    public void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getComponent().addKeyListener(l);
    }

    @Override
    public void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.getComponent().addContextMenuListener(l);
    }

    private static final TreeMapCanvas component_delegate$lambda$0(DefaultTreeMapView this$0) {
        return new TreeMapCanvas(this$0);
    }

    private static final CPTimer timer_delegate$lambda$0(DefaultTreeMapView this$0) {
        return CPHelper.Companion.getInstance().createTimer("TreeMapViewUpdater", 40, false, new CPTimerListener(this$0){
            final /* synthetic */ DefaultTreeMapView<N, Row, Column> this$0;
            {
                this.this$0 = $receiver;
            }

            public void timerTriggered() {
                this.this$0.getComponent().redraw();
            }
        });
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u000bR#\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lcom/treemap/DefaultTreeMapView$NativeComponent;", "", "view", "Lcom/treemap/DefaultTreeMapView;", "<init>", "(Lcom/treemap/DefaultTreeMapView;Lcom/treemap/DefaultTreeMapView;)V", "getView", "()Lcom/treemap/DefaultTreeMapView;", "canvas", "Lorg/mkui/canvas/CPCanvas;", "draw", "", "width", "", "getWidth", "()D", "height", "getHeight", "redraw", "treemap"})
    public final class NativeComponent {
        @NotNull
        private final DefaultTreeMapView<N, Row, Column> view;
        @NotNull
        private final CPCanvas canvas;

        public NativeComponent(DefaultTreeMapView<N, Row, Column> view) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            this.view = view;
            this.canvas = new CPCanvas();
        }

        @NotNull
        public final DefaultTreeMapView<N, Row, Column> getView() {
            return this.view;
        }

        private final void draw() {
        }

        public final double getWidth() {
            return this.canvas.getWidth();
        }

        public final double getHeight() {
            return this.canvas.getHeight();
        }

        public final void redraw() {
            this.draw();
        }
    }
}

