/*
 * Decompiled with CFR 0.152.
 */
package com.treemap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import com.treemap.AbstractLabeling;
import com.treemap.DefaultTreeMapHeaderRenderer;
import com.treemap.TreeMapColumnSettings;
import com.treemap.TreeMapHeaderRenderer;
import com.treemap.TreeMapModel;
import com.treemap.TreeMapView;
import com.treemap.crossplatform.Headless;
import com.treemap.crossplatform.TGraphics;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.MkFontKt;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.Insets;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\r\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0012H\u0016J6\u0010\u0013\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u0012H\u0016JO\u0010\u0014\u001a\u0004\u0018\u00010\u0015\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u0010\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0018J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002JU\u0010\u001d\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0017\u001a\u0002H\u000eH\u0004\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002JI\u0010#\u001a\u00020\u000b\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$Ja\u0010%\u001a\u00020&\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0017\u001a\u0002H\u000e2\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0016\u00a2\u0006\u0002\u0010.JI\u0010/\u001a\n\u0018\u000100j\u0004\u0018\u0001`1\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0006\u0010\u0017\u001a\u0002H\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0012H\u0014\u00a2\u0006\u0002\u00102JI\u00103\u001a\n\u0018\u000100j\u0004\u0018\u0001`1\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0006\u0010\u0017\u001a\u0002H\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0012H\u0014\u00a2\u0006\u0002\u00102JI\u00104\u001a\n\u0018\u000100j\u0004\u0018\u0001`1\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f\"\u0004\b\u0002\u0010\u00102\u0006\u0010\u0017\u001a\u0002H\u000e2\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u0002H\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00100\u0012H\u0014\u00a2\u0006\u0002\u00102J\n\u00105\u001a\u000206H\u0096\u0080\u0004R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/treemap/SurroundLabeling;", "Lcom/treemap/AbstractLabeling;", "<init>", "()V", "headless", "Lcom/treemap/crossplatform/Headless;", "getHeadless", "()Lcom/treemap/crossplatform/Headless;", "setHeadless", "(Lcom/treemap/crossplatform/Headless;)V", "_minThickness", "", "_maxThickness", "getTopSpace", "N", "Row", "Column", "model", "Lcom/treemap/TreeMapModel;", "getLeftSpace", "subtract", "Lorg/mkui/geom/Shape;", "shape", "node", "(Lcom/treemap/TreeMapModel;Lorg/mkui/geom/Shape;Ljava/lang/Object;)Lorg/mkui/geom/Shape;", "computeAllocatedHeight", "preferredHeight", "rectangle", "Lorg/mkui/geom/Rectangle2D;", "computePreferredHeight", "g2", "Lcom/treemap/crossplatform/TGraphics;", "(Lcom/treemap/TreeMapModel;Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;)D", "computeMagnificationFactor", "height", "computeThickness", "(Lcom/treemap/TreeMapModel;Lorg/mkui/geom/Rectangle2D;Ljava/lang/Object;)D", "paintParent", "", "bounds", "Lorg/mkui/geom/Rectangle;", "view", "Lcom/treemap/TreeMapView;", "pass", "", "passes", "(Lcom/treemap/crossplatform/TGraphics;Lorg/mkui/geom/Rectangle;Ljava/lang/Object;Lcom/treemap/TreeMapView;II)V", "getBackgroundColor", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "(Ljava/lang/Object;Lcom/treemap/TreeMapModel;)Ljavafx/scene/paint/Color;", "getForegroundColor", "getEffectColor", "toString", "", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public class SurroundLabeling
extends AbstractLabeling {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Headless headless;
    private final double _minThickness;
    private final double _maxThickness;
    public static final int $stable = 8;
    protected static final float MINIMUM_FONT_SIZE_TO_DISPLAY = 5.0f;

    @Nullable
    public final Headless getHeadless() {
        return this.headless;
    }

    public final void setHeadless(@Nullable Headless headless) {
        this.headless = headless;
    }

    @Override
    public <N, Row, Column> double getTopSpace(@Nullable TreeMapModel<N, Row, Column> model) {
        Font font;
        TreeMapModel<N, Row, Column> treeMapModel = model;
        Intrinsics.checkNotNull(treeMapModel);
        Font font2 = font = treeMapModel.getSettings().getDefaultColumnSettings().getHeaderFont();
        return ((Number)(font2 != null ? (Number)(MkFontKt.getFontSize((Font)font2) + (double)2) : (Number)0)).doubleValue();
    }

    @Override
    public <N, Row, Column> double getLeftSpace(@Nullable TreeMapModel<N, Row, Column> model) {
        return 3.0;
    }

    @Override
    @Nullable
    public <N, Row, Column> Shape subtract(@Nullable TreeMapModel<N, Row, Column> model, @Nullable Shape shape, N node) {
        Shape shape2;
        TreeMapModel<N, Row, Column> treeMapModel = model;
        Intrinsics.checkNotNull(treeMapModel);
        if (!treeMapModel.isRoot(node) && model.getShape(node) instanceof Rectangle2D) {
            Intrinsics.checkNotNull((Object)shape, (String)"null cannot be cast to non-null type org.mkui.geom.Rectangle2D");
            Rectangle2D rectangle = (Rectangle2D)shape;
            double preferredHeight = this.computePreferredHeight(model, null, rectangle, node);
            double allocatedHeight = this.computeAllocatedHeight(preferredHeight, rectangle);
            double thickness = this.computeThickness(model, rectangle, node);
            double width = rectangle.getWidth() - (double)2 * thickness;
            double height = rectangle.getHeight() - (thickness + allocatedHeight);
            shape2 = (Shape)(width > 0.0 && height > 0.0 ? (Rectangle2D)new Rectangle2D.Double(rectangle.getX() + thickness, rectangle.getY() + allocatedHeight, width, height) : rectangle);
        } else {
            shape2 = shape;
        }
        return shape2;
    }

    private final double computeAllocatedHeight(double preferredHeight, Rectangle2D rectangle) {
        return Math.min(rectangle.getHeight() / (double)5, preferredHeight);
    }

    protected final <N, Row, Column> double computePreferredHeight(@NotNull TreeMapModel<N, Row, Column> model, @Nullable TGraphics g2, @Nullable Rectangle2D rectangle, N node) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        double height = 0.0;
        TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(model.getGroupByColumn(node));
        Font headerFont = columnSettings.getHeaderFont();
        if (headerFont != null && model.getLabelName(node) != null) {
            try {
                if (rectangle != null && rectangle.getHeight() > 3.0) {
                    DefaultTreeMapHeaderRenderer headerRenderer = new DefaultTreeMapHeaderRenderer();
                    headerRenderer.setFont(headerFont);
                    EnhancedLabel elabel = headerRenderer.getTreeMapHeaderRendererComponent(model, node, new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight()));
                    Headless headless = this.headless;
                    Intrinsics.checkNotNull((Object)headless);
                    PreferredSize pf = headless.sizeLabel(elabel, g2, (int)rectangle.getWidth(), (int)rectangle.getHeight());
                    return pf.getPreferredHeight();
                }
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                height = 0.0;
            }
        } else {
            height = 0.0;
        }
        return height;
    }

    private final double computeMagnificationFactor(double height, double preferredHeight) {
        return height / preferredHeight;
    }

    private final <N, Row, Column> double computeThickness(TreeMapModel<N, Row, Column> model, Rectangle2D rectangle, N node) {
        double thickness = rectangle.getWidth() * rectangle.getHeight() * 5.0E-4;
        return Math.max(this._minThickness, Math.min(this._maxThickness, thickness));
    }

    @Override
    public <N, Row, Column> void paintParent(@NotNull TGraphics g2, @NotNull Rectangle bounds, N node, @NotNull TreeMapView<N, Row, Column> view, int pass, int passes) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(view, (String)"view");
        if (pass == 0) {
            TreeMapModel<N, Row, Column> treeMapModel = view.getModel();
            Intrinsics.checkNotNull(treeMapModel);
            TreeMapModel<N, Row, Column> model = treeMapModel;
            Column column = model.getGroupByColumn(node);
            TreeMapColumnSettings columnSettings = model.getSettings().getColumnSettings(column);
            Font headerFont = columnSettings.getHeaderFont();
            if (headerFont != null && model.getLabelName(node) != null) {
                Shape shape = model.getShape(node);
                Intrinsics.checkNotNull((Object)shape);
                Shape shape2 = shape;
                Rectangle2D rectangle = shape2.getBounds2D();
                Point2D position = null;
                position = shape2 instanceof Arc2D ? AbstractLabeling.Companion.getCentroid(shape2) : null;
                double preferedHeight = this.computePreferredHeight(model, g2, rectangle, node);
                double height = this.computeAllocatedHeight(preferedHeight, rectangle);
                if (rectangle != null || position != null && height > 0.0) {
                    Rectangle2D screenRectangle = view.worldToScreenPrecise(rectangle);
                    double fontSize = MkFontKt.getFontSize((Font)headerFont) * (double)view.getZoomFactor();
                    Rectangle2D rect = null;
                    EnhancedLabel elabel = null;
                    if (fontSize >= 5.0) {
                        Color foreground = this.getForegroundColor(node, model);
                        TreeMapHeaderRenderer<N, Row, Column> treeMapHeaderRenderer = view.getHeaderRenderer();
                        Intrinsics.checkNotNull(treeMapHeaderRenderer);
                        elabel = treeMapHeaderRenderer.getTreeMapHeaderRendererComponent(model, node, new Dimension(bounds.getIwidth(), bounds.getIheight()));
                        PreferredSize pf = g2.sizeLabel(elabel, bounds.getIwidth(), bounds.getIheight());
                        Insets insets = columnSettings.getHeaderInsets();
                        Intrinsics.checkNotNull((Object)insets);
                        Insets insets2 = insets;
                        elabel.setInsets((int)((float)insets2.getTop() * view.getZoomFactor()), (int)((float)insets2.getLeft() * view.getZoomFactor()), (int)((float)insets2.getBottom() * view.getZoomFactor()), (int)((float)insets2.getRight() * view.getZoomFactor()));
                        Color background = this.getEffectColor(node, model);
                        Font derivedFont = null;
                        derivedFont = !(fontSize == MkFontKt.getFontSize((Font)headerFont)) ? MkFontKt.deriveFontSize((Font)headerFont, (double)fontSize) : headerFont;
                        elabel.setFont(derivedFont);
                        Color color = foreground;
                        Intrinsics.checkNotNull((Object)color);
                        elabel.setForeground(color);
                        Color color2 = background;
                        Intrinsics.checkNotNull((Object)color2);
                        elabel.setBackground(color2);
                        Dimension size = pf.getPreferredSize();
                        if (position != null) {
                            double w = Math.min(size.getWidth(), screenRectangle.getWidth());
                            if (shape2 instanceof Arc2D) {
                                Arc2D arc = (Arc2D)shape2;
                                Point2D startPoint = arc.getStartPoint();
                                Point2D endPoint = arc.getEndPoint();
                                Point2D s = (Point2D)new Point2D.Double((double)view.worldToScreenX(startPoint.getX()), (double)view.worldToScreenY(startPoint.getY()));
                                Point2D e = (Point2D)new Point2D.Double((double)view.worldToScreenX(endPoint.getX()), (double)view.worldToScreenY(endPoint.getY()));
                                w = Math.min(s.distance(e), w);
                            }
                            double h = Math.min(size.getHeight(), screenRectangle.getHeight());
                            double x = (double)view.worldToScreenX(position.getX()) - w / (double)2;
                            double y = (double)view.worldToScreenY(position.getY()) - h / (double)2;
                            rect = new Rectangle2D.Double(x, y, w, h).createIntersection((Rectangle2D)bounds);
                        } else {
                            Shape nestedShapeWorld;
                            Shape shape3 = nestedShapeWorld = model.getNestedShape(node);
                            Intrinsics.checkNotNull((Object)shape3);
                            Rectangle2D nestedShapeWorldBounds = shape3.getBounds2D();
                            double preferredHeight = this.computePreferredHeight(model, null, rectangle, node);
                            double allocatedHeight = this.computeAllocatedHeight(preferredHeight, rectangle);
                            double thickness = this.computeThickness(model, rectangle, node);
                            rect = view.worldToScreenPrecise((Rectangle2D)new Rectangle2D.Double(nestedShapeWorldBounds.getX() + thickness, rectangle.getY(), nestedShapeWorldBounds.getWidth() - (double)2 * thickness, allocatedHeight));
                        }
                    } else {
                        Shape nestedShapeWorld;
                        elabel = null;
                        Shape shape4 = nestedShapeWorld = model.getNestedShape(node);
                        Intrinsics.checkNotNull((Object)shape4);
                        Rectangle2D nestedShapeWorldBounds = shape4.getBounds2D();
                        double preferredHeight = this.computePreferredHeight(model, null, rectangle, node);
                        double allocatedHeight = this.computeAllocatedHeight(preferredHeight, rectangle);
                        double thickness = this.computeThickness(model, rectangle, node);
                        rect = view.worldToScreenPrecise((Rectangle2D)new Rectangle2D.Double(nestedShapeWorldBounds.getX() + thickness, rectangle.getY(), nestedShapeWorldBounds.getWidth() - (double)2 * thickness, allocatedHeight));
                    }
                    if (shape2 instanceof Rectangle2D) {
                        Color backgroundColor = this.getBackgroundColor(node, model);
                        g2.setFill(backgroundColor);
                        g2.fillRect(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
                    }
                    if (elabel != null && rect.getWidth() > 8.0) {
                        Font font;
                        double d;
                        Rectangle2D b = rect.getBounds2D();
                        elabel.setDesiredWidth((int)(b.getWidth() - (double)elabel.getInsetLeft() - (double)elabel.getInsetRight()));
                        elabel.setDesiredHeight((int)(b.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom()));
                        Font font2 = elabel.getFont();
                        Intrinsics.checkNotNull((Object)font2);
                        Font font3 = font2;
                        PreferredSize pf = g2.sizeLabel(elabel, (int)b.getWidth(), (int)b.getHeight());
                        boolean shrink = true;
                        boolean expand = false;
                        if (columnSettings.getHeaderRendering() != EnhancedLabel.Rendering.WordWrap) {
                            Dimension preferredSize = pf.getPreferredSize();
                            double scaleY = (b.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom()) / (preferredSize.getHeight() - (double)elabel.getInsetTop() - (double)elabel.getInsetBottom());
                            d = MkFontKt.getFontSize((Font)headerFont) * (double)view.getZoomFactor() * scaleY * 1.0;
                        } else {
                            d = g2.fitTextInsideRectangle(elabel, pf, font3, b, 0.99, expand);
                        }
                        fontSize = d;
                        fontSize = Math.min(MkFontKt.getFontSize((Font)font3), fontSize);
                        Font derivedFont = null;
                        Font font4 = elabel.getFont();
                        Intrinsics.checkNotNull((Object)font4);
                        if (!(fontSize == MkFontKt.getFontSize((Font)font4))) {
                            Font font5 = elabel.getFont();
                            Intrinsics.checkNotNull((Object)font5);
                            font = MkFontKt.deriveFontSize((Font)font5, (double)fontSize);
                        } else {
                            Font font6 = elabel.getFont();
                            font = font6;
                            Intrinsics.checkNotNull((Object)font6);
                        }
                        derivedFont = font;
                        elabel.setFont(derivedFont);
                        g2.paintLabel(elabel, (int)b.getX(), (int)b.getY(), (int)b.getWidth(), (int)b.getHeight());
                    }
                }
            }
        }
    }

    @Nullable
    protected <N, Row, Column> Color getBackgroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderBackground();
    }

    @Nullable
    protected <N, Row, Column> Color getForegroundColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderForeground();
    }

    @Nullable
    protected <N, Row, Column> Color getEffectColor(N node, @NotNull TreeMapModel<N, Row, Column> model) {
        Intrinsics.checkNotNullParameter(model, (String)"model");
        return model.getSettings().getColumnSettings(model.getGroupByColumn(node)).getHeaderEffectColor();
    }

    @NotNull
    public String toString() {
        return "Surround";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0084T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/treemap/SurroundLabeling$Companion;", "", "<init>", "()V", "MINIMUM_FONT_SIZE_TO_DISPLAY", "", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

