/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.treemap.AbstractAlgorithm;
import com.treemap.DefaultTreeMapColumnSettings;
import com.treemap.TreeMapAccessor;
import com.treemap.TreeMapWorker;
import com.treemap.tagcloud.ArchimedeanSpiral;
import com.treemap.tagcloud.DefaultWord;
import com.treemap.tagcloud.Orientation;
import com.treemap.tagcloud.Point2d;
import com.treemap.tagcloud.PositionIterator;
import com.treemap.tagcloud.TagCloudAlgorithm;
import com.treemap.tagcloud.TextShape;
import com.treemap.tagcloud.TextShapeFactory;
import com.treemap.tagcloud.Word;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u0000 M2\u00020\u00012\u00020\u0002:\u0001MB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB9\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f\u00a2\u0006\u0004\b\u0007\u0010\u0010Jm\u0010'\u001a\u00020(\"\u0004\b\u0000\u0010)\"\u0004\b\u0001\u0010*\"\u0004\b\u0002\u0010+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u0002H)2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H)002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u00172\f\u00105\u001a\b\u0012\u0004\u0012\u0002H)062\b\u00107\u001a\u0004\u0018\u000108H\u0016\u00a2\u0006\u0002\u00109J8\u0010:\u001a\u00020;\"\u0004\b\u0000\u0010)2\u0006\u0010,\u001a\u00020-2\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0\u00130=2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H)06H\u0002J\u001e\u0010>\u001a\u00020-2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u0002022\u0006\u0010,\u001a\u00020BJ.\u0010C\u001a\u00020(\"\u0004\b\u0000\u0010)2\f\u0010D\u001a\b\u0012\u0004\u0012\u0002H)0\u00132\u0012\u0010<\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0\u00130=J\u0012\u0010E\u001a\u00020(2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010I\u001a\u00020\u0017H\u0016J\u0010\u0010J\u001a\u00020;2\u0006\u0010\u001c\u001a\u00020\u0017H\u0016J\n\u0010#\u001a\u00060\u000ej\u0002`\u000fJ\u0006\u0010&\u001a\u00020\fJ\u0006\u0010%\u001a\u00020\nJ\n\u0010L\u001a\u00020\u001fH\u0096\u0080\u0004R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0015\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\r\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u000ej\u0004\u0018\u0001`\u000f0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010$R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\"X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u0014\u0010F\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u0014\u0010H\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010GR\u0014\u0010K\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010G\u00a8\u0006N"}, d2={"Lcom/treemap/tagcloud/AbstractTagCloudAlgorithm;", "Lcom/treemap/AbstractAlgorithm;", "Lcom/treemap/tagcloud/TagCloudAlgorithm;", "textShapeFactory", "Lcom/treemap/tagcloud/TextShapeFactory;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "<init>", "(Lcom/treemap/tagcloud/TextShapeFactory;Lorg/mkui/font/CPFontFactory;)V", "orientationMode", "Lcom/treemap/tagcloud/TagCloudAlgorithm$OrientationMode;", "spiral", "Lcom/treemap/tagcloud/TagCloudAlgorithm$Spiral;", "font", "Ljavafx/scene/text/Font;", "Lorg/mkui/font/MkFont;", "(Lcom/treemap/tagcloud/TextShapeFactory;Lorg/mkui/font/CPFontFactory;Lcom/treemap/tagcloud/TagCloudAlgorithm$OrientationMode;Lcom/treemap/tagcloud/TagCloudAlgorithm$Spiral;Ljavafx/scene/text/Font;)V", "words", "", "Lcom/treemap/tagcloud/Word;", "", "lastIntersectedWord", "maxTags", "", "getMaxTags", "()I", "setMaxTags", "(I)V", "nSubdivisions", "properties", "Lcom/macrofocus/common/properties/MutableProperties;", "", "getProperties", "()Lcom/macrofocus/common/properties/MutableProperties;", "Lcom/macrofocus/common/properties/MutableProperty;", "getFont", "()Lcom/macrofocus/common/properties/MutableProperty;", "getOrientationMode", "getSpiral", "breadthFirstLayout", "", "N", "Row", "Column", "shape", "Lorg/mkui/geom/Shape;", "parent", "children", "", "sumSizes", "", "horizontalVanishingPoint", "verticalVanishingPoint", "accessor", "Lcom/treemap/TreeMapAccessor;", "worker", "Lcom/treemap/TreeMapWorker;", "(Lorg/mkui/geom/Shape;Ljava/lang/Object;[Ljava/lang/Object;DIILcom/treemap/TreeMapAccessor;Lcom/treemap/TreeMapWorker;)Z", "createDiagramShapes", "", "placedWords", "", "getShape", "offsetAbsolute", "Lcom/treemap/tagcloud/Point2d;", "scale", "Lcom/treemap/tagcloud/TextShape;", "newWordIntersectsPlacedWords", "word", "isCompatible", "isRenderingLeafLabelsSupported", "()Z", "isRenderingParentLabelSupported", "getnSubdivisions", "setnSubdivisions", "isSpaceFilling", "toString", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class AbstractTagCloudAlgorithm
extends AbstractAlgorithm
implements TagCloudAlgorithm {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Word<Object>> words;
    @Nullable
    private Word<Object> lastIntersectedWord;
    @NotNull
    private final TextShapeFactory textShapeFactory;
    private int maxTags;
    private int nSubdivisions;
    @NotNull
    private final MutableProperties<String> properties;
    @NotNull
    private final MutableProperty<Font> font;
    @NotNull
    private final MutableProperty<TagCloudAlgorithm.OrientationMode> orientationMode;
    @NotNull
    private final MutableProperty<TagCloudAlgorithm.Spiral> spiral;
    public static final int $stable = 8;
    @NotNull
    public static final String PROPERTY_FONT = "font";
    @NotNull
    public static final String PROPERTY_ORIENTATIONMODE = "orientationMode";
    @NotNull
    public static final String PROPERTY_SPIRAL = "spiral";

    public AbstractTagCloudAlgorithm(@NotNull TextShapeFactory textShapeFactory, @NotNull CPFontFactory fontFactory) {
        Intrinsics.checkNotNullParameter((Object)textShapeFactory, (String)"textShapeFactory");
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        this.words = new ArrayList();
        this.maxTags = 500;
        this.nSubdivisions = 6;
        this.properties = (MutableProperties)new SimpleProperties();
        this.orientationMode = this.getProperties().createProperty((Object)PROPERTY_ORIENTATIONMODE, (Object)TagCloudAlgorithm.OrientationMode.AllHorizontal);
        this.spiral = this.getProperties().createProperty((Object)PROPERTY_SPIRAL, (Object)TagCloudAlgorithm.Spiral.Rectangular);
        this.textShapeFactory = textShapeFactory;
        this.font = this.getProperties().createProperty((Object)PROPERTY_FONT, (Object)DefaultTreeMapColumnSettings.Companion.getDefaultLabelingFont(fontFactory));
    }

    @Override
    public int getMaxTags() {
        return this.maxTags;
    }

    @Override
    public void setMaxTags(int n) {
        this.maxTags = n;
    }

    @Override
    @NotNull
    public MutableProperties<String> getProperties() {
        return this.properties;
    }

    @Override
    @NotNull
    public MutableProperty<Font> getFont() {
        return this.font;
    }

    @Override
    @NotNull
    public MutableProperty<TagCloudAlgorithm.OrientationMode> getOrientationMode() {
        return this.orientationMode;
    }

    @Override
    @NotNull
    public MutableProperty<TagCloudAlgorithm.Spiral> getSpiral() {
        return this.spiral;
    }

    public AbstractTagCloudAlgorithm(@NotNull TextShapeFactory textShapeFactory, @NotNull CPFontFactory fontFactory, @NotNull TagCloudAlgorithm.OrientationMode orientationMode, @NotNull TagCloudAlgorithm.Spiral spiral, @Nullable Font font) {
        Intrinsics.checkNotNullParameter((Object)textShapeFactory, (String)"textShapeFactory");
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)orientationMode), (String)PROPERTY_ORIENTATIONMODE);
        Intrinsics.checkNotNullParameter((Object)((Object)spiral), (String)PROPERTY_SPIRAL);
        this(textShapeFactory, fontFactory);
        this.getOrientationMode().setValue((Object)orientationMode);
        this.getSpiral().setValue((Object)spiral);
        this.getFont().setValue((Object)font);
    }

    @Override
    public <N, Row, Column> boolean breadthFirstLayout(@NotNull Shape shape, N parent, @NotNull N[] children, double sumSizes, int horizontalVanishingPoint, int verticalVanishingPoint, @NotNull TreeMapAccessor<? super N> accessor, @Nullable TreeMapWorker worker) {
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter(children, (String)"children");
        Intrinsics.checkNotNullParameter(accessor, (String)"accessor");
        this.words.clear();
        List placedWords = new ArrayList();
        Random random = RandomKt.Random((int)1);
        if (this.getFont().getValue() != null) {
            // empty if block
        }
        int count2 = Math.min(this.getMaxTags(), children.length);
        for (int i = 0; i < count2; ++i) {
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            N child = children[i];
            String text = String.valueOf(child);
            boolean vertical = false;
            vertical = switch (WhenMappings.$EnumSwitchMapping$0[((TagCloudAlgorithm.OrientationMode)((Object)this.getOrientationMode().getValue())).ordinal()]) {
                case 1 -> false;
                case 2 -> random.nextBoolean();
                default -> false;
            };
            Orientation orientation = null;
            orientation = vertical ? Orientation.Vertical : Orientation.Horizontal;
            double p = accessor.getSize(child) / sumSizes;
            Object object = this.getFont().getValue();
            Intrinsics.checkNotNull((Object)object);
            this.words.add(new DefaultWord<N>(this.textShapeFactory, text, p, child, orientation, this.nSubdivisions, (Font)object));
        }
        if (worker != null && worker.isCancelled()) {
            return true;
        }
        CollectionsKt.sort(this.words);
        CollectionsKt.reverse(this.words);
        ArchimedeanSpiral spiral = null;
        switch (WhenMappings.$EnumSwitchMapping$1[((TagCloudAlgorithm.Spiral)((Object)this.getSpiral().getValue())).ordinal()]) {
            case 1: {
                spiral = new ArchimedeanSpiral(this.words.get(this.words.size() - 1).getShapeForLayout().getBounds2D().getHeight() * 0.05);
                break;
            }
            case 2: {
                spiral = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Point2d position = new Point2d(0.0, 0.0);
        PositionIterator positionIterator = new PositionIterator(shape);
        double totalMaximumSideLength = 0.0;
        this.lastIntersectedWord = null;
        int counter = 0;
        for (Word<Object> word : this.words) {
            if (worker != null && worker.isCancelled()) {
                return true;
            }
            double wordWidth = word.getShapeForLayout().getBounds2D().getWidth();
            double wordHeight = word.getShapeForLayout().getBounds2D().getHeight();
            double minSideLength = Math.min(wordWidth, wordHeight);
            double maxSideLength = Math.max(wordWidth, wordHeight);
            totalMaximumSideLength = Math.max(maxSideLength, totalMaximumSideLength);
            double stepSize = maxSideLength / (double)10;
            stepSize = Math.max(stepSize, totalMaximumSideLength / 20.0);
            positionIterator.resetIterator(stepSize);
            double theta = Math.PI * 2;
            boolean stepIncreaseCounter = false;
            boolean debug = false;
            while (true) {
                Intrinsics.checkNotNull(word, (String)"null cannot be cast to non-null type com.treemap.tagcloud.Word<N of com.treemap.tagcloud.AbstractTagCloudAlgorithm.breadthFirstLayout>");
                if (!this.newWordIntersectsPlacedWords(word, placedWords)) break;
                if (spiral != null) {
                    spiral.get(theta, position);
                    double d = (double)2 * spiral.getRadius(theta);
                    double dTheta = 0.5 / d * (double)2;
                    theta += dTheta;
                } else {
                    positionIterator.getNextPosition(position);
                }
                word.setLocation(position);
                ++counter;
            }
            placedWords.add(word);
            ++counter;
        }
        for (N child : children) {
            accessor.setShape(child, null);
        }
        this.createDiagramShapes(shape, placedWords, accessor);
        return false;
    }

    private final <N> void createDiagramShapes(Shape shape, List<? extends Word<N>> placedWords, TreeMapAccessor<? super N> accessor) {
        Rectangle2D.Double diagramBoundsNormed = null;
        for (Word<N> placedWord : placedWords) {
            Rectangle2D b = placedWord.getShapeForLayout().getBounds2D();
            diagramBoundsNormed = diagramBoundsNormed != null ? diagramBoundsNormed.add(b) : new Rectangle2D.Double(b.getX(), b.getY(), b.getWidth(), b.getHeight());
        }
        Rectangle2D domainBoundsAbsolute = shape.getBounds2D();
        double domainAspect = domainBoundsAbsolute.getWidth() / domainBoundsAbsolute.getHeight();
        Rectangle2D.Double double_ = diagramBoundsNormed;
        Intrinsics.checkNotNull(double_);
        double diagramAspect = double_.getWidth() / diagramBoundsNormed.getHeight();
        double scale = 0.0;
        scale = diagramAspect > domainAspect ? domainBoundsAbsolute.getWidth() / diagramBoundsNormed.getWidth() : domainBoundsAbsolute.getHeight() / diagramBoundsNormed.getHeight();
        double widthDiff = domainBoundsAbsolute.getWidth() - diagramBoundsNormed.getWidth() * scale;
        double heightDiff = domainBoundsAbsolute.getHeight() - diagramBoundsNormed.getHeight() * scale;
        Point2d offsetAbsolute = new Point2d(domainBoundsAbsolute.getX() - diagramBoundsNormed.getX() * scale + widthDiff / (double)2, domainBoundsAbsolute.getY() - diagramBoundsNormed.getY() * scale + heightDiff / (double)2);
        for (Word<N> word : placedWords) {
            Shape s = this.getShape(offsetAbsolute, scale, word.getShapeForLayout());
            accessor.setShape(word.getTreeMapNode(), s);
        }
    }

    @NotNull
    public final Shape getShape(@NotNull Point2d offsetAbsolute, double scale, @NotNull TextShape shape) {
        Intrinsics.checkNotNullParameter((Object)offsetAbsolute, (String)"offsetAbsolute");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        AffineTransform transform = new AffineTransform(scale, 0.0, 0.0, scale, offsetAbsolute.getX(), offsetAbsolute.getY());
        return shape.createTransformedShape(transform);
    }

    public final <N> boolean newWordIntersectsPlacedWords(@NotNull Word<N> word, @NotNull List<? extends Word<N>> placedWords) {
        Intrinsics.checkNotNullParameter(word, (String)"word");
        Intrinsics.checkNotNullParameter(placedWords, (String)"placedWords");
        if (this.lastIntersectedWord != null) {
            Word<Object> word2 = this.lastIntersectedWord;
            Intrinsics.checkNotNull(word2, (String)"null cannot be cast to non-null type com.treemap.tagcloud.Word<N of com.treemap.tagcloud.AbstractTagCloudAlgorithm.newWordIntersectsPlacedWords>");
            if (word.intersects(word2)) {
                return true;
            }
        }
        for (Word<N> placedWord : placedWords) {
            if (placedWord == this.lastIntersectedWord || !word.intersects(placedWord)) continue;
            Intrinsics.checkNotNull(placedWord, (String)"null cannot be cast to non-null type com.treemap.tagcloud.Word<kotlin.Any?>");
            this.lastIntersectedWord = placedWord;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCompatible(@Nullable Shape shape) {
        return shape instanceof Rectangle2D;
    }

    @Override
    public boolean isRenderingLeafLabelsSupported() {
        return false;
    }

    @Override
    public boolean isRenderingParentLabelSupported() {
        return false;
    }

    @Override
    public int getnSubdivisions() {
        return this.nSubdivisions;
    }

    @Override
    public void setnSubdivisions(int nSubdivisions) {
        this.nSubdivisions = nSubdivisions;
    }

    @NotNull
    public final Font getFont() {
        Object object = this.getFont().getValue();
        Intrinsics.checkNotNull((Object)object);
        return (Font)object;
    }

    @NotNull
    public final TagCloudAlgorithm.Spiral getSpiral() {
        return (TagCloudAlgorithm.Spiral)((Object)this.getSpiral().getValue());
    }

    @NotNull
    public final TagCloudAlgorithm.OrientationMode getOrientationMode() {
        return (TagCloudAlgorithm.OrientationMode)((Object)this.getOrientationMode().getValue());
    }

    @Override
    public boolean isSpaceFilling() {
        return false;
    }

    @NotNull
    public String toString() {
        return "Tag Cloud";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/treemap/tagcloud/AbstractTagCloudAlgorithm$Companion;", "", "<init>", "()V", "PROPERTY_FONT", "", "PROPERTY_ORIENTATIONMODE", "PROPERTY_SPIRAL", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TagCloudAlgorithm.OrientationMode.values().length];
            try {
                nArray[TagCloudAlgorithm.OrientationMode.AllHorizontal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TagCloudAlgorithm.OrientationMode.HorizontalAndVertical.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TagCloudAlgorithm.Spiral.values().length];
            try {
                nArray[TagCloudAlgorithm.Spiral.Archimedean.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TagCloudAlgorithm.Spiral.Rectangular.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

