/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.tagcloud;

import androidx.compose.runtime.internal.StabilityInferred;
import com.treemap.tagcloud.Point2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00000\r\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lcom/treemap/tagcloud/HierarchicalBoundingBox;", "", "bounds", "Lorg/mkui/geom/Rectangle2D;", "shape", "Lorg/mkui/geom/Shape;", "nSubdivisions", "", "<init>", "(Lorg/mkui/geom/Rectangle2D;Lorg/mkui/geom/Shape;I)V", "originalLocation", "Lcom/treemap/tagcloud/Point2d;", "children", "", "getChildren", "()[Lcom/treemap/tagcloud/HierarchicalBoundingBox;", "[Lcom/treemap/tagcloud/HierarchicalBoundingBox;", "isLeaf", "", "()Z", "setLeaf", "(Z)V", "getBounds", "setTranslation", "", "xPos", "", "yPos", "treemap"})
@StabilityInferred(parameters=0)
public final class HierarchicalBoundingBox {
    @NotNull
    private final Point2d originalLocation;
    @Nullable
    private Rectangle2D bounds;
    @NotNull
    private final HierarchicalBoundingBox[] children;
    private boolean isLeaf;
    public static final int $stable = 8;

    public HierarchicalBoundingBox(@NotNull Rectangle2D bounds, @NotNull Shape shape, int nSubdivisions) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        this.originalLocation = new Point2d();
        this.children = new HierarchicalBoundingBox[4];
        this.bounds = (Rectangle2D)new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.originalLocation.set(bounds.getX(), bounds.getY());
        if (nSubdivisions > 0) {
            this.isLeaf = false;
            double halfBoundsWidth = bounds.getWidth() / 2.0;
            double halfBoundsHeight = bounds.getHeight() / 2.0;
            for (int nChild = 0; nChild < 4; ++nChild) {
                double x = 0.0;
                double y = 0.0;
                switch (nChild) {
                    case 1: 
                    case 2: {
                        Rectangle2D rectangle2D = this.bounds;
                        Intrinsics.checkNotNull((Object)rectangle2D);
                        x = rectangle2D.getX();
                        break;
                    }
                    default: {
                        Rectangle2D rectangle2D = this.bounds;
                        Intrinsics.checkNotNull((Object)rectangle2D);
                        x = rectangle2D.getX() + halfBoundsWidth;
                    }
                }
                if (nChild < 2) {
                    Rectangle2D rectangle2D = this.bounds;
                    Intrinsics.checkNotNull((Object)rectangle2D);
                    y = rectangle2D.getY();
                } else {
                    Rectangle2D rectangle2D = this.bounds;
                    Intrinsics.checkNotNull((Object)rectangle2D);
                    y = rectangle2D.getY() + halfBoundsHeight;
                }
                Rectangle2D boundsForTest = (Rectangle2D)new Rectangle2D.Double(x, y, halfBoundsWidth, halfBoundsHeight);
                if (!shape.intersects(boundsForTest)) continue;
                this.children[nChild] = new HierarchicalBoundingBox(boundsForTest, shape, nSubdivisions - 1);
            }
        } else {
            this.isLeaf = true;
        }
    }

    @NotNull
    public final HierarchicalBoundingBox[] getChildren() {
        return this.children;
    }

    public final boolean isLeaf() {
        return this.isLeaf;
    }

    public final void setLeaf(boolean bl) {
        this.isLeaf = bl;
    }

    @NotNull
    public final Rectangle2D getBounds() {
        Rectangle2D rectangle2D = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D);
        double d = rectangle2D.getX();
        Rectangle2D rectangle2D2 = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D2);
        double d2 = rectangle2D2.getY();
        Rectangle2D rectangle2D3 = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D3);
        double d3 = rectangle2D3.getWidth();
        Rectangle2D rectangle2D4 = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D4);
        return (Rectangle2D)new Rectangle2D.Double(d, d2, d3, rectangle2D4.getHeight());
    }

    public final void setTranslation(double xPos, double yPos) {
        double d = this.originalLocation.getX() + xPos;
        double d2 = this.originalLocation.getY() + yPos;
        Rectangle2D rectangle2D = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D);
        double d3 = rectangle2D.getWidth();
        Rectangle2D rectangle2D2 = this.bounds;
        Intrinsics.checkNotNull((Object)rectangle2D2);
        this.bounds = (Rectangle2D)new Rectangle2D.Double(d, d2, d3, rectangle2D2.getHeight());
        if (!this.isLeaf) {
            HierarchicalBoundingBox[] hierarchicalBoundingBoxArray = this.children;
            int n = hierarchicalBoundingBoxArray.length;
            for (int i = 0; i < n; ++i) {
                HierarchicalBoundingBox child;
                HierarchicalBoundingBox hierarchicalBoundingBox = child = hierarchicalBoundingBoxArray[i];
                if (hierarchicalBoundingBox == null) continue;
                hierarchicalBoundingBox.setTranslation(xPos, yPos);
            }
        }
    }
}

