/*
 * Decompiled with CFR 0.152.
 */
package com.treemap.treeplot;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\u000e\u001a\u0004\u0018\u00010\u0000J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0010J\u0016\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0000J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u0010\u0010\u0019\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u0010\u0010\u001b\u001a\u00020\u00002\b\u0010\u0018\u001a\u0004\u0018\u00010\u0000J\n\u0010\u001c\u001a\u00020\u001dH\u0096\u0080\u0004J\u0006\u0010\u001e\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u0006\u0010#\u001a\u00020\u0000J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u001a\u0010&\u001a\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010+\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010(\"\u0004\b-\u0010*R\u0010\u0010.\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010(\"\u0004\b3\u0010*R\u001c\u00104\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010(\"\u0004\b6\u0010*R\u0010\u00107\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u00108\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0018\u000109j\n\u0012\u0004\u0012\u00020\u0000\u0018\u0001`:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010<\u001a\u0016\u0012\u0004\u0012\u00020\u0000\u0018\u000109j\n\u0012\u0004\u0012\u00020\u0000\u0018\u0001`:X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/treemap/treeplot/Spoint;", "", "x", "", "y", "<init>", "(DD)V", "getX", "()D", "getY", "Insert", "", "who", "VirtualInsert", "Delete", "AddClosest", "", "col", "", "NNUpdate", "NNDelete", "AddSpheresLink", "FindClosest", "SquareDistance", "other", "distance", "add", "subtract", "toString", "", "Norm", "scale", "byWhat", "NormalRight", "normalLeft", "Normalize", "Average", "Negate", "next", "getNext", "()Lcom/treemap/treeplot/Spoint;", "setNext", "(Lcom/treemap/treeplot/Spoint;)V", "prev", "getPrev", "setPrev", "left", "right", "parent", "chnext", "getChnext", "setChnext", "chprev", "getChprev", "setChprev", "closest", "imClosest", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "nnColour", "siEdges", "siColour", "Companion", "treemap"})
@StabilityInferred(parameters=0)
public final class Spoint {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    @NotNull
    private Spoint next;
    @Nullable
    private Spoint prev;
    @Nullable
    private Spoint left;
    @Nullable
    private Spoint right;
    @Nullable
    private Spoint parent;
    @Nullable
    private Spoint chnext;
    @Nullable
    private Spoint chprev;
    @Nullable
    private Spoint closest;
    @Nullable
    private ArrayList<Spoint> imClosest;
    private long nnColour;
    @Nullable
    private ArrayList<Spoint> siEdges;
    private long siColour;
    public static final int $stable = 8;

    public Spoint(double x, double y) {
        this.x = x;
        this.y = y;
        Spoint spoint = this.prev = (this.left = (this.right = (this.parent = (this.chprev = this.chnext))));
        Intrinsics.checkNotNull((Object)spoint);
        this.next = spoint;
        this.imClosest = null;
        this.siEdges = null;
        this.nnColour = 0L;
        this.siColour = 0L;
        this.closest = null;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final boolean Insert(@NotNull Spoint who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (who.x < this.x) {
            if (this.left == null) {
                this.left = who;
                who.parent = this;
                who.prev = this.prev;
                who.next = this;
                this.prev = who;
                if (who.prev != null) {
                    Intrinsics.checkNotNull((Object)who.prev);
                    who.prev.next = who;
                }
            } else {
                Spoint spoint = this.left;
                Intrinsics.checkNotNull((Object)spoint);
                spoint.Insert(who);
            }
        } else if (this.right == null) {
            this.right = who;
            who.parent = this;
            who.prev = this;
            who.next = this.next;
            this.next = who;
            if (who.next != null) {
                who.next.prev = who;
            }
        } else {
            Spoint spoint = this.right;
            Intrinsics.checkNotNull((Object)spoint);
            spoint.Insert(who);
        }
        return true;
    }

    @NotNull
    public final Spoint VirtualInsert(@NotNull Spoint who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        Spoint p = this;
        Spoint c = this;
        while (c != null) {
            p = c;
            c = who.x < c.x ? c.left : c.right;
        }
        return p;
    }

    @Nullable
    public final Spoint Delete() {
        Spoint replacement = null;
        if (this.left == null && this.right == null) {
            if (this.parent != null) {
                Spoint spoint = this.parent;
                Intrinsics.checkNotNull((Object)spoint);
                if (Intrinsics.areEqual((Object)spoint.left, (Object)this)) {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.left = null;
                } else {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.right = null;
                }
            }
            replacement = null;
        } else if (this.left != null && this.right != null) {
            Spoint spoint = replacement = this.x <= this.y ? this.prev : this.next;
            if (this.parent != null) {
                Spoint spoint2 = this.parent;
                Intrinsics.checkNotNull((Object)spoint2);
                if (Intrinsics.areEqual((Object)spoint2.left, (Object)this)) {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.left = replacement;
                } else {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.right = replacement;
                }
            }
            Spoint spoint3 = replacement;
            Intrinsics.checkNotNull((Object)spoint3);
            Spoint spoint4 = spoint3.parent;
            Intrinsics.checkNotNull((Object)spoint4);
            if (Intrinsics.areEqual((Object)spoint4.left, (Object)replacement)) {
                Intrinsics.checkNotNull((Object)replacement.parent);
                replacement.parent.left = null;
            } else {
                Intrinsics.checkNotNull((Object)replacement.parent);
                replacement.parent.right = null;
            }
            Intrinsics.checkNotNull((Object)this.left);
            this.left.parent = replacement;
            Intrinsics.checkNotNull((Object)this.right);
            this.right.parent = replacement;
            replacement.parent = this.parent;
            replacement.left = this.left;
            replacement.right = this.right;
        } else {
            Spoint spoint = replacement = this.right != null ? this.right : this.left;
            if (this.parent != null) {
                Spoint spoint5 = this.parent;
                Intrinsics.checkNotNull((Object)spoint5);
                if (Intrinsics.areEqual((Object)spoint5.left, (Object)this)) {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.left = replacement;
                } else {
                    Intrinsics.checkNotNull((Object)this.parent);
                    this.parent.right = replacement;
                }
            }
            Intrinsics.checkNotNull((Object)replacement);
            replacement.parent = this.parent;
        }
        if (this.prev != null) {
            Intrinsics.checkNotNull((Object)this.prev);
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        Spoint spoint = this.prev = (this.parent = (this.left = (this.right = null)));
        Intrinsics.checkNotNull((Object)spoint);
        this.next = spoint;
        return replacement;
    }

    public final void AddClosest(@NotNull Spoint who, long col) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (this.imClosest == null || this.nnColour != col) {
            this.imClosest = new ArrayList(6);
            this.nnColour = col;
        }
        ArrayList<Spoint> arrayList = this.imClosest;
        Intrinsics.checkNotNull(arrayList);
        arrayList.add(who);
    }

    public final void AddClosest(@NotNull Spoint who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (this.imClosest == null) {
            this.imClosest = new ArrayList(6);
        }
        ArrayList<Spoint> arrayList = this.imClosest;
        Intrinsics.checkNotNull(arrayList);
        arrayList.add(who);
    }

    public final void NNUpdate() {
        if (this.closest != null) {
            Spoint spoint = this.closest;
            Intrinsics.checkNotNull((Object)spoint);
            ArrayList<Spoint> arrayList = spoint.imClosest;
            Intrinsics.checkNotNull(arrayList);
            arrayList.remove(this);
        }
        this.closest = this.FindClosest();
        if (this.closest != null) {
            Spoint spoint = this.closest;
            Intrinsics.checkNotNull((Object)spoint);
            spoint.AddClosest(this);
        }
    }

    public final void NNDelete() {
        if (this.closest != null) {
            Spoint spoint = this.closest;
            Intrinsics.checkNotNull((Object)spoint);
            ArrayList<Spoint> arrayList = spoint.imClosest;
            Intrinsics.checkNotNull(arrayList);
            arrayList.remove(this);
        }
        if (this.imClosest != null) {
            Spoint upd = null;
            while (true) {
                ArrayList<Spoint> arrayList = this.imClosest;
                Intrinsics.checkNotNull(arrayList);
                if (arrayList.size() <= 0) break;
                ArrayList<Spoint> arrayList2 = this.imClosest;
                Intrinsics.checkNotNull(arrayList2);
                upd = (Spoint)CollectionsKt.first((List)arrayList2);
                upd.NNUpdate();
            }
        }
        this.closest = null;
        this.imClosest = null;
        this.nnColour = 0L;
    }

    public final void AddSpheresLink(@NotNull Spoint who, long col) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (this.siEdges == null || this.siColour != col) {
            this.siEdges = new ArrayList(10);
            this.siColour = col;
        }
        ArrayList<Spoint> arrayList = this.siEdges;
        Intrinsics.checkNotNull(arrayList);
        arrayList.add(who);
    }

    public final void AddSpheresLink(@NotNull Spoint who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (this.siEdges == null) {
            this.siEdges = new ArrayList(10);
        }
        ArrayList<Spoint> arrayList = this.siEdges;
        Intrinsics.checkNotNull(arrayList);
        arrayList.add(who);
    }

    @Nullable
    public final Spoint FindClosest() {
        Spoint spoint = this.prev != null ? this.prev : this.next;
        if (spoint == null) {
            return null;
        }
        Spoint prox = spoint;
        Spoint l = this.prev;
        Spoint r = this.next;
        double bound = this.SquareDistance(prox);
        while (l != null || r != null) {
            double distFound;
            if (l != null) {
                distFound = this.SquareDistance(l);
                if (distFound < bound) {
                    bound = distFound;
                    prox = l;
                }
                Spoint spoint2 = l = (this.x - l.x) * (this.x - l.x) < bound ? l.prev : null;
            }
            if (r == null) continue;
            distFound = this.SquareDistance(r);
            if (distFound < bound) {
                bound = distFound;
                prox = r;
            }
            r = (this.x - r.x) * (this.x - r.x) < bound ? r.next : null;
        }
        return prox;
    }

    public final double SquareDistance(@Nullable Spoint other) {
        Spoint spoint = other;
        Intrinsics.checkNotNull((Object)spoint);
        return (spoint.x - this.x) * (other.x - this.x) + (other.y - this.y) * (other.y - this.y);
    }

    public final double distance(@Nullable Spoint other) {
        return Math.sqrt(this.SquareDistance(other));
    }

    @NotNull
    public final Spoint add(@NotNull Spoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Spoint(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Spoint subtract(@Nullable Spoint other) {
        Spoint spoint = other;
        Intrinsics.checkNotNull((Object)spoint);
        return new Spoint(this.x - spoint.x, this.y - other.y);
    }

    @NotNull
    public String toString() {
        return this.x + "," + this.y;
    }

    public final double Norm() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @NotNull
    public final Spoint scale(double byWhat) {
        return new Spoint(byWhat * this.x, byWhat * this.y);
    }

    @NotNull
    public final Spoint NormalRight() {
        return new Spoint(-this.y, this.x);
    }

    @NotNull
    public final Spoint normalLeft() {
        return new Spoint(this.y, -this.x);
    }

    @NotNull
    public final Spoint Normalize() {
        return this.scale(1.0 / this.Norm());
    }

    @NotNull
    public final Spoint Average(@NotNull Spoint other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Spoint((this.x + other.x) / 2.0, (this.y + other.y) / 2.0);
    }

    @NotNull
    public final Spoint Negate() {
        return new Spoint(-this.x, -this.y);
    }

    @NotNull
    public final Spoint getNext() {
        return this.next;
    }

    public final void setNext(@NotNull Spoint spoint) {
        Intrinsics.checkNotNullParameter((Object)spoint, (String)"<set-?>");
        this.next = spoint;
    }

    @Nullable
    public final Spoint getPrev() {
        return this.prev;
    }

    public final void setPrev(@Nullable Spoint spoint) {
        this.prev = spoint;
    }

    @Nullable
    public final Spoint getChnext() {
        return this.chnext;
    }

    public final void setChnext(@Nullable Spoint spoint) {
        this.chnext = spoint;
    }

    @Nullable
    public final Spoint getChprev() {
        return this.chprev;
    }

    public final void setChprev(@Nullable Spoint spoint) {
        this.chprev = spoint;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J$\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/treemap/treeplot/Spoint$Companion;", "", "<init>", "()V", "infiniteLineIntersection", "Lcom/treemap/treeplot/Spoint;", "base1", "v1", "base2", "v2", "Polar2Vect", "r", "", "theta", "Vect2Polar", "vect", "angleBetweenPoints", "a", "b", "c", "Deg2Rad", "Rad2Deg", "treemap"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Spoint infiniteLineIntersection(@NotNull Spoint base1, @NotNull Spoint v1, @NotNull Spoint base2, @NotNull Spoint v2) {
            double m2;
            Intrinsics.checkNotNullParameter((Object)base1, (String)"base1");
            Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
            Intrinsics.checkNotNullParameter((Object)base2, (String)"base2");
            Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
            if (v1.getX() == 0.0 && v2.getY() == 0.0) {
                return new Spoint(base1.getX(), base2.getY());
            }
            if (v1.getY() == 0.0 && v2.getX() == 0.0) {
                return new Spoint(base2.getX(), base1.getY());
            }
            double m1 = !(v1.getX() == 0.0) ? v1.getY() / v1.getX() : 0.0;
            if (m1 == (m2 = !(v2.getX() == 0.0) ? v2.getY() / v2.getX() : 0.0)) {
                return null;
            }
            double c1 = base1.getY() - m1 * base1.getX();
            double c2 = base2.getY() - m2 * base2.getX();
            double ix = (c2 - c1) / (m1 - m2);
            double iy = m1 * ix + c1;
            if (v1.getX() == 0.0) {
                return new Spoint(base1.getX(), base1.getX() * m2 + c2);
            }
            return v2.getX() == 0.0 ? new Spoint(base2.getX(), base2.getX() * m1 + c1) : new Spoint(ix, iy);
        }

        @NotNull
        public final Spoint Polar2Vect(double r, double theta) {
            double theta2 = theta;
            if (theta2 < 0.0) {
                theta2 += 360.0;
            }
            double thetaR = this.Deg2Rad(theta2);
            double nx = Math.abs(r * Math.cos(thetaR));
            double ny = Math.abs(r * Math.sin(thetaR));
            if (theta2 >= 90.0 && theta2 <= 270.0) {
                nx = -nx;
            }
            if (theta2 >= 180.0) {
                ny = -ny;
            }
            return new Spoint(nx, ny);
        }

        private final double Vect2Polar(Spoint vect) {
            double theta = 0.0;
            if (vect.getX() == 0.0) {
                theta = vect.getY() > 0.0 ? 90.0 : (vect.getY() < 0.0 ? 270.0 : 0.0);
            } else {
                theta = this.Rad2Deg(Math.atan(vect.getY() / vect.getX()));
                if (vect.getX() < 0.0) {
                    theta += 180.0;
                }
                if (theta < 0.0) {
                    theta += 360.0;
                }
            }
            return theta;
        }

        public final double angleBetweenPoints(@Nullable Spoint a, @Nullable Spoint b, @Nullable Spoint c) {
            Spoint spoint = a;
            Intrinsics.checkNotNull((Object)spoint);
            Spoint vectBA = spoint.subtract(b);
            Spoint spoint2 = c;
            Intrinsics.checkNotNull((Object)spoint2);
            Spoint vectBC = spoint2.subtract(b);
            double theta = this.Vect2Polar(vectBA) - this.Vect2Polar(vectBC);
            if (theta < 0.0) {
                theta += 360.0;
            }
            if (theta > 180.0) {
                theta = 360.0 - theta;
            }
            return theta;
        }

        private final double Deg2Rad(double a) {
            return a * Math.PI / 180.0;
        }

        private final double Rad2Deg(double a) {
            return a * 180.0 / Math.PI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

