/*
 * Decompiled with CFR 0.152.
 */
package org.molap.aggregates.aggregation;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.aggregates.aggregation.AbstractAggregation;
import org.molap.aggregates.cube.DistributiveStatistics;
import org.molap.aggregates.cube.Group;
import org.molap.aggregates.cuboid.Cuboid;
import org.molap.series.Series;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B!\b\u0016\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B;\b\u0016\u0012\u0016\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u001e\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\n\u0010\u0012\u001a\u00020\u0013H\u0096\u0080\u0004R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lorg/molap/aggregates/aggregation/VarianceAggregation;", "Lorg/molap/aggregates/aggregation/AbstractAggregation;", "", "column", "Lorg/molap/series/Series;", "<init>", "(Lorg/molap/series/Series;)V", "population", "(Lorg/molap/series/Series;Lorg/molap/series/Series;)V", "type", "Lkotlin/reflect/KClass;", "getType", "()Lkotlin/reflect/KClass;", "compute", "cuboid", "Lorg/molap/aggregates/cuboid/Cuboid;", "group", "Lorg/molap/aggregates/cube/Group;", "toString", "", "molap"})
public final class VarianceAggregation
extends AbstractAggregation<Object> {
    @NotNull
    private final Series<Object, Object> column;
    @Nullable
    private final Series<Object, Object> population;

    public VarianceAggregation(@NotNull Series<Object, Object> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.column = column;
        this.population = null;
    }

    public VarianceAggregation(@NotNull Series<Object, Object> column, @Nullable Series<Object, Object> population) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        this.column = column;
        this.population = population;
    }

    @Override
    @NotNull
    public KClass<Object> getType() {
        return Reflection.getOrCreateKotlinClass(Double.TYPE);
    }

    @Override
    @Nullable
    public Object compute(@Nullable Cuboid cuboid, @Nullable Group group) {
        Double d;
        Cuboid cuboid2 = cuboid;
        Intrinsics.checkNotNull((Object)cuboid2);
        DistributiveStatistics d2 = cuboid2.getDistributiveStatistics(group, this.column, null);
        if (this.population != null) {
            DistributiveStatistics p = cuboid.getDistributiveStatistics(group, this.population, null);
            DistributiveStatistics distributiveStatistics = d2;
            Intrinsics.checkNotNull((Object)distributiveStatistics);
            Double d3 = distributiveStatistics.getUncorrectedSumOfSquares();
            Intrinsics.checkNotNull((Object)d3);
            double d4 = d3;
            DistributiveStatistics distributiveStatistics2 = p;
            Intrinsics.checkNotNull((Object)distributiveStatistics2);
            double d5 = d4 / (double)distributiveStatistics2.getCount();
            Double d6 = d2.getMean();
            Intrinsics.checkNotNull((Object)d6);
            double d7 = d6;
            Double d8 = d2.getMean();
            Intrinsics.checkNotNull((Object)d8);
            d = d5 - d7 * d8;
        } else {
            DistributiveStatistics distributiveStatistics = d2;
            Intrinsics.checkNotNull((Object)distributiveStatistics);
            d = distributiveStatistics.getVariance();
        }
        return d;
    }

    @NotNull
    public String toString() {
        return "Variance(" + this.column.getName() + ")";
    }
}

