/*
 * Decompiled with CFR 0.152.
 */
package org.molap.dataframe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.convert.AutoConverter;
import org.molap.convert.TypeConverter;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.importer.DataFrameReader;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;
import org.molap.index.UniqueIndex;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B1\b\u0016\u0012\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u001d\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u000b\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\fJ\u0014\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u0014\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u0003H\u0016J\"\u0010\"\u001a\u00020#2\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00032\b\u0010$\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00160\u0016X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00190\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001a\u00a8\u0006&"}, d2={"Lorg/molap/dataframe/SimpleDataFrame;", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "", "", "", "reader", "Lorg/molap/dataframe/DataFrame;", "autoConverter", "Lorg/molap/convert/AutoConverter;", "<init>", "(Lorg/molap/dataframe/DataFrame;Lorg/molap/convert/AutoConverter;)V", "Lorg/molap/importer/DataFrameReader;", "(Lorg/molap/importer/DataFrameReader;Lorg/molap/convert/AutoConverter;)V", "columnIndex", "Lorg/molap/index/DefaultUniqueIndex;", "getColumnIndex", "()Lorg/molap/index/DefaultUniqueIndex;", "rowIndex", "Lorg/molap/index/UniqueIndex;", "getRowIndex", "()Lorg/molap/index/UniqueIndex;", "objects", "", "[[Ljava/lang/Object;", "classes", "Lkotlin/reflect/KClass;", "[Lkotlin/reflect/KClass;", "getRowClass", "integer", "getColumnClass", "s", "getValueAt", "row", "column", "setValueAt", "", "value", "autoConvert", "molap"})
public final class SimpleDataFrame
extends AbstractMutableDataFrame<Integer, String, Object> {
    @NotNull
    private final DefaultUniqueIndex<String> columnIndex;
    @NotNull
    private final UniqueIndex<Integer> rowIndex;
    @NotNull
    private Object[][] objects;
    @NotNull
    private final KClass<?>[] classes;

    @Override
    @NotNull
    public DefaultUniqueIndex<String> getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    @NotNull
    public UniqueIndex<Integer> getRowIndex() {
        return this.rowIndex;
    }

    public SimpleDataFrame(@NotNull DataFrame<Integer, String, Object> reader, @Nullable AutoConverter autoConverter) {
        int n;
        Object[][] columnName;
        int i;
        Intrinsics.checkNotNullParameter(reader, (String)"reader");
        String[] names = new String[reader.getColumnCount()];
        this.classes = new KClass[reader.getColumnCount()];
        int n2 = reader.getColumnCount();
        for (i = 0; i < n2; ++i) {
            columnName = reader.getColumnName(reader.getColumnKey(i));
            names[i] = columnName != null ? columnName.toString() : null;
            this.classes[i] = reader.getColumnClass(reader.getColumnKey(i));
        }
        i = 0;
        n2 = reader.getRowCount();
        columnName = new Object[n2][];
        SimpleDataFrame simpleDataFrame = this;
        while (i < n2) {
            n = i++;
            columnName[n] = new Object[reader.getColumnCount()];
        }
        simpleDataFrame.objects = columnName;
        n2 = reader.getRowCount();
        for (int row = 0; row < n2; ++row) {
            n = reader.getColumnCount();
            for (int column = 0; column < n; ++column) {
                Object o = reader.getValueAt(reader.getRowKey(row), reader.getColumnKey(column));
                if (row > 0 && this.objects[row - 1][column] != null && Intrinsics.areEqual((Object)this.objects[row - 1][column], (Object)o)) {
                    o = this.objects[row - 1][column];
                }
                this.objects[row][column] = o;
            }
        }
        Object[] columns = new String[names.length];
        Set unique = new HashSet();
        n = names.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (names[i2] != null) {
                String header;
                Intrinsics.checkNotNull((Object)names[i2]);
                int c = 0;
                while (unique.contains(header)) {
                    header = (String)header + "-" + c;
                }
                columns[i2] = header;
                unique.add(header);
                continue;
            }
            columns[i2] = String.valueOf(i2);
        }
        String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])columns);
        this.columnIndex = new DefaultUniqueIndex<String>(Arrays.copyOf(stringArray, stringArray.length));
        this.rowIndex = new IntegerRangeUniqueIndex(0, ((Object[])this.objects).length - 1);
        if (autoConverter != null) {
            this.autoConvert(autoConverter);
        }
    }

    public /* synthetic */ SimpleDataFrame(DataFrame dataFrame, AutoConverter autoConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            autoConverter = null;
        }
        this(dataFrame, autoConverter);
    }

    public SimpleDataFrame(@NotNull DataFrameReader reader, @Nullable AutoConverter autoConverter) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        String[] names = new String[reader.getColumnCount()];
        this.classes = new KClass[reader.getColumnCount()];
        int n = reader.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object columnName = reader.getColumnName(i);
            names[i] = columnName != null ? columnName.toString() : null;
            this.classes[i] = reader.getClass(i);
        }
        Object[] previousRow = null;
        if (reader.getRowCount() == -1) {
            int n2;
            int dataFound;
            List rows = new ArrayList();
            while (reader.hasMoreRow()) {
                reader.nextRow();
                if (!reader.hasMoreColumn()) continue;
                Object[] row = new Object[reader.getColumnCount()];
                dataFound = 0;
                n2 = reader.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    Object feature = null;
                    if (reader.hasMoreColumn()) {
                        feature = reader.nextColumn();
                        if (feature == null) continue;
                        row[i] = feature;
                        if (previousRow != null && previousRow[i] != null && Intrinsics.areEqual((Object)previousRow[i], (Object)row[i])) {
                            row[i] = previousRow[i];
                        }
                        dataFound = 1;
                        continue;
                    }
                    row[i] = null;
                }
                if (dataFound == 0) continue;
                rows.add(row);
                previousRow = row;
            }
            row = 0;
            dataFound = rows.size();
            Object[][] objectArrayArray = new Object[dataFound][];
            var11_29 = this;
            while (row < dataFound) {
                n2 = row++;
                objectArrayArray[n2] = rows.get(n2);
            }
            var11_29.objects = objectArrayArray;
        } else {
            int n3;
            int rows = 0;
            row = reader.getRowCount();
            Object[][] dataFound = new Object[row][];
            var11_29 = this;
            while (rows < row) {
                n3 = rows++;
                dataFound[n3] = new Object[reader.getColumnCount()];
            }
            var11_29.objects = dataFound;
            row = reader.getRowCount();
            for (int row = 0; row < row; ++row) {
                n3 = reader.getColumnCount();
                for (int column = 0; column < n3; ++column) {
                    Object o = reader.nextColumn();
                    if (row > 0 && this.objects[row - 1][column] != null && Intrinsics.areEqual((Object)this.objects[row - 1][column], (Object)o)) {
                        o = this.objects[row - 1][column];
                    }
                    this.objects[row][column] = o;
                }
                reader.nextRow();
            }
        }
        Object[] columns = new String[names.length];
        Set unique = new HashSet();
        int n4 = names.length;
        for (int i = 0; i < n4; ++i) {
            if (names[i] != null) {
                String header;
                Intrinsics.checkNotNull((Object)names[i]);
                int c = 0;
                while (unique.contains(header)) {
                    header = (String)header + "-" + c;
                }
                columns[i] = header;
                unique.add(header);
                continue;
            }
            columns[i] = String.valueOf(i);
        }
        String[] stringArray = (String[])ArraysKt.requireNoNulls((Object[])columns);
        this.columnIndex = new DefaultUniqueIndex<String>(Arrays.copyOf(stringArray, stringArray.length));
        this.rowIndex = new IntegerRangeUniqueIndex(0, ((Object[])this.objects).length - 1);
        if (autoConverter != null && !reader.isHasClassHeader()) {
            this.autoConvert(autoConverter);
        }
    }

    public /* synthetic */ SimpleDataFrame(DataFrameReader dataFrameReader, AutoConverter autoConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            autoConverter = null;
        }
        this(dataFrameReader, autoConverter);
    }

    @Override
    @NotNull
    public KClass<?> getRowClass(int integer) {
        return Reflection.getOrCreateKotlinClass(Object.class);
    }

    @Override
    @NotNull
    public KClass<?> getColumnClass(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        KClass<?> kClass = this.classes[((DefaultUniqueIndex)this.getColumnIndex()).getAddress(s)];
        Intrinsics.checkNotNull(kClass);
        return kClass;
    }

    @Override
    @Nullable
    public Object getValueAt(int row, @NotNull String column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.objects[row][((DefaultUniqueIndex)this.getColumnIndex()).getAddress(column)];
    }

    @Override
    public void setValueAt(int row, @NotNull String column, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        if (this.objects[row][((DefaultUniqueIndex)this.getColumnIndex()).getAddress(column)] != value) {
            this.objects[row][((DefaultUniqueIndex)this.getColumnIndex()).getAddress(column)] = value;
            this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
        }
    }

    private final void autoConvert(AutoConverter autoConverter) {
        boolean fireEvent = false;
        int column = 0;
        int n = this.getColumnCount();
        while (column < n) {
            int c = column++;
            TypeConverter.Input input2 = new TypeConverter.Input(this, c){
                final /* synthetic */ SimpleDataFrame this$0;
                final /* synthetic */ int $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                }

                public KClass<?> getType() {
                    return this.this$0.getColumnClass((String)this.this$0.getColumnKey(this.$c));
                }

                public Object get(int index) {
                    return this.this$0.getValueAt(index, (String)this.this$0.getColumnKey(this.$c));
                }

                public int size() {
                    return this.this$0.getRowCount();
                }
            };
            TypeConverter.Output output2 = new TypeConverter.Output(this, c){
                final /* synthetic */ SimpleDataFrame this$0;
                final /* synthetic */ int $c;
                {
                    this.this$0 = $receiver;
                    this.$c = $c;
                }

                public void setType(KClass<?> type) {
                    SimpleDataFrame.access$getClasses$p((SimpleDataFrame)this.this$0)[this.$c] = type;
                }

                public void set(int index, Object value) {
                    SimpleDataFrame.access$getObjects$p((SimpleDataFrame)this.this$0)[index][this.$c] = value;
                }
            };
            fireEvent |= autoConverter.convert(input2, output2);
        }
        if (fireEvent) {
            this.notifyDataFrameChanged(new DataFrameEvent(null, null, true));
        }
    }

    public static final /* synthetic */ KClass[] access$getClasses$p(SimpleDataFrame $this) {
        return $this.classes;
    }

    public static final /* synthetic */ Object[][] access$getObjects$p(SimpleDataFrame $this) {
        return $this.objects;
    }
}

