/*
 * Decompiled with CFR 0.152.
 */
package org.molap.exporter;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.dataframe.DataFrame;
import org.molap.exporter.DataFrameWriter;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005JI\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010\u0018JQ\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0019JI\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u00112\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u001cJK\u0010\u001d\u001a\u00020\n\"\u0004\b\u0000\u0010\u0010\"\u0004\b\u0001\u0010\u0011\"\u0004\b\u0002\u0010\u00122\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00120\u00142\u0006\u0010\u0015\u001a\u0002H\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0004\u00a2\u0006\u0002\u0010\u001eR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/molap/exporter/AbstractDataFrameWriter;", "Lorg/molap/exporter/DataFrameWriter;", "<init>", "()V", "timeZone", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "containsTime", "", "", "", "start", "", "setTimeZone", "dateToString", "", "Row", "Column", "Value", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "column", "date", "Ljava/util/Date;", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/util/Date;)Ljava/lang/String;", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/util/Date;Ljava/util/TimeZone;)Ljava/lang/String;", "getDateFormat", "Ljava/text/DateFormat;", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/util/TimeZone;)Ljava/text/DateFormat;", "hasTime", "(Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/util/TimeZone;)Z", "Companion", "molap"})
public abstract class AbstractDataFrameWriter
implements DataFrameWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private TimeZone timeZone = TimeZone.getTimeZone("UTC");
    @NotNull
    private final Map<Object, Boolean> containsTime = new HashMap();
    @NotNull
    private static final DecimalFormat decimalFormat = new DecimalFormat("#################0.#################", new DecimalFormatSymbols(Locale.ENGLISH));

    @Override
    public void start() throws IOException {
    }

    public final void setTimeZone(@NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        this.timeZone = timeZone;
    }

    @NotNull
    public final <Row, Column, Value> String dateToString(@NotNull DataFrame<Row, Column, Value> dataFrame, Column column, @Nullable Date date) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        TimeZone timeZone = this.timeZone;
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"timeZone");
        return this.dateToString(dataFrame, column, date, timeZone);
    }

    @NotNull
    public final <Row, Column, Value> String dateToString(@NotNull DataFrame<Row, Column, Value> dataFrame, Column column, @Nullable Date date, @NotNull TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        Intrinsics.checkNotNullParameter((Object)timeZone, (String)"timeZone");
        DateFormat dateFormat = this.getDateFormat(dataFrame, column, timeZone);
        String string = dateFormat.format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    private final <Row, Column, Value> DateFormat getDateFormat(DataFrame<Row, Column, Value> dataFrame, Column column, TimeZone timeZone) {
        DateFormat dateFormat = null;
        dateFormat = this.hasTime(dataFrame, column, timeZone) ? (DateFormat)new SimpleDateFormat("dd.MM.yyyy HH:mm:ss") : (DateFormat)new SimpleDateFormat("yyyy-MM-dd");
        dateFormat.setTimeZone(timeZone);
        return dateFormat;
    }

    protected final <Row, Column, Value> boolean hasTime(@NotNull DataFrame<Row, Column, Value> dataFrame, Column column, @Nullable TimeZone timeZone) {
        Intrinsics.checkNotNullParameter(dataFrame, (String)"dataFrame");
        if (!this.containsTime.containsKey(column)) {
            boolean containsTime = false;
            for (Row row : dataFrame.rows()) {
                Date value = (Date)dataFrame.getValueAt(row, column);
                if (value == null) continue;
                Calendar calendar = Calendar.getInstance(timeZone);
                calendar.setTime(value);
                if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) continue;
                containsTime = true;
            }
            this.containsTime.put(column, containsTime);
        }
        Boolean bl = this.containsTime.get(column);
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/molap/exporter/AbstractDataFrameWriter$Companion;", "", "<init>", "()V", "decimalFormat", "Ljava/text/DecimalFormat;", "numberToString", "", "value", "", "molap"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String numberToString(@Nullable Number value) {
            String string;
            if (value == null) {
                return "";
            }
            if (value instanceof Double) {
                double v = value.doubleValue();
                String string2 = Double.isNaN(v) || Double.isInfinite(v) ? decimalFormat.format(value.doubleValue()) : new BigDecimal(v, new MathContext(15, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
                Intrinsics.checkNotNull((Object)string2);
                string = string2;
            } else if (value instanceof Float) {
                float v = value.floatValue();
                String string3 = Float.isNaN(v) || Float.isInfinite(v) ? decimalFormat.format(value) : new BigDecimal(v, new MathContext(6, RoundingMode.HALF_EVEN)).stripTrailingZeros().toPlainString();
                Intrinsics.checkNotNull((Object)string3);
                string = string3;
            } else if (value instanceof Long) {
                long v = value.longValue();
                String string4 = Long.toString(v);
                Intrinsics.checkNotNull((Object)string4);
                string = string4;
            } else if (value instanceof Integer) {
                int v = value.intValue();
                String string5 = Integer.toString(v);
                Intrinsics.checkNotNull((Object)string5);
                string = string5;
            } else if (value instanceof Byte) {
                byte v = value.byteValue();
                String string6 = Byte.toString(v);
                Intrinsics.checkNotNull((Object)string6);
                string = string6;
            } else if (value instanceof Short) {
                short v = value.shortValue();
                String string7 = Short.toString(v);
                Intrinsics.checkNotNull((Object)string7);
                string = string7;
            } else if (value instanceof BigDecimal) {
                String string8 = ((BigDecimal)value).toPlainString();
                Intrinsics.checkNotNull((Object)string8);
                string = string8;
            } else {
                string = value.toString();
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

